/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.api;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.glowroot.agent.plugin.api.internal.ReadableQueryMessage;

public abstract class QueryMessage {
    private static final ImmutableMap<String, Object> EMPTY_DETAIL = ImmutableMap.of();

    public static QueryMessage create(String prefix) {
        return new QueryMessageImpl(prefix, "", (Map)EMPTY_DETAIL);
    }

    public static QueryMessage create(String prefix, String suffix) {
        return new QueryMessageImpl(prefix, suffix, (Map)EMPTY_DETAIL);
    }

    public static QueryMessage create(String prefix, String suffix, Map<String, ?> detail) {
        return new QueryMessageImpl(prefix, suffix, detail);
    }

    private QueryMessage() {
    }

    private static class QueryMessageImpl
    extends QueryMessage
    implements ReadableQueryMessage {
        private final String prefix;
        private final String suffix;
        private final Map<String, ?> detail;

        private QueryMessageImpl(String prefix, String suffix, Map<String, ?> detail) {
            this.prefix = prefix;
            this.suffix = suffix;
            this.detail = detail;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public String getSuffix() {
            return this.suffix;
        }

        @Override
        public Map<String, ?> getDetail() {
            return this.detail;
        }
    }
}

