/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.api.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.Logger;

public class Reflection {
    private static final Logger logger = Agent.getLogger(Reflection.class);

    private Reflection() {
    }

    @Nullable
    public static Method getMethod(@Nullable Class<?> clazz, String methodName) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), e);
            return null;
        }
    }

    @Nullable
    public static Field getDeclaredField(@Nullable Class<?> clazz, String fieldName) {
        if (clazz == null) {
            return null;
        }
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), e);
            return null;
        }
    }

    public static <T> T invoke(@Nullable Method method, Object obj) {
        if (method == null) {
            return null;
        }
        try {
            return (T)method.invoke(obj, new Object[0]);
        }
        catch (Throwable t) {
            logger.warn("error calling {}.{}()", method.getDeclaringClass().getName(), method.getName(), t);
            return null;
        }
    }

    public static <T> T invokeWithDefault(@Nullable Method method, Object obj, T defaultValue) {
        if (method == null) {
            return defaultValue;
        }
        try {
            Object value = method.invoke(obj, new Object[0]);
            if (value == null) {
                return defaultValue;
            }
            return (T)value;
        }
        catch (Throwable t) {
            logger.warn("error calling {}.{}()", method.getDeclaringClass().getName(), method.getName(), t);
            return defaultValue;
        }
    }

    @Nullable
    public static Object getFieldValue(@Nullable Field field, Object obj) {
        if (field == null) {
            return null;
        }
        try {
            return field.get(obj);
        }
        catch (Throwable t) {
            logger.warn("error getting {}.{}()", field.getDeclaringClass().getName(), field.getName(), t);
            return null;
        }
    }
}

