/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.apachehttpclient;

import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpUriRequest;
import org.glowroot.instrumentation.apachehttpclient.boot.HttpRequestMessageSupplier;
import org.glowroot.instrumentation.apachehttpclient.boot.Util;
import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.Getter;
import org.glowroot.instrumentation.api.Setter;
import org.glowroot.instrumentation.api.Span;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.api.weaving.Bind;

public class ApacheHttpClient4xInstrumentation {
    private static final TimerName TIMER_NAME = Agent.getTimerName((String)"http client request");
    private static final Setter<HttpUriRequest> URI_REQUEST_SETTER = new HttpUriRequestSetter();
    private static final Setter<HttpRequest> REQUEST_SETTER = new HttpRequestSetter();
    private static final Getter<HttpResponse> GETTER = new HttpResponseGetter();

    private static void onReturnCommon(@Nullable HttpResponse response, @Nullable Span span) {
        if (span != null) {
            if (response != null) {
                StatusLine statusLine = response.getStatusLine();
                HttpRequestMessageSupplier supplier = (HttpRequestMessageSupplier)((Object)span.getMessageSupplier());
                if (statusLine != null && supplier != null) {
                    supplier.setStatusCode(statusLine.getStatusCode());
                }
                span.extractFromResponse((Object)response, GETTER);
            }
            span.end();
        }
    }

    private static void onThrowCommon(Throwable t, @Nullable Span span) {
        if (span != null) {
            span.endWithError(t);
        }
    }

    private static class HttpResponseGetter
    implements Getter<HttpResponse> {
        private HttpResponseGetter() {
        }

        @Nullable
        public String get(HttpResponse carrier, String key) {
            Header header = carrier.getFirstHeader(key);
            if (header == null) {
                return null;
            }
            return header.getValue();
        }
    }

    private static class HttpRequestSetter
    implements Setter<HttpRequest> {
        private HttpRequestSetter() {
        }

        public void put(HttpRequest carrier, String key, String value) {
            carrier.setHeader(key, value);
        }
    }

    private static class HttpUriRequestSetter
    implements Setter<HttpUriRequest> {
        private HttpUriRequestSetter() {
        }

        public void put(HttpUriRequest carrier, String key, String value) {
            carrier.setHeader(key, value);
        }
    }

    @Advice.Pointcut(className="org.apache.http.client.HttpClient", methodName="execute", methodParameterTypes={"org.apache.http.HttpHost", "org.apache.http.HttpRequest", ".."}, nestingGroup="http-client")
    public static class ExecuteWithHostAdvice {
        @Advice.OnMethodBefore
        @Nullable
        public static Span onBefore(@Bind.Argument(value=0) @Nullable HttpHost hostObj, @Bind.Argument(value=1) @Nullable HttpRequest request, ThreadContext context) {
            if (request == null) {
                return null;
            }
            RequestLine requestLine = request.getRequestLine();
            return Util.startOutgoingSpan(context, requestLine.getMethod(), hostObj == null ? null : hostObj.toURI(), requestLine.getUri(), REQUEST_SETTER, request, TIMER_NAME);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Return @Nullable HttpResponse response, @Bind.Enter @Nullable Span span) {
            ApacheHttpClient4xInstrumentation.onReturnCommon(response, span);
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter @Nullable Span span) {
            ApacheHttpClient4xInstrumentation.onThrowCommon(t, span);
        }
    }

    @Advice.Pointcut(className="org.apache.http.client.HttpClient", methodName="execute", methodParameterTypes={"org.apache.http.client.methods.HttpUriRequest", ".."}, nestingGroup="http-client")
    public static class ExecuteAdvice {
        @Advice.OnMethodBefore
        @Nullable
        public static Span onBefore(@Bind.Argument(value=0) @Nullable HttpUriRequest request, ThreadContext context) {
            if (request == null) {
                return null;
            }
            return Util.startOutgoingSpan(context, request.getMethod(), null, request.getURI().toString(), URI_REQUEST_SETTER, request, TIMER_NAME);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Return @Nullable HttpResponse response, @Bind.Enter @Nullable Span span) {
            ApacheHttpClient4xInstrumentation.onReturnCommon(response, span);
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter @Nullable Span span) {
            ApacheHttpClient4xInstrumentation.onThrowCommon(t, span);
        }
    }
}

