/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.apachehttpclient.boot;

import java.util.HashMap;
import org.glowroot.instrumentation.api.Message;
import org.glowroot.instrumentation.api.MessageSupplier;
import org.glowroot.instrumentation.api.checker.Nullable;

public class HttpRequestMessageSupplier
extends MessageSupplier {
    private static final String PREFIX = "http client request: ";
    @Nullable
    private final String httpMethod;
    @Nullable
    private final String host;
    @Nullable
    private final String uri;
    private int statusCode = -1;

    HttpRequestMessageSupplier(@Nullable String httpMethod, @Nullable String host, @Nullable String uri) {
        this.httpMethod = httpMethod;
        this.host = host;
        this.uri = uri;
    }

    public Message get() {
        int messageLength = PREFIX.length();
        if (this.httpMethod != null) {
            messageLength += this.httpMethod.length() + 1;
        }
        if (this.host != null) {
            messageLength += this.host.length();
        }
        if (this.uri != null) {
            messageLength += this.uri.length();
        }
        StringBuilder message = new StringBuilder(messageLength);
        message.append(PREFIX);
        HashMap<String, Object> detail = new HashMap<String, Object>();
        if (this.httpMethod != null) {
            detail.put("Method", this.httpMethod);
            message.append(this.httpMethod);
            message.append(' ');
        }
        if (this.host != null) {
            detail.put("Host", this.host);
            message.append(this.host);
        }
        if (this.uri != null) {
            detail.put("URI", this.uri);
            message.append(this.uri);
        }
        if (this.statusCode >= 0) {
            detail.put("Result", this.statusCode);
        }
        return Message.create((String)message.toString(), detail);
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }
}

