/*
 * Decompiled with CFR 0.152.
 */
package fs2.data.cbor.json;

import fs2.Chunk;
import fs2.Chunk$;
import fs2.Pull;
import fs2.Pull$;
import fs2.RaiseThrowable;
import fs2.Stream;
import fs2.Stream$;
import fs2.data.cbor.CborParsingException;
import fs2.data.cbor.CborParsingException$;
import fs2.data.cbor.HalfFloat$;
import fs2.data.cbor.Tags$;
import fs2.data.cbor.low.CborItem;
import fs2.data.json.Token;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scodec.bits.ByteVector;

public final class package$ {
    public static package$ MODULE$;
    private final BigInt minusOne;

    static {
        new package$();
    }

    private Set<Object> knownTags() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{Tags$.MODULE$.PositiveBigNum(), Tags$.MODULE$.NegativeBigNum(), Tags$.MODULE$.ExpectedBase64Encoding(), Tags$.MODULE$.ExpectedBase64UrlEncoding(), Tags$.MODULE$.ExpectedBase16Encoding()}));
    }

    private BigInt minusOne() {
        return this.minusOne;
    }

    public <F> Function1<Stream<F, CborItem>, Stream<F, Token>> decodeItems(RaiseThrowable<F> F) {
        return (Function1 & Serializable & scala.Serializable)s -> Pull.StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps(this.go$1(Chunk$.MODULE$.empty(), 0, (Stream)s, new ListBuffer(), F)));
    }

    private final Token decode$1(long tag, ByteVector bytes) {
        long l = tag;
        if (Tags$.MODULE$.PositiveBigNum() == l) {
            return new Token.NumberValue(scala.package$.MODULE$.BigInt().apply(bytes.toArray()).toString(10));
        }
        if (Tags$.MODULE$.NegativeBigNum() == l) {
            return new Token.NumberValue(this.minusOne().$minus(scala.package$.MODULE$.BigInt().apply(bytes.toArray())).toString(10));
        }
        return new Token.StringValue(package$.decodeString$1(tag, bytes));
    }

    private static final String decodeString$1(long tag, ByteVector bytes) {
        long l = tag;
        if (Tags$.MODULE$.PositiveBigNum() == l) {
            return bytes.toBase64UrlNoPad();
        }
        if (Tags$.MODULE$.NegativeBigNum() == l) {
            return new java.lang.StringBuilder(1).append("~").append(bytes.toBase64UrlNoPad()).toString();
        }
        if (Tags$.MODULE$.ExpectedBase64UrlEncoding() == l) {
            return bytes.toBase64UrlNoPad();
        }
        if (Tags$.MODULE$.ExpectedBase64Encoding() == l) {
            return bytes.toBase64();
        }
        if (Tags$.MODULE$.ExpectedBase16Encoding() == l) {
            return bytes.toBase16();
        }
        return bytes.toBase64UrlNoPad();
    }

    private final Pull tokenizeTextStrings$1(Chunk chunk, int idx, Stream rest, StringBuilder acc, ListBuffer chunkAcc, RaiseThrowable F$1) {
        CborItem cborItem;
        while (true) {
            if (idx >= chunk.size()) {
                return Pull$.MODULE$.output(Chunk$.MODULE$.seq((Seq)chunkAcc.result())).$greater$greater((Function0 & Serializable & scala.Serializable)() -> Stream.ToPull$.MODULE$.uncons$extension(Stream.InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(rest))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Some some;
                    Tuple2 tuple2;
                    Option option = x0$1;
                    if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                        Chunk hd = (Chunk)tuple2._1();
                        Stream tl = (Stream)tuple2._2();
                        chunkAcc.clear();
                        return this.tokenizeTextStrings$1(hd, 0, tl, acc, chunkAcc, F$1);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return Pull$.MODULE$.raiseError((Throwable)new CborParsingException("unexpected end of input", CborParsingException$.MODULE$.$lessinit$greater$default$2()), F$1);
                    }
                    throw new MatchError((Object)option);
                }));
            }
            cborItem = (CborItem)chunk.apply(idx);
            if (!(cborItem instanceof CborItem.TextString)) break;
            CborItem.TextString textString = (CborItem.TextString)cborItem;
            String s = textString.string();
            acc = acc.append(s);
            ++idx;
        }
        if (CborItem.Break$.MODULE$.equals(cborItem)) {
            return Pull$.MODULE$.pure((Object)new Tuple5((Object)chunk, (Object)BoxesRunTime.boxToInteger((int)(idx + 1)), (Object)rest, (Object)chunkAcc, (Object)acc.result()));
        }
        return Pull$.MODULE$.raiseError((Throwable)new CborParsingException(new java.lang.StringBuilder(21).append("unexpected CBOR item ").append(cborItem).toString(), CborParsingException$.MODULE$.$lessinit$greater$default$2()), F$1);
    }

    private final Pull tokenizeByteStrings$1(Chunk chunk, int idx, Stream rest, long tag, StringBuilder acc, ListBuffer chunkAcc, RaiseThrowable F$1) {
        CborItem cborItem;
        while (true) {
            if (idx >= chunk.size()) {
                return Pull$.MODULE$.output(Chunk$.MODULE$.seq((Seq)chunkAcc.result())).$greater$greater((Function0 & Serializable & scala.Serializable)() -> Stream.ToPull$.MODULE$.uncons$extension(Stream.InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(rest))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Some some;
                    Tuple2 tuple2;
                    Option option = x0$1;
                    if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                        Chunk hd = (Chunk)tuple2._1();
                        Stream tl = (Stream)tuple2._2();
                        chunkAcc.clear();
                        return this.tokenizeByteStrings$1(hd, 0, tl, tag, acc, chunkAcc, F$1);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return Pull$.MODULE$.raiseError((Throwable)new CborParsingException("unexpected end of input", CborParsingException$.MODULE$.$lessinit$greater$default$2()), F$1);
                    }
                    throw new MatchError((Object)option);
                }));
            }
            cborItem = (CborItem)chunk.apply(idx);
            if (!(cborItem instanceof CborItem.ByteString)) break;
            CborItem.ByteString byteString = (CborItem.ByteString)cborItem;
            ByteVector s = byteString.bytes();
            acc = acc.append((Object)this.decode$1(tag, s));
            ++idx;
        }
        if (CborItem.Break$.MODULE$.equals(cborItem)) {
            return Pull$.MODULE$.pure((Object)new Tuple5((Object)chunk, (Object)BoxesRunTime.boxToInteger((int)(idx + 1)), (Object)rest, (Object)chunkAcc, (Object)acc.result()));
        }
        return Pull$.MODULE$.raiseError((Throwable)new CborParsingException(new java.lang.StringBuilder(21).append("unexpected CBOR item ").append(cborItem).toString(), CborParsingException$.MODULE$.$lessinit$greater$default$2()), F$1);
    }

    private final Pull tokenizeMap$1(Chunk chunk, int idx, Stream rest, Option tag, long count, ListBuffer chunkAcc, RaiseThrowable F$1) {
        if (count == 0L) {
            return Pull$.MODULE$.pure((Object)new Tuple4((Object)chunk, (Object)BoxesRunTime.boxToInteger((int)idx), (Object)rest, (Object)chunkAcc.$plus$eq((Object)Token.EndObject$.MODULE$)));
        }
        if (idx >= chunk.size()) {
            return Pull$.MODULE$.output(Chunk$.MODULE$.seq((Seq)chunkAcc.result())).$greater$greater((Function0 & Serializable & scala.Serializable)() -> Stream.ToPull$.MODULE$.uncons$extension(Stream.InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(rest))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Some some;
                Tuple2 tuple2;
                Option option = x0$1;
                if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                    Chunk hd = (Chunk)tuple2._1();
                    Stream tl = (Stream)tuple2._2();
                    chunkAcc.clear();
                    return this.tokenizeMap$1(hd, 0, tl, tag, count, chunkAcc, F$1);
                }
                if (None$.MODULE$.equals(option)) {
                    return Pull$.MODULE$.raiseError((Throwable)new CborParsingException("unexpected end of input", CborParsingException$.MODULE$.$lessinit$greater$default$2()), F$1);
                }
                throw new MatchError((Object)option);
            }));
        }
        CborItem cborItem = (CborItem)chunk.apply(idx);
        if (CborItem.Break$.MODULE$.equals(cborItem) && count == -1L) {
            return Pull$.MODULE$.pure((Object)new Tuple4((Object)chunk, (Object)BoxesRunTime.boxToInteger((int)(idx + 1)), (Object)rest, (Object)chunkAcc.$plus$eq((Object)Token.EndObject$.MODULE$)));
        }
        if (cborItem instanceof CborItem.TextString) {
            CborItem.TextString textString = (CborItem.TextString)cborItem;
            String k = textString.string();
            return this.tokenizeValue$1(chunk, idx + 1, rest, tag, chunkAcc.$plus$eq((Object)new Token.Key(k)), F$1).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple4 tuple4 = x0$2;
                if (tuple4 != null) {
                    Chunk chunk = (Chunk)tuple4._1();
                    int idx = BoxesRunTime.unboxToInt((Object)tuple4._2());
                    Stream rest = (Stream)tuple4._3();
                    ListBuffer chunkAcc = (ListBuffer)tuple4._4();
                    return this.tokenizeMap$1(chunk, idx, rest, tag, scala.math.package$.MODULE$.max(-1L, count - 1L), chunkAcc, F$1);
                }
                throw new MatchError((Object)tuple4);
            });
        }
        if (CborItem.StartIndefiniteTextString$.MODULE$.equals(cborItem)) {
            return this.tokenizeTextStrings$1(chunk, idx + 1, rest, new StringBuilder(), chunkAcc, F$1).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple5 tuple5 = x0$3;
                if (tuple5 != null) {
                    Chunk chunk = (Chunk)tuple5._1();
                    int idx = BoxesRunTime.unboxToInt((Object)tuple5._2());
                    Stream rest = (Stream)tuple5._3();
                    ListBuffer chunkAcc = (ListBuffer)tuple5._4();
                    String s = (String)tuple5._5();
                    return this.tokenizeValue$1(chunk, idx, rest, (Option)None$.MODULE$, chunkAcc.$plus$eq((Object)new Token.Key(s)), F$1).flatMap((Function1 & Serializable & scala.Serializable)x0$4 -> {
                        Tuple4 tuple4 = x0$4;
                        if (tuple4 != null) {
                            Chunk chunk = (Chunk)tuple4._1();
                            int idx = BoxesRunTime.unboxToInt((Object)tuple4._2());
                            Stream rest = (Stream)tuple4._3();
                            ListBuffer chunkAcc = (ListBuffer)tuple4._4();
                            return this.tokenizeMap$1(chunk, idx, rest, tag, scala.math.package$.MODULE$.max(-1L, count - 1L), chunkAcc, F$1);
                        }
                        throw new MatchError((Object)tuple4);
                    });
                }
                throw new MatchError((Object)tuple5);
            });
        }
        if (cborItem instanceof CborItem.ByteString) {
            CborItem.ByteString byteString = (CborItem.ByteString)cborItem;
            ByteVector bytes = byteString.bytes();
            return this.tokenizeValue$1(chunk, idx + 1, rest, (Option)None$.MODULE$, chunkAcc.$plus$eq((Object)new Token.Key(package$.decodeString$1(BoxesRunTime.unboxToLong((Object)tag.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)), bytes))), F$1).flatMap((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Tuple4 tuple4 = x0$5;
                if (tuple4 != null) {
                    Chunk chunk = (Chunk)tuple4._1();
                    int idx = BoxesRunTime.unboxToInt((Object)tuple4._2());
                    Stream rest = (Stream)tuple4._3();
                    ListBuffer chunkAcc = (ListBuffer)tuple4._4();
                    return this.tokenizeMap$1(chunk, idx, rest, tag, scala.math.package$.MODULE$.max(-1L, count - 1L), chunkAcc, F$1);
                }
                throw new MatchError((Object)tuple4);
            });
        }
        if (CborItem.StartIndefiniteByteString$.MODULE$.equals(cborItem)) {
            return this.tokenizeByteStrings$1(chunk, idx + 1, rest, BoxesRunTime.unboxToLong((Object)tag.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)), new StringBuilder(), chunkAcc, F$1).flatMap((Function1 & Serializable & scala.Serializable)x0$6 -> {
                Tuple5 tuple5 = x0$6;
                if (tuple5 != null) {
                    Chunk chunk = (Chunk)tuple5._1();
                    int idx = BoxesRunTime.unboxToInt((Object)tuple5._2());
                    Stream rest = (Stream)tuple5._3();
                    ListBuffer chunkAcc = (ListBuffer)tuple5._4();
                    String s = (String)tuple5._5();
                    return this.tokenizeValue$1(chunk, idx, rest, (Option)None$.MODULE$, chunkAcc.$plus$eq((Object)new Token.Key(s)), F$1).flatMap((Function1 & Serializable & scala.Serializable)x0$7 -> {
                        Tuple4 tuple4 = x0$7;
                        if (tuple4 != null) {
                            Chunk chunk = (Chunk)tuple4._1();
                            int idx = BoxesRunTime.unboxToInt((Object)tuple4._2());
                            Stream rest = (Stream)tuple4._3();
                            ListBuffer chunkAcc = (ListBuffer)tuple4._4();
                            return this.tokenizeMap$1(chunk, idx, rest, tag, scala.math.package$.MODULE$.max(-1L, count - 1L), chunkAcc, F$1);
                        }
                        throw new MatchError((Object)tuple4);
                    });
                }
                throw new MatchError((Object)tuple5);
            });
        }
        return Pull$.MODULE$.raiseError((Throwable)new CborParsingException(new java.lang.StringBuilder(28).append("unepexted CBOR item ").append(cborItem).append(" for key").toString(), CborParsingException$.MODULE$.$lessinit$greater$default$2()), F$1);
    }

    private final Pull tokenizeArray$1(Chunk chunk, int idx, Stream rest, Option tag, long count, ListBuffer chunkAcc, RaiseThrowable F$1) {
        if (count == 0L) {
            return Pull$.MODULE$.pure((Object)new Tuple4((Object)chunk, (Object)BoxesRunTime.boxToInteger((int)idx), (Object)rest, (Object)chunkAcc.$plus$eq((Object)Token.EndArray$.MODULE$)));
        }
        if (idx >= chunk.size()) {
            return Pull$.MODULE$.output(Chunk$.MODULE$.seq((Seq)chunkAcc.result())).$greater$greater((Function0 & Serializable & scala.Serializable)() -> Stream.ToPull$.MODULE$.uncons$extension(Stream.InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(rest))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Some some;
                Tuple2 tuple2;
                Option option = x0$1;
                if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                    Chunk hd = (Chunk)tuple2._1();
                    Stream tl = (Stream)tuple2._2();
                    chunkAcc.clear();
                    return this.tokenizeArray$1(hd, 0, tl, tag, count, chunkAcc, F$1);
                }
                if (None$.MODULE$.equals(option)) {
                    return Pull$.MODULE$.raiseError((Throwable)new CborParsingException("unexpected end of input", CborParsingException$.MODULE$.$lessinit$greater$default$2()), F$1);
                }
                throw new MatchError((Object)option);
            }));
        }
        CborItem cborItem = (CborItem)chunk.apply(idx);
        if (CborItem.Break$.MODULE$.equals(cborItem) && count == -1L) {
            return Pull$.MODULE$.pure((Object)new Tuple4((Object)chunk, (Object)BoxesRunTime.boxToInteger((int)(idx + 1)), (Object)rest, (Object)chunkAcc.$plus$eq((Object)Token.EndArray$.MODULE$)));
        }
        return this.tokenizeValue$1(chunk, idx, rest, tag, chunkAcc, F$1).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple4 tuple4 = x0$2;
            if (tuple4 != null) {
                Chunk chunk = (Chunk)tuple4._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple4._2());
                Stream rest = (Stream)tuple4._3();
                ListBuffer chunkAcc = (ListBuffer)tuple4._4();
                return this.tokenizeArray$1(chunk, idx, rest, tag, scala.math.package$.MODULE$.max(-1L, count - 1L), chunkAcc, F$1);
            }
            throw new MatchError((Object)tuple4);
        });
    }

    private final Pull tokenizeValue$1(Chunk chunk, int idx, Stream rest, Option tag, ListBuffer chunkAcc, RaiseThrowable F$1) {
        CborItem cborItem;
        while (true) {
            if (idx >= chunk.size()) {
                return Pull$.MODULE$.output(Chunk$.MODULE$.seq((Seq)chunkAcc.result())).$greater$greater((Function0 & Serializable & scala.Serializable)() -> Stream.ToPull$.MODULE$.uncons$extension(Stream.InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(rest))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Some some;
                    Tuple2 tuple2;
                    Option option = x0$1;
                    if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                        Chunk hd = (Chunk)tuple2._1();
                        Stream tl = (Stream)tuple2._2();
                        chunkAcc.clear();
                        return this.tokenizeValue$1(hd, 0, tl, tag, chunkAcc, F$1);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return Pull$.MODULE$.raiseError((Throwable)new CborParsingException("unexpected end of input", CborParsingException$.MODULE$.$lessinit$greater$default$2()), F$1);
                    }
                    throw new MatchError((Object)option);
                }));
            }
            CborItem item = (CborItem)chunk.apply(idx);
            cborItem = item;
            if (!(cborItem instanceof CborItem.Tag)) break;
            CborItem.Tag tag2 = (CborItem.Tag)cborItem;
            long t = tag2.tag();
            if (this.knownTags().contains((Object)BoxesRunTime.boxToLong((long)t))) {
                tag = new Some((Object)BoxesRunTime.boxToLong((long)t));
                ++idx;
                continue;
            }
            ++idx;
        }
        if (cborItem instanceof CborItem.TextString) {
            CborItem.TextString textString = (CborItem.TextString)cborItem;
            String s = textString.string();
            return Pull$.MODULE$.pure((Object)new Tuple4((Object)chunk, (Object)BoxesRunTime.boxToInteger((int)(idx + 1)), (Object)rest, (Object)chunkAcc.$plus$eq((Object)new Token.StringValue(s))));
        }
        if (CborItem.StartIndefiniteTextString$.MODULE$.equals(cborItem)) {
            return this.tokenizeTextStrings$1(chunk, idx + 1, rest, new StringBuilder(), chunkAcc, F$1).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple5 tuple5 = x0$2;
                if (tuple5 != null) {
                    Chunk chunk = (Chunk)tuple5._1();
                    int idx = BoxesRunTime.unboxToInt((Object)tuple5._2());
                    Stream rest = (Stream)tuple5._3();
                    ListBuffer chunkAcc = (ListBuffer)tuple5._4();
                    String s = (String)tuple5._5();
                    return new Tuple4((Object)chunk, (Object)BoxesRunTime.boxToInteger((int)idx), (Object)rest, (Object)chunkAcc.$plus$eq((Object)new Token.StringValue(s)));
                }
                throw new MatchError((Object)tuple5);
            });
        }
        if (cborItem instanceof CborItem.ByteString) {
            CborItem.ByteString byteString = (CborItem.ByteString)cborItem;
            ByteVector bytes = byteString.bytes();
            return Pull$.MODULE$.pure((Object)new Tuple4((Object)chunk, (Object)BoxesRunTime.boxToInteger((int)(idx + 1)), (Object)rest, (Object)chunkAcc.$plus$eq((Object)this.decode$1(BoxesRunTime.unboxToLong((Object)tag.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)), bytes))));
        }
        if (CborItem.StartIndefiniteByteString$.MODULE$.equals(cborItem)) {
            return this.tokenizeByteStrings$1(chunk, idx + 1, rest, BoxesRunTime.unboxToLong((Object)tag.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)), new StringBuilder(), chunkAcc, F$1).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple5 tuple5 = x0$3;
                if (tuple5 != null) {
                    Chunk chunk = (Chunk)tuple5._1();
                    int idx = BoxesRunTime.unboxToInt((Object)tuple5._2());
                    Stream rest = (Stream)tuple5._3();
                    ListBuffer chunkAcc = (ListBuffer)tuple5._4();
                    String s = (String)tuple5._5();
                    return new Tuple4((Object)chunk, (Object)BoxesRunTime.boxToInteger((int)idx), (Object)rest, (Object)chunkAcc.$plus$eq((Object)new Token.StringValue(s)));
                }
                throw new MatchError((Object)tuple5);
            });
        }
        if (CborItem.False$.MODULE$.equals(cborItem)) {
            return Pull$.MODULE$.pure((Object)new Tuple4((Object)chunk, (Object)BoxesRunTime.boxToInteger((int)(idx + 1)), (Object)rest, (Object)chunkAcc.$plus$eq((Object)Token.FalseValue$.MODULE$)));
        }
        if (CborItem.True$.MODULE$.equals(cborItem)) {
            return Pull$.MODULE$.pure((Object)new Tuple4((Object)chunk, (Object)BoxesRunTime.boxToInteger((int)(idx + 1)), (Object)rest, (Object)chunkAcc.$plus$eq((Object)Token.TrueValue$.MODULE$)));
        }
        if (CborItem.Null$.MODULE$.equals(cborItem)) {
            return Pull$.MODULE$.pure((Object)new Tuple4((Object)chunk, (Object)BoxesRunTime.boxToInteger((int)(idx + 1)), (Object)rest, (Object)chunkAcc.$plus$eq((Object)Token.NullValue$.MODULE$)));
        }
        if (CborItem.Undefined$.MODULE$.equals(cborItem)) {
            return Pull$.MODULE$.pure((Object)new Tuple4((Object)chunk, (Object)BoxesRunTime.boxToInteger((int)(idx + 1)), (Object)rest, (Object)chunkAcc.$plus$eq((Object)new Token.StringValue("undefined"))));
        }
        if (cborItem instanceof CborItem.SimpleValue) {
            CborItem.SimpleValue simpleValue = (CborItem.SimpleValue)cborItem;
            byte value = simpleValue.value();
            return Pull$.MODULE$.pure((Object)new Tuple4((Object)chunk, (Object)BoxesRunTime.boxToInteger((int)(idx + 1)), (Object)rest, (Object)chunkAcc.$plus$eq((Object)new Token.StringValue(new java.lang.StringBuilder(8).append("simple(").append(value & 0xFF).append(")").toString()))));
        }
        if (cborItem instanceof CborItem.PositiveInt) {
            CborItem.PositiveInt positiveInt = (CborItem.PositiveInt)cborItem;
            ByteVector bytes = positiveInt.bytes();
            return Pull$.MODULE$.pure((Object)new Tuple4((Object)chunk, (Object)BoxesRunTime.boxToInteger((int)(idx + 1)), (Object)rest, (Object)chunkAcc.$plus$eq((Object)new Token.NumberValue(scala.package$.MODULE$.BigInt().apply(bytes.toHex(), 16).toString(10)))));
        }
        if (cborItem instanceof CborItem.NegativeInt) {
            CborItem.NegativeInt negativeInt = (CborItem.NegativeInt)cborItem;
            ByteVector bytes = negativeInt.bytes();
            return Pull$.MODULE$.pure((Object)new Tuple4((Object)chunk, (Object)BoxesRunTime.boxToInteger((int)(idx + 1)), (Object)rest, (Object)chunkAcc.$plus$eq((Object)new Token.NumberValue(this.minusOne().$minus(scala.package$.MODULE$.BigInt().apply(bytes.toHex(), 16)).toString(10)))));
        }
        if (cborItem instanceof CborItem.Float16) {
            CborItem.Float16 float16 = (CborItem.Float16)cborItem;
            ByteVector raw = float16.raw();
            float hf = HalfFloat$.MODULE$.toFloat(raw.toShort(false, raw.toShort$default$2()));
            return Pull$.MODULE$.pure((Object)new Tuple4((Object)chunk, (Object)BoxesRunTime.boxToInteger((int)(idx + 1)), (Object)rest, (Object)chunkAcc.$plus$eq(Float.isFinite(hf) ? new Token.NumberValue(Float.toString(hf)) : new Token.StringValue(Float.toString(hf)))));
        }
        if (cborItem instanceof CborItem.Float32) {
            CborItem.Float32 float32 = (CborItem.Float32)cborItem;
            ByteVector raw = float32.raw();
            float f = Float.intBitsToFloat(raw.toInt(false, raw.toInt$default$2()));
            return Pull$.MODULE$.pure((Object)new Tuple4((Object)chunk, (Object)BoxesRunTime.boxToInteger((int)(idx + 1)), (Object)rest, (Object)chunkAcc.$plus$eq(Float.isFinite(f) ? new Token.NumberValue(Float.toString(f)) : new Token.StringValue(Float.toString(f)))));
        }
        if (cborItem instanceof CborItem.Float64) {
            CborItem.Float64 float64 = (CborItem.Float64)cborItem;
            ByteVector raw = float64.raw();
            double d = Double.longBitsToDouble(raw.toLong(false, raw.toLong$default$2()));
            return Pull$.MODULE$.pure((Object)new Tuple4((Object)chunk, (Object)BoxesRunTime.boxToInteger((int)(idx + 1)), (Object)rest, (Object)chunkAcc.$plus$eq(Double.isFinite(d) ? new Token.NumberValue(Double.toString(d)) : new Token.StringValue(Double.toString(d)))));
        }
        if (cborItem instanceof CborItem.StartArray) {
            CborItem.StartArray startArray = (CborItem.StartArray)cborItem;
            long size = startArray.size();
            return this.tokenizeArray$1(chunk, idx + 1, rest, tag, size, chunkAcc.$plus$eq((Object)Token.StartArray$.MODULE$), F$1);
        }
        if (CborItem.StartIndefiniteArray$.MODULE$.equals(cborItem)) {
            return this.tokenizeArray$1(chunk, idx + 1, rest, tag, -1L, chunkAcc.$plus$eq((Object)Token.StartArray$.MODULE$), F$1);
        }
        if (cborItem instanceof CborItem.StartMap) {
            CborItem.StartMap startMap = (CborItem.StartMap)cborItem;
            long size = startMap.size();
            return this.tokenizeMap$1(chunk, idx + 1, rest, tag, size, chunkAcc.$plus$eq((Object)Token.StartObject$.MODULE$), F$1);
        }
        if (CborItem.StartIndefiniteMap$.MODULE$.equals(cborItem)) {
            return this.tokenizeMap$1(chunk, idx + 1, rest, tag, -1L, chunkAcc.$plus$eq((Object)Token.StartObject$.MODULE$), F$1);
        }
        if (CborItem.Break$.MODULE$.equals(cborItem)) {
            return Pull$.MODULE$.raiseError((Throwable)new CborParsingException("unexpected break", CborParsingException$.MODULE$.$lessinit$greater$default$2()), F$1);
        }
        throw new MatchError((Object)cborItem);
    }

    private final Pull go$1(Chunk chunk, int idx, Stream rest, ListBuffer chunkAcc, RaiseThrowable F$1) {
        if (idx >= chunk.size()) {
            return Pull$.MODULE$.output(Chunk$.MODULE$.seq((Seq)chunkAcc.result())).$greater$greater((Function0 & Serializable & scala.Serializable)() -> Stream.ToPull$.MODULE$.uncons$extension(Stream.InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(rest))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Some some;
                Tuple2 tuple2;
                Option option = x0$1;
                if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                    Chunk hd = (Chunk)tuple2._1();
                    Stream tl = (Stream)tuple2._2();
                    chunkAcc.clear();
                    return this.go$1(hd, 0, tl, chunkAcc, F$1);
                }
                if (None$.MODULE$.equals(option)) {
                    return Pull$.MODULE$.done();
                }
                throw new MatchError((Object)option);
            }));
        }
        return this.tokenizeValue$1(chunk, idx, rest, (Option)None$.MODULE$, chunkAcc, F$1).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple4 tuple4 = x0$2;
            if (tuple4 != null) {
                Chunk chunk = (Chunk)tuple4._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple4._2());
                Stream rest = (Stream)tuple4._3();
                ListBuffer chunkAcc = (ListBuffer)tuple4._4();
                return this.go$1(chunk, idx, rest, chunkAcc, F$1);
            }
            throw new MatchError((Object)tuple4);
        });
    }

    private package$() {
        MODULE$ = this;
        this.minusOne = scala.package$.MODULE$.BigInt().apply(-1);
    }
}

