/*
 * Decompiled with CFR 0.152.
 */
package fs2.data.json.cbor;

import fs2.Chunk;
import fs2.Chunk$;
import fs2.Stream;
import fs2.data.cbor.Tags$;
import fs2.data.cbor.low.CborItem;
import fs2.data.json.Token;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.Seq;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.runtime.BoxesRunTime;
import scodec.bits.ByteVector$;

public final class package$ {
    public static package$ MODULE$;

    static {
        new package$();
    }

    public <F> Function1<Stream<F, Token>, Stream<F, CborItem>> encodeItems() {
        return (Function1 & Serializable & scala.Serializable)x$1 -> x$1.mapChunks((Function1 & Serializable & scala.Serializable)chunk -> chunk.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Token token = x0$1;
            if (Token.FalseValue$.MODULE$.equals(token)) {
                return Chunk$.MODULE$.singleton((Object)CborItem.False$.MODULE$);
            }
            if (Token.TrueValue$.MODULE$.equals(token)) {
                return Chunk$.MODULE$.singleton((Object)CborItem.True$.MODULE$);
            }
            if (Token.NullValue$.MODULE$.equals(token)) {
                return Chunk$.MODULE$.singleton((Object)CborItem.Null$.MODULE$);
            }
            if (token instanceof Token.StringValue) {
                Token.StringValue stringValue = (Token.StringValue)token;
                String s = stringValue.value();
                return Chunk$.MODULE$.singleton((Object)new CborItem.TextString(s));
            }
            if (token instanceof Token.NumberValue) {
                Token.NumberValue numberValue = (Token.NumberValue)token;
                String raw = numberValue.value();
                return MODULE$.makeNumber(raw);
            }
            if (Token.StartArray$.MODULE$.equals(token)) {
                return Chunk$.MODULE$.singleton((Object)CborItem.StartIndefiniteArray$.MODULE$);
            }
            if (Token.EndArray$.MODULE$.equals(token)) {
                return Chunk$.MODULE$.singleton((Object)CborItem.Break$.MODULE$);
            }
            if (Token.StartObject$.MODULE$.equals(token)) {
                return Chunk$.MODULE$.singleton((Object)CborItem.StartIndefiniteMap$.MODULE$);
            }
            if (token instanceof Token.Key) {
                Token.Key key = (Token.Key)token;
                String k = key.value();
                return Chunk$.MODULE$.singleton((Object)new CborItem.TextString(k));
            }
            if (Token.EndObject$.MODULE$.equals(token)) {
                return Chunk$.MODULE$.singleton((Object)CborItem.Break$.MODULE$);
            }
            throw new MatchError((Object)token);
        }));
    }

    private Chunk<CborItem> makeNumber(String raw) {
        return this.makeNumber(scala.package$.MODULE$.BigDecimal().apply(raw));
    }

    private Chunk<CborItem> makeNumber(BigDecimal bd) {
        if (bd.isWhole()) {
            if (bd.$greater$eq((Object)BigDecimal$.MODULE$.int2bigDecimal(0))) {
                BigInt bi = bd.toBigInt();
                if (bi.isValidLong()) {
                    return Chunk$.MODULE$.singleton((Object)new CborItem.PositiveInt(ByteVector$.MODULE$.apply(bi.toByteArray())));
                }
                return Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{new CborItem.Tag(Tags$.MODULE$.PositiveBigNum()), new CborItem.ByteString(ByteVector$.MODULE$.apply(bi.toByteArray()).dropWhile((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)package$.$anonfun$makeNumber$1(BoxesRunTime.unboxToByte((Object)x$2)))))}));
            }
            BigInt bi = bd.toBigInt().$plus(BigInt$.MODULE$.int2bigInt(1)).abs();
            if (bi.isValidLong()) {
                return Chunk$.MODULE$.singleton((Object)new CborItem.NegativeInt(ByteVector$.MODULE$.apply(bi.toByteArray())));
            }
            return Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{new CborItem.Tag(Tags$.MODULE$.NegativeBigNum()), new CborItem.ByteString(ByteVector$.MODULE$.apply(bi.toByteArray()).dropWhile((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)package$.$anonfun$makeNumber$2(BoxesRunTime.unboxToByte((Object)x$3)))))}));
        }
        if (bd.isBinaryFloat()) {
            return Chunk$.MODULE$.singleton((Object)new CborItem.Float32(ByteVector$.MODULE$.fromInt(Float.floatToIntBits(bd.toFloat()), ByteVector$.MODULE$.fromInt$default$2(), ByteVector$.MODULE$.fromInt$default$3())));
        }
        if (bd.isBinaryDouble()) {
            return Chunk$.MODULE$.singleton((Object)new CborItem.Float64(ByteVector$.MODULE$.fromLong(Double.doubleToLongBits(bd.toDouble()), ByteVector$.MODULE$.fromLong$default$2(), ByteVector$.MODULE$.fromLong$default$3())));
        }
        BigDecimal unscaled = scala.package$.MODULE$.BigDecimal().apply(BigInt$.MODULE$.javaBigInteger2bigInt(bd.underlying().unscaledValue()));
        BigDecimal scale = scala.package$.MODULE$.BigDecimal().apply(-bd.underlying().scale());
        return Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{new CborItem.Tag(Tags$.MODULE$.DecimalFraction()), new CborItem.StartArray(2L)})).$plus$plus(this.makeNumber(scale)).$plus$plus(this.makeNumber(unscaled));
    }

    public static final /* synthetic */ boolean $anonfun$makeNumber$1(byte x$2) {
        return x$2 == 0;
    }

    public static final /* synthetic */ boolean $anonfun$makeNumber$2(byte x$3) {
        return x$3 == 0;
    }

    private package$() {
        MODULE$ = this;
    }
}

