/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.base.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.ConfigFactory;
import org.gorpipe.base.config.annotations.ConfigComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager {
    private static final Logger log = LoggerFactory.getLogger(ConfigManager.class);
    private static String configRootPath = null;
    private static final List<Map<?, ?>> globalProperties = new ArrayList();
    private static final ConcurrentHashMap<String, Config> prefixConfigMap = new ConcurrentHashMap();

    private ConfigManager() {
    }

    public static void setConfigRootPath(String configRootPath) {
        if (!((String)configRootPath).endsWith("/")) {
            log.trace("Config root path should end with a trailing slash. Appending it automatically.");
            configRootPath = (String)configRootPath + "/";
        }
        if (ConfigManager.configRootPath != null && !ConfigManager.configRootPath.isEmpty()) {
            log.debug("Overriding previously set configuration root path {} with {}", (Object)ConfigManager.configRootPath, configRootPath);
        }
        log.debug("Using configuration root path: {}", configRootPath);
        ConfigManager.configRootPath = configRootPath;
    }

    public static String getConfigRootPath() {
        return configRootPath;
    }

    public static List<String> getDefaultConfigFileNamesForPrefix(String prefix) {
        ArrayList<String> files = new ArrayList<String>();
        List<String> parts = Arrays.asList(prefix.split(Pattern.quote("."), -1));
        for (int i = parts.size() - 1; i >= 0; --i) {
            String part = String.join((CharSequence)".", parts.subList(0, i + 1));
            ConfigManager.addFileIfNotNullOrEmpty(System.getProperty(part + ".config.file"), files);
            ConfigManager.addFileIfNotNullOrEmpty(configRootPath + part + ".props", files);
            ConfigManager.addFileIfNotNullOrEmpty(configRootPath + part + ".props.defaults", files);
        }
        return files;
    }

    private static void addFileIfNotNullOrEmpty(String fileName, List<String> files) {
        if (fileName != null && !fileName.isEmpty() && !fileName.isBlank()) {
            files.add(fileName);
        }
    }

    private static List<Properties> loadDefaultConfigPropertiesForPrefix(String prefix) {
        ArrayList<Properties> props = new ArrayList<Properties>();
        for (String fileName : ConfigManager.getDefaultConfigFileNamesForPrefix(prefix)) {
            try {
                if (fileName != null && !fileName.isEmpty() && Files.exists(Paths.get(fileName, new String[0]), new LinkOption[0])) {
                    Properties p = new Properties();
                    p.load(new FileInputStream(new File(fileName)));
                    props.add(p);
                    log.debug("Loaded configuration file {}", (Object)fileName);
                    continue;
                }
                log.trace("Not loading configuration file {}", (Object)fileName);
            }
            catch (IOException e) {
                log.warn("Unable to load configuration file {} - ignoring", (Object)fileName, (Object)e);
            }
        }
        return props;
    }

    public static void addGlobalPropertiesSource(Map<?, ?> properties) {
        globalProperties.add(properties);
    }

    public static void removeGlobalPropertiesSource(Map<?, ?> properties) {
        globalProperties.remove(properties);
    }

    public static void clearGlobalPropertiesSources() {
        globalProperties.clear();
    }

    public static void clearPrefixConfigCache() {
        prefixConfigMap.clear();
    }

    public static <T extends Config> T getPrefixConfig(String prefix, Class<? extends T> clazz, Map<?, ?> ... configs) {
        String key = prefix + "_" + clazz.getName();
        if (prefixConfigMap.containsKey(key)) {
            return (T)((Config)clazz.cast(prefixConfigMap.get(key)));
        }
        T config = ConfigManager.createPrefixConfig(prefix, clazz, configs);
        prefixConfigMap.putIfAbsent(key, (Config)config);
        return config;
    }

    public static <T extends Config> T getPrefixConfig(Class<? extends T> clazz, Map<?, ?> ... configs) {
        ConfigComponent configComponentAnnotation = clazz.getAnnotation(ConfigComponent.class);
        if (configComponentAnnotation != null) {
            return ConfigManager.getPrefixConfig(configComponentAnnotation.value(), clazz, configs);
        }
        log.warn("Expected a ConfigComponent annotation on configuration interface {} but found none. Loading only with system properties.", (Object)clazz.getName());
        return ConfigManager.createConfig(clazz, configs);
    }

    public static <T extends Config> T createPrefixConfig(Class<? extends T> clazz, Map<?, ?> ... configs) {
        ConfigComponent configComponentAnnotation = clazz.getAnnotation(ConfigComponent.class);
        if (configComponentAnnotation != null) {
            return ConfigManager.createPrefixConfig(configComponentAnnotation.value(), clazz, configs);
        }
        log.warn("Expected a ConfigComponent annotation on configuration interface {} but found none. Loading only with system properties.", (Object)clazz.getName());
        return ConfigManager.createConfig(clazz, configs);
    }

    public static <T extends Config> T createPrefixConfig(String prefix, Class<? extends T> clazz, Map<?, ?> ... configs) {
        ArrayList allConfigs = new ArrayList();
        allConfigs.add(System.getProperties());
        allConfigs.addAll(Arrays.asList(configs));
        allConfigs.add(System.getenv());
        allConfigs.addAll(ConfigManager.loadDefaultConfigPropertiesForPrefix(prefix));
        allConfigs.addAll(globalProperties);
        return ConfigManager.createConfig(clazz, allConfigs.toArray(new Map[allConfigs.size()]));
    }

    public static <T extends Config> T createConfig(Class<? extends T> clazz, Map<?, ?> ... configs) {
        return (T)ConfigFactory.create(clazz, (Map[])configs);
    }

    public static String[] getKeysForConfig(Class<? extends Config> clazz) {
        return (String[])Arrays.stream(clazz.getDeclaredMethods()).filter(m -> m.getAnnotation(Config.Key.class) != null).map(m -> m.getAnnotation(Config.Key.class).value()).toArray(String[]::new);
    }

    public static String getMajorMinorVersionFromString(String version) {
        Pattern p;
        Matcher m;
        Object displayVersion = "";
        if (version != null && !version.isEmpty() && (m = (p = Pattern.compile("[0-9]+\\.[0-9]+")).matcher(version)).find()) {
            displayVersion = (String)displayVersion + m.group();
        }
        return displayVersion;
    }

    public static void injectProperties(Properties props, Properties config, ArrayList<String> filter) {
        for (String propertyName : props.stringPropertyNames()) {
            String newValue = props.getProperty(propertyName);
            if (config.getProperty(propertyName) != null && config.getProperty(propertyName).equals(newValue)) continue;
            if (filter.contains(propertyName)) {
                log.info("Ignoring property {} because it is a startup argument", (Object)propertyName);
                continue;
            }
            config.setProperty(propertyName, newValue);
        }
    }

    static {
        Object configRootPath = null;
        String syspropConfigPath = System.getProperty("nextcode.config.path");
        if (syspropConfigPath != null && !syspropConfigPath.isEmpty()) {
            configRootPath = syspropConfigPath;
            log.debug("Config path determined from system property");
        } else {
            try {
                ProtectionDomain protectionDomain = ConfigManager.class.getProtectionDomain();
                CodeSource codeSource = protectionDomain.getCodeSource();
                String sourcePath = codeSource.getLocation().getPath();
                if (sourcePath != null && !sourcePath.isEmpty()) {
                    configRootPath = new File(sourcePath).getParent() + "/../config/";
                    log.debug("Config path determined from code source location");
                }
            }
            catch (Exception t) {
                log.warn("Problem determining configuration root path.", (Throwable)t);
            }
        }
        if (configRootPath == null || ((String)configRootPath).isEmpty()) {
            configRootPath = System.getProperty("user.dir");
            log.debug("Config path determined from working directory");
        }
        ConfigManager.setConfigRootPath((String)configRootPath);
    }
}

