/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.base.config.bytesize;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.gorpipe.base.config.bytesize.ByteSizeStandard;

public enum ByteSizeUnit {
    BYTES("", "B", ByteSizeStandard.SI, 0),
    KILOBYTES("kilo", "KB", ByteSizeStandard.SI, 1),
    KIBIBYTES("kibi", "KiB", ByteSizeStandard.IEC, 1),
    MEGABYTES("mega", "MB", ByteSizeStandard.SI, 2),
    MEBIBYTES("mebi", "MiB", ByteSizeStandard.IEC, 2),
    GIGABYTES("giga", "GB", ByteSizeStandard.SI, 3),
    GIBIBYTES("gibi", "GiB", ByteSizeStandard.IEC, 3),
    TERABYTES("tera", "TB", ByteSizeStandard.SI, 4),
    TEBIBYTES("tebi", "TiB", ByteSizeStandard.IEC, 4),
    PETABYTES("peta", "PB", ByteSizeStandard.SI, 5),
    PEBIBYTES("pebi", "PiB", ByteSizeStandard.IEC, 5),
    EXABYTES("exa", "EB", ByteSizeStandard.SI, 6),
    EXBIBYTES("exbi", "EiB", ByteSizeStandard.IEC, 6),
    ZETTABYTES("zetta", "ZB", ByteSizeStandard.SI, 7),
    ZEBIBYTES("zebi", "ZiB", ByteSizeStandard.IEC, 7),
    YOTTABYTES("yotta", "YB", ByteSizeStandard.SI, 8),
    YOBIBYTES("yobi", "YiB", ByteSizeStandard.IEC, 8);

    final String prefix;
    final String shortLabel;
    final ByteSizeStandard standard;
    final int power;
    private static final Map<String, ByteSizeUnit> unitsMap;

    private ByteSizeUnit(String prefix, String shortLabel, ByteSizeStandard standard, int power) {
        this.prefix = prefix;
        this.shortLabel = shortLabel;
        this.standard = standard;
        this.power = power;
    }

    private static Map<String, ByteSizeUnit> makeUnitsMap() {
        HashMap<String, ByteSizeUnit> map = new HashMap<String, ByteSizeUnit>();
        for (ByteSizeUnit unit : ByteSizeUnit.values()) {
            map.put(unit.prefix + "byte", unit);
            map.put(unit.prefix + "bytes", unit);
            if (unit.prefix.length() == 0) {
                map.put("b", unit);
                map.put("", unit);
                continue;
            }
            String first = unit.prefix.substring(0, 1);
            if (unit.standard == ByteSizeStandard.IEC) {
                map.put(first, unit);
                map.put(first + "i", unit);
                map.put(first + "ib", unit);
                continue;
            }
            if (unit.standard == ByteSizeStandard.SI) {
                map.put(first + "b", unit);
                continue;
            }
            throw new RuntimeException("broken MemoryUnit enum");
        }
        return map;
    }

    public static ByteSizeUnit parse(String unit) {
        return unitsMap.get(unit.toLowerCase());
    }

    public boolean isSI() {
        return this.standard == ByteSizeStandard.SI;
    }

    public boolean isIEC() {
        return this.standard == ByteSizeStandard.IEC;
    }

    public BigDecimal getFactor() {
        return BigDecimal.valueOf(this.standard.powerOf).pow(this.power);
    }

    public String toStringLongForm() {
        return this.prefix + "bytes";
    }

    public String toStringShortForm() {
        return this.shortLabel;
    }

    static {
        unitsMap = ByteSizeUnit.makeUnitsMap();
    }
}

