/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.base.config.converters;

import java.lang.reflect.Method;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.aeonbits.owner.Converter;
import org.gorpipe.base.config.converters.ConverterUtil;

public class DurationConverter
implements Converter<Duration> {
    public Duration convert(Method method, String input) {
        if (input.startsWith("P") || input.startsWith("-P") || input.startsWith("+P")) {
            return Duration.parse(input);
        }
        return DurationConverter.parseDuration(input);
    }

    private static Duration parseDuration(String input) {
        String[] parts = ConverterUtil.splitNumericAndChar(input);
        String numberString = parts[0];
        String originalUnitString = parts[1];
        Object unitString = originalUnitString;
        if (numberString.length() == 0) {
            throw new IllegalArgumentException(String.format("No number in duration value '%s'", input));
        }
        if (((String)unitString).length() > 2 && !((String)unitString).endsWith("s")) {
            unitString = (String)unitString + "s";
        }
        return Duration.of(Long.parseLong(numberString), switch (unitString) {
            case "ns", "nanos", "nanoseconds" -> ChronoUnit.NANOS;
            case "us", "\u00b5s", "micros", "microseconds" -> ChronoUnit.MICROS;
            case "", "ms", "millis", "milliseconds" -> ChronoUnit.MILLIS;
            case "s", "seconds" -> ChronoUnit.SECONDS;
            case "m", "minutes" -> ChronoUnit.MINUTES;
            case "h", "hours" -> ChronoUnit.HOURS;
            case "d", "days" -> ChronoUnit.DAYS;
            default -> throw new IllegalArgumentException(String.format("Could not parse time unit '%s' (try ns, us, ms, s, m, h, d)", originalUnitString));
        });
    }
}

