/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.base.logging;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;

public class HostnameConverter
extends ClassicConverter {
    private static final String HOSTNAME = HostnameConverter.getHostName();

    public String convert(ILoggingEvent event) {
        return HOSTNAME;
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                return System.getenv("COMPUTERNAME");
            }
            try {
                Process p = Runtime.getRuntime().exec("hostname");
                p.waitFor();
                return IOUtils.toString((InputStream)p.getInputStream(), (Charset)Charset.defaultCharset()).trim();
            }
            catch (Exception p) {
                String hostname = System.getenv("HOSTNAME");
                if (hostname != null) {
                    return hostname;
                }
                return "Unknown";
            }
        }
    }
}

