/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.base.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.Status;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class LogbackUtil {
    public static final Marker MARKER_AUDIT = MarkerFactory.getDetachedMarker((String)"audit");

    private LogbackUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void configure(Path logFolder, String logName) {
        if (!LogbackUtil.foundLogConfigFile() && !LogbackUtil.createDefaultLogConfigFile()) {
            LogbackUtil.applyBasicLogConfig(logFolder, logName);
        }
    }

    public static boolean createDefaultLogConfigFile() {
        String logConfigFileStr = System.getProperty("logback.configurationFile");
        File logConfigFile = new File(logConfigFileStr != null ? logConfigFileStr : "logback.xml");
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            FileUtils.copyInputStreamToFile((InputStream)LogbackUtil.class.getClassLoader().getResourceAsStream("com/nextcode/logging/logback.default.xml"), (File)logConfigFile);
            loggerContext.reset();
            ContextInitializer ci = new ContextInitializer(loggerContext);
            URL url = logConfigFile.toURI().toURL();
            ci.configureByResource(url);
            return true;
        }
        catch (JoranException | IOException | NullPointerException e) {
            return false;
        }
    }

    public static boolean foundLogConfigFile() {
        LoggerContext logContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        List statusList = logContext.getStatusManager().getCopyOfStatusList();
        for (Status stat : statusList) {
            if (!stat.getMessage().contains("Could NOT find resource [logback.xml]")) continue;
            return false;
        }
        return true;
    }

    public static void applyBasicLogConfig(Path logFolder, String logName) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        String today = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String logFile = Paths.get(logFolder.toString(), logName + "_" + today + ".log").toFile().getAbsolutePath();
        PatternLayoutEncoder layoutEncoder = new PatternLayoutEncoder();
        layoutEncoder.setContext((Context)loggerContext);
        layoutEncoder.setPattern("%date %level \\(%file:%line\\) - %msg%ex%n");
        layoutEncoder.start();
        FileAppender fileAppender = new FileAppender();
        fileAppender.setPrudent(true);
        fileAppender.setEncoder((Encoder)layoutEncoder);
        fileAppender.setName("file");
        fileAppender.setContext((Context)loggerContext);
        fileAppender.setFile(logFile);
        fileAppender.start();
        root.addAppender((Appender)fileAppender);
        root.setLevel(Level.DEBUG);
        root.info("Logging to file {}", (Object)logFile);
    }
}

