/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.base.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.gorpipe.base.security.Credentials;
import org.gorpipe.base.security.CredentialsParser;
import org.gorpipe.base.security.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundledCredentials
implements CredentialsProvider {
    private static final Logger log = LoggerFactory.getLogger(BundledCredentials.class);
    private final ConcurrentMap<String, ConcurrentMap<String, Credentials>> svcToLookupMap;
    private final ConcurrentMap<String, Credentials> serviceToDefaultMap;
    private static final BundledCredentials emptyCredentials = new BundledCredentials();

    private BundledCredentials(ConcurrentMap<String, ConcurrentMap<String, Credentials>> svcMap, ConcurrentMap<String, Credentials> defMap) {
        this.svcToLookupMap = svcMap;
        this.serviceToDefaultMap = defMap;
    }

    private BundledCredentials() {
        this(new ConcurrentHashMap<String, ConcurrentMap<String, Credentials>>(), new ConcurrentHashMap<String, Credentials>());
    }

    public List<Credentials> getCredentials(String service, String lookupKey) {
        service = service.toLowerCase();
        Credentials cred = null;
        if (lookupKey != null) {
            Map lookup;
            lookupKey = lookupKey.toLowerCase();
            if (this.svcToLookupMap.get(service) != null && (lookup = (Map)this.svcToLookupMap.get(service)) != null) {
                cred = (Credentials)lookup.get(lookupKey);
            }
        }
        Credentials defaultCreds = (Credentials)this.serviceToDefaultMap.get(service);
        if (cred == null && defaultCreds == null) {
            return Collections.emptyList();
        }
        ArrayList<Credentials> result = new ArrayList<Credentials>();
        if (cred != null) {
            result.add(cred);
        }
        if (defaultCreds != null) {
            result.add(defaultCreds);
        }
        return result;
    }

    public List<Credentials> getCredentialsForService(String service) {
        service = service.toLowerCase();
        ArrayList<Credentials> result = new ArrayList<Credentials>();
        if (this.svcToLookupMap.get(service) != null) {
            Map lookup = (Map)this.svcToLookupMap.get(service);
            result.addAll(lookup.values());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BundledCredentials) {
            BundledCredentials other = (BundledCredentials)obj;
            return other.svcToLookupMap.equals(this.svcToLookupMap) && other.serviceToDefaultMap.equals(this.serviceToDefaultMap);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.svcToLookupMap, this.serviceToDefaultMap);
    }

    public Set<String> services() {
        TreeSet<String> svc = new TreeSet<String>();
        svc.addAll(this.svcToLookupMap.keySet());
        svc.addAll(this.serviceToDefaultMap.keySet());
        return svc;
    }

    private Map<String, Object> toMap() {
        HashMap<String, Object> bundle = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> creds = new ArrayList<Map<String, Object>>();
        for (Map map : this.svcToLookupMap.values()) {
            for (Credentials cred : map.values()) {
                creds.add(cred.toMap());
            }
        }
        bundle.put("credentials", creds);
        ArrayList<Map<String, Object>> defaults = new ArrayList<Map<String, Object>>();
        for (Credentials cred : this.serviceToDefaultMap.values()) {
            defaults.add(cred.toMap());
        }
        bundle.put("default_credentials", defaults);
        return bundle;
    }

    public String toJson() {
        StringWriter writer = new StringWriter();
        ObjectMapper mapper = new ObjectMapper();
        try {
            mapper.writeValue((Writer)writer, this.toMap());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ((Object)writer).toString();
    }

    public String toString() {
        StringBuilder b = new StringBuilder(super.toString());
        b.append("{");
        for (String service : this.svcToLookupMap.keySet()) {
            b.append(service);
            b.append(":(");
            ConcurrentMap map = (ConcurrentMap)this.svcToLookupMap.get(service);
            if (map != null) {
                b.append(StringUtils.join(map.keySet(), (String)","));
            }
            if (this.serviceToDefaultMap.get(service) != null) {
                b.append(",[Default]");
            } else {
                b.append(",[No Default]");
            }
            b.append(") ");
        }
        b.append("}");
        return b.toString();
    }

    public static String substring(String text, String prefix, String suffix) {
        int prefixIdx;
        if (text != null && (prefixIdx = text.indexOf(prefix)) >= 0) {
            int suffixIdx = text.indexOf(suffix, prefixIdx);
            return text.substring(prefixIdx + prefix.length(), suffixIdx > 0 ? suffixIdx : text.length());
        }
        return null;
    }

    public BundledCredentials clone() {
        return new Builder().addCredentials(this).build();
    }

    public static BundledCredentials emptyCredentials() {
        return emptyCredentials;
    }

    public static BundledCredentials fromSecurityContext(String securityContext) {
        log.debug("Creating bundle from securityContext: {}", (Object)securityContext);
        if (securityContext != null && securityContext.contains("cred_bundle=")) {
            String credString = BundledCredentials.substring(securityContext, "cred_bundle=", "|||");
            credString = credString.replaceAll(" .*|'", "");
            BundledCredentials result = BundledCredentials.fromBase64String(credString);
            log.debug("Got credentials {}", (Object)result);
            return result;
        }
        log.debug("No bundle found");
        return BundledCredentials.emptyCredentials();
    }

    private static BundledCredentials fromBase64String(String base64) {
        byte[] decoded = Base64.getUrlDecoder().decode(base64);
        return new CredentialsParser().parseBundle(BundledCredentials.parseJson(new String(decoded)));
    }

    private static Map<String, Object> parseJson(CharSequence json) throws IllegalArgumentException {
        try {
            return (Map)new ObjectMapper().readValue(json.toString(), HashMap.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot parse json string: " + json, e);
        }
    }

    public String toBase64String() {
        return Base64.getUrlEncoder().encodeToString(this.toJson().getBytes());
    }

    public String addToSecurityContext(String securityContext) {
        log.debug("Adding {} to securityContext {}", (Object)this, (Object)securityContext);
        Builder b = new Builder().addCredentials(BundledCredentials.fromSecurityContext(securityContext));
        b.addCredentials(this);
        String bundleCtx = "cred_bundle=" + b.build().toBase64String();
        String result = securityContext == null ? " -Z " + bundleCtx : securityContext + "|||" + bundleCtx;
        log.debug("Result: {}", (Object)result);
        return result;
    }

    public static BundledCredentials mergeBundledCredentials(BundledCredentials credentials1, BundledCredentials credentials2) {
        if (credentials1 == null) {
            return credentials2;
        }
        if (credentials2 == null) {
            return credentials1;
        }
        ConcurrentHashMap<String, ConcurrentMap<String, Credentials>> svcToLookupMapMerged = new ConcurrentHashMap<String, ConcurrentMap<String, Credentials>>();
        svcToLookupMapMerged.putAll(credentials1.svcToLookupMap);
        svcToLookupMapMerged.putAll(credentials2.svcToLookupMap);
        ConcurrentHashMap<String, Credentials> serviceToDefaultMapMerged = new ConcurrentHashMap<String, Credentials>();
        serviceToDefaultMapMerged.putAll(credentials1.serviceToDefaultMap);
        serviceToDefaultMapMerged.putAll(credentials2.serviceToDefaultMap);
        return new BundledCredentials(svcToLookupMapMerged, serviceToDefaultMapMerged);
    }

    public static class Builder {
        private ConcurrentMap<String, ConcurrentMap<String, Credentials>> svcToLookupMap = new ConcurrentHashMap<String, ConcurrentMap<String, Credentials>>();
        private ConcurrentMap<String, Credentials> serviceToDefaultMap = new ConcurrentHashMap<String, Credentials>();

        public Builder addCredentials(Credentials ... creds) {
            for (Credentials cred : creds) {
                ConcurrentMap<String, Credentials> m = this.getServiceMap(cred.getService());
                m.put(cred.getLookupKey(), cred);
                if (!cred.isUserDefault()) continue;
                this.addDefaultCredentials(cred);
            }
            return this;
        }

        public Builder addDefaultCredentials(Credentials creds) {
            this.serviceToDefaultMap.putIfAbsent(creds.getService(), creds);
            return this;
        }

        public Builder addCredentials(BundledCredentials creds) {
            for (ConcurrentMap credMap : creds.svcToLookupMap.values()) {
                for (Credentials cred : credMap.values()) {
                    this.addCredentials(cred);
                }
            }
            for (Credentials cred : creds.serviceToDefaultMap.values()) {
                this.addDefaultCredentials(cred);
            }
            return this;
        }

        private ConcurrentMap<String, Credentials> getServiceMap(String service) {
            return this.svcToLookupMap.computeIfAbsent(service, s -> new ConcurrentHashMap());
        }

        public BundledCredentials build() {
            BundledCredentials built = new BundledCredentials(this.svcToLookupMap, this.serviceToDefaultMap);
            this.svcToLookupMap = new ConcurrentHashMap<String, ConcurrentMap<String, Credentials>>();
            this.serviceToDefaultMap = new ConcurrentHashMap<String, Credentials>();
            return built;
        }
    }
}

