/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.base.security;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Credentials {
    public static Credentials NULL = new Credentials();
    private String service;
    private String lookupKey;
    private OwnerType ownerType;
    private String ownerId;
    private Instant expires;
    private Map<String, String> data;
    private boolean userDefault;

    public Credentials(String service, String lookupKey, OwnerType ownerType, String ownerId, Instant expires, boolean userDefault, String ... keyVals) {
        this(service, lookupKey, ownerType, ownerId, expires, userDefault, Credentials.makeMap(keyVals));
    }

    Credentials() {
    }

    public boolean isNull() {
        return this.data == null;
    }

    private static Map<String, String> makeMap(String ... keyVals) {
        HashMap<String, String> data = new HashMap<String, String>();
        for (int i = 0; i < keyVals.length; i += 2) {
            data.put(keyVals[i], keyVals[i + 1]);
        }
        return data;
    }

    public Credentials(String service, String lookupKey, OwnerType ownerType, String ownerId, Instant expires, boolean userDefault, Map<String, String> data) {
        this.service = service;
        this.lookupKey = lookupKey;
        this.ownerType = ownerType;
        this.ownerId = ownerId;
        this.expires = expires;
        this.data = new HashMap<String, String>();
        this.data.putAll(data);
        this.userDefault = userDefault;
    }

    public String getService() {
        return this.service;
    }

    public String getLookupKey() {
        return this.lookupKey;
    }

    public OwnerType getOwnerType() {
        return this.ownerType;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String get(String key) {
        if (this.isNull()) {
            return null;
        }
        return this.data.get(key);
    }

    public String getOrDefault(String key, String def) {
        if (this.isNull()) {
            return def;
        }
        return this.data.getOrDefault(key, def);
    }

    public String get(Attr key) {
        return this.get(key.jsonKey());
    }

    public String getOrDefault(Attr key, String def) {
        return this.getOrDefault(key.jsonKey(), def);
    }

    public Set<String> keys() {
        return this.data.keySet();
    }

    public boolean containsKey(Attr key) {
        return this.data.containsKey(key.jsonKey());
    }

    public Instant expires() {
        return this.expires;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Credentials) {
            return Objects.equals(this.data, ((Credentials)obj).data);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public boolean isValidFor(long value, TemporalUnit unit) {
        if (this.isNull()) {
            return false;
        }
        if (this.expires == null) {
            return true;
        }
        return this.expires.isAfter(Instant.now().plus(value, unit));
    }

    public boolean isValid() {
        return this.isValidFor(1L, ChronoUnit.SECONDS);
    }

    public boolean isUserDefault() {
        return this.userDefault;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(super.toString());
        this.append(result, new Object[]{"(Service: ", this.service, ",LookupKey: ", this.lookupKey, ",OwnerType: ", this.ownerType, ",OwnerId: ", this.ownerId, ",Expires: ", this.expires});
        this.append(result, ",Attributes: ", this.data, ")");
        return result.toString();
    }

    private void append(StringBuilder builder, Object ... stuffs) {
        for (Object stuff : stuffs) {
            builder.append(stuff);
        }
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("owner_type", this.ownerType == null ? null : this.ownerType.toString());
        result.put("owner_id", this.ownerId);
        result.put("service", this.service);
        result.put("lookup_key", this.lookupKey);
        result.put("expires", this.expires == null ? null : this.expires.toString());
        result.put("credential_attributes", this.data);
        result.put("user_default", this.userDefault);
        return result;
    }

    public static enum OwnerType {
        User,
        Project,
        System,
        Organization;


        public static OwnerType resolve(String s) {
            if (s == null) {
                return null;
            }
            return OwnerType.valueOf(s);
        }
    }

    public static enum Attr {
        REALM,
        SCOPE,
        NAME,
        KEY,
        SECRET,
        SESSION_TOKEN,
        API_ENDPOINT,
        REGION,
        AUTH_ENDPOINT;


        public String jsonKey() {
            return this.toString().toLowerCase();
        }
    }

    public static class Builder {
        Credentials cred = new Credentials();

        public Builder() {
            this.cred.data = new HashMap<String, String>();
        }

        public Builder service(String service) {
            if (service != null) {
                service = service.toLowerCase();
            }
            this.cred.service = service;
            return this;
        }

        public Builder lookupKey(String lookupKey) {
            if (lookupKey != null) {
                lookupKey = lookupKey.toLowerCase();
            }
            this.cred.lookupKey = lookupKey;
            return this;
        }

        public Builder ownerType(OwnerType ownerType) {
            this.cred.ownerType = ownerType;
            return this;
        }

        public Builder ownerId(String ownerId) {
            this.cred.ownerId = ownerId;
            return this;
        }

        public Builder expires(Instant expires) {
            this.cred.expires = expires;
            return this;
        }

        public Builder set(Attr attr, String value) {
            this.cred.data.put(attr.jsonKey(), value);
            return this;
        }

        public Builder set(String attr, String value) {
            this.cred.data.put(attr, value);
            return this;
        }

        public Builder setUserDefault(boolean flag) {
            this.cred.userDefault = flag;
            return this;
        }

        public Credentials build() {
            return new Credentials(this.cred.service, this.cred.lookupKey, this.cred.ownerType, this.cred.ownerId, this.cred.expires, this.cred.userDefault, this.cred.data);
        }
    }
}

