/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.base.security;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gorpipe.base.security.BundledCredentials;
import org.gorpipe.base.security.Credentials;

public class CredentialsParser {
    public Credentials parseFromJson(Map<String, Object> cred) {
        Object ownerId;
        Instant expires = CredentialsParser.parseIso8601Timestamp((String)cred.get("expires"));
        Credentials.Builder builder = new Credentials.Builder();
        builder.service((String)cred.get("service"));
        builder.lookupKey(this.nullBlank((String)cred.get("lookup_key")));
        builder.ownerType(Credentials.OwnerType.resolve(this.nullBlank((String)cred.get("owner_type"))));
        if (cred.get("user_default") instanceof Boolean) {
            builder.setUserDefault((Boolean)cred.get("user_default"));
        }
        if ((ownerId = cred.get("owner_id")) != null) {
            ownerId = ownerId.toString();
        }
        builder.ownerId(this.nullBlank((String)ownerId));
        builder.expires(expires);
        Map attributes = (Map)cred.get("credential_attributes");
        for (String key : attributes.keySet()) {
            String val = this.nullBlank((String)attributes.get(key));
            if (val == null) continue;
            builder.set(key, val);
        }
        return builder.build();
    }

    private String nullBlank(String s) {
        if (s != null && s.equals("")) {
            return null;
        }
        return s;
    }

    public List<Credentials> parseFromJson(List<Map<String, Object>> list) {
        ArrayList<Credentials> credList = new ArrayList<Credentials>();
        for (Map<String, Object> cred : list) {
            Credentials newCred = this.parseFromJson(cred);
            if (!newCred.isValid()) continue;
            credList.add(newCred);
        }
        return credList;
    }

    public BundledCredentials parseBundle(Map<String, Object> bundle) {
        BundledCredentials.Builder builder = new BundledCredentials.Builder();
        List credList = (List)bundle.get("credentials");
        if (credList != null) {
            for (Credentials cred : this.parseFromJson(credList)) {
                builder.addCredentials(cred);
            }
        }
        if ((credList = (List)bundle.get("default_credentials")) != null) {
            for (Credentials cred : this.parseFromJson(credList)) {
                builder.addDefaultCredentials(cred);
            }
        }
        return builder.build();
    }

    public static Instant parseIso8601Timestamp(CharSequence stamp) {
        if (stamp != null) {
            return Instant.from(ZonedDateTime.parse(stamp));
        }
        return null;
    }
}

