/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.exceptions;

import java.util.ArrayList;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.gorpipe.exceptions.GorDataException;
import org.gorpipe.exceptions.GorException;
import org.gorpipe.exceptions.GorMissingRelationException;
import org.gorpipe.exceptions.GorParsingException;
import org.gorpipe.exceptions.GorResourceException;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.exceptions.GorUserException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExceptionUtilities {
    private static boolean showStackTrace = Boolean.parseBoolean(System.getProperty("gor.server.stacktrace.enabled", "true"));
    private static final Logger log = LoggerFactory.getLogger(ExceptionUtilities.class);
    private static final String ERROR_TYPE = "errorType";
    private static final String GOR_MESSAGE = "gorMessage";
    private static final String MESSAGE = "message";
    private static final String REQUEST_ID = "requestId";
    private static final String QUERY = "query";
    private static final String COMMAND_NAME = "commandName";
    private static final String COMMAND_INDEX = "commandIndex";
    private static final String COMMAND_SOURCE = "commandSource";
    private static final String COMMAND = "command";
    private static final String EXTRA_INFO = "extraInfo";
    private static final String OPTION = "option";
    private static final String OPTION_VALUE = "optionValue";
    private static final String URI = "uri";
    private static final String HEADER = "header";
    private static final String ROW = "row";
    private static final String COLUMN_NUMBER = "columnNumber";
    private static final String STACK_TRACE = "stackTrace";

    private ExceptionUtilities() {
    }

    public static void setShowStackTrace(Boolean show) {
        showStackTrace = show;
    }

    public static String gorExceptionToString(Throwable exception) {
        if (exception instanceof GorParsingException) {
            return ExceptionUtilities.gorParsingExceptionToString((GorParsingException)exception);
        }
        if (exception instanceof GorResourceException) {
            return ExceptionUtilities.gorResourceExceptionToString((GorResourceException)exception);
        }
        if (exception instanceof GorDataException) {
            return ExceptionUtilities.gorDataExceptionToString((GorDataException)exception);
        }
        if (exception instanceof GorSystemException) {
            return ExceptionUtilities.gorSystemExceptionToString((GorSystemException)exception);
        }
        return "An error has occurred.\n" + exception.getMessage();
    }

    private static String gorParsingExceptionToString(GorParsingException exception) {
        String option = exception.getOption();
        String command = exception.getCommandName();
        String payload = exception.getPayload();
        String commandString = exception.getCommandStep();
        int commandIndex = exception.getCommandIndex();
        StringBuilder builder = new StringBuilder();
        builder.append("==== Parsing Error ====\n");
        if (ExceptionUtilities.isNullOrEmpty(command)) {
            if (commandIndex > 0) {
                builder.append(String.format("Command at pipe step #%1$s has some issues:%n%2$s", commandIndex, exception.getMessage()));
            } else {
                builder.append(exception.getMessage());
            }
        } else {
            if (ExceptionUtilities.isNullOrEmpty(option)) {
                builder.append(String.format("Command %1$S in pipe step #%2$s has some issues:%n%3$s", command, commandIndex, exception.getMessage()));
            } else {
                builder.append(String.format("Command %1$S in pipe step #%2$s has some issues in option %3$s:%n%4$s", command, commandIndex, payload.equals("") ? option : option + " " + payload, exception.getMessage()));
            }
            builder.append("\n\n");
            if (commandIndex > 1) {
                builder.append(String.format(" .. | %1$s | ..", commandString));
            } else {
                builder.append(String.format("  %1$s | ..", commandString));
            }
        }
        ExceptionUtilities.printCommandSource(exception, builder);
        ExceptionUtilities.printRequestId(exception, builder);
        ExceptionUtilities.printStackTrace(exception, builder);
        ExceptionUtilities.printEndMessage(builder);
        builder.append("\n");
        return builder.toString();
    }

    private static String gorResourceExceptionToString(GorResourceException exception) {
        String command = exception.getCommandName();
        int commandIndex = exception.getCommandIndex();
        String commandString = exception.getCommandStep();
        StringBuilder builder = new StringBuilder();
        builder.append("==== Resource Error ====\n");
        if (commandIndex < 0) {
            builder.append(exception.getMessage());
            if (!ExceptionUtilities.isNullOrEmpty(exception.getUri())) {
                builder.append("\n");
                builder.append("URI: ");
                builder.append(exception.getUri());
            }
        } else {
            builder.append(String.format("Command %1$S in pipe step #%2$s has a missing resource:%n%3$s", command, commandIndex, exception.getMessage()));
            if (!ExceptionUtilities.isNullOrEmpty(exception.getUri())) {
                builder.append("\n");
                builder.append("URI: ");
                builder.append(exception.getUri());
            }
            builder.append("\n\n");
            if (commandIndex > 1) {
                builder.append(String.format(" .. | %1$s | ..", commandString));
            } else {
                builder.append(String.format("  %1$s | ..", commandString));
            }
        }
        ExceptionUtilities.printCommandSource(exception, builder);
        ExceptionUtilities.printRequestId(exception, builder);
        ExceptionUtilities.printStackTrace(exception, builder);
        ExceptionUtilities.printEndMessage(builder);
        return builder.toString();
    }

    private static String gorDataExceptionToString(GorDataException exception) {
        StringBuilder builder = new StringBuilder();
        builder.append("==== Data Error ====\n");
        if (exception.getColumnNumber() == -1) {
            builder.append(exception.getMessage());
        } else {
            builder.append(String.format("An error has occurred in data column %2$d:%n%1$s", exception.getMessage(), exception.getColumnNumber()));
        }
        builder.append("\n");
        if (!ExceptionUtilities.isNullOrEmpty(exception.getHeader())) {
            builder.append("\n");
            builder.append("Header: ");
            builder.append(exception.getHeader());
        }
        if (!ExceptionUtilities.isNullOrEmpty(exception.getRow())) {
            builder.append("\n");
            builder.append("Row: ");
            builder.append(exception.getRow());
        }
        ExceptionUtilities.printCommandSource(exception, builder);
        ExceptionUtilities.printRequestId(exception, builder);
        ExceptionUtilities.printStackTrace(exception, builder);
        ExceptionUtilities.printEndMessage(builder);
        return builder.toString();
    }

    private static String gorSystemExceptionToString(GorSystemException exception) {
        StringBuilder builder = new StringBuilder();
        builder.append("==== System Error ====\n");
        builder.append(exception.getMessage());
        builder.append("\n");
        ExceptionUtilities.printRequestId(exception, builder);
        ExceptionUtilities.printStackTrace(exception, builder);
        ExceptionUtilities.printEndMessage(builder);
        return builder.toString();
    }

    public static synchronized String gorExceptionToJson(Throwable exception) {
        JSONObject obj = new JSONObject();
        obj.put((Object)ERROR_TYPE, (Object)ExceptionUtilities.getErrorType(exception));
        obj.put((Object)GOR_MESSAGE, (Object)ExceptionUtilities.gorExceptionToString(exception));
        obj.put((Object)MESSAGE, (Object)exception.getMessage());
        if (showStackTrace) {
            obj.put((Object)STACK_TRACE, (Object)ExceptionUtils.getStackTrace((Throwable)exception));
        }
        if (exception instanceof GorException) {
            obj.put((Object)REQUEST_ID, (Object)((GorException)exception).getRequestID());
        }
        if (exception instanceof GorUserException) {
            ExceptionUtilities.gorUserExceptionToJson((GorUserException)exception, obj);
        }
        if (exception instanceof GorParsingException) {
            ExceptionUtilities.gorParsingExceptionToJson((GorParsingException)exception, obj);
        } else if (exception instanceof GorResourceException) {
            ExceptionUtilities.gorResourceExceptionToJson((GorResourceException)exception, obj);
        } else if (exception instanceof GorDataException) {
            ExceptionUtilities.gorDataExceptionToJson((GorDataException)exception, obj);
        }
        return obj.toString();
    }

    private static void gorUserExceptionToJson(GorUserException exception, JSONObject obj) {
        ExceptionUtilities.addJsonEntry(QUERY, exception.getQuery(), obj);
        ExceptionUtilities.addJsonEntry(COMMAND_NAME, exception.getCommandName(), obj);
        ExceptionUtilities.addJsonEntry(COMMAND_INDEX, exception.getCommandIndex(), obj);
        ExceptionUtilities.addJsonEntry(COMMAND_SOURCE, exception.getQuerySource(), obj);
        ExceptionUtilities.addJsonEntry(COMMAND, exception.getCommandStep(), obj);
        ExceptionUtilities.addJsonEntry(EXTRA_INFO, exception.getExtraInfo(), obj);
    }

    private static void gorParsingExceptionToJson(GorParsingException exception, JSONObject obj) {
        ExceptionUtilities.addJsonEntry(OPTION, exception.getOption(), obj);
        ExceptionUtilities.addJsonEntry(OPTION_VALUE, exception.getPayload(), obj);
    }

    private static void gorResourceExceptionToJson(GorResourceException exception, JSONObject obj) {
        ExceptionUtilities.addJsonEntry(URI, exception.getUri(), obj);
    }

    private static void gorDataExceptionToJson(GorDataException exception, JSONObject obj) {
        ExceptionUtilities.addJsonEntry(HEADER, exception.getHeader(), obj);
        ExceptionUtilities.addJsonEntry(ROW, exception.getRow(), obj);
        ExceptionUtilities.addJsonEntry(COLUMN_NUMBER, exception.getColumnNumber(), obj);
    }

    private static void addJsonEntry(String name, String value, JSONObject obj) {
        if (!ExceptionUtilities.isNullOrEmpty(value)) {
            obj.put((Object)name, (Object)value);
        }
    }

    private static void addJsonEntry(String name, Integer value, JSONObject obj) {
        if (value >= 0) {
            obj.put((Object)name, (Object)value);
        }
    }

    private static String getErrorType(Throwable exception) {
        Class<?> enclosingClass = exception.getClass().getEnclosingClass();
        if (enclosingClass != null) {
            return enclosingClass.getSimpleName();
        }
        return exception.getClass().getSimpleName();
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static void printStackTrace(Throwable exception, StringBuilder builder) {
        if (!showStackTrace) {
            return;
        }
        builder.append("\n\n");
        builder.append("Stack Trace:\n");
        builder.append(ExceptionUtils.getStackTrace((Throwable)exception));
    }

    private static void printRequestId(GorException exception, StringBuilder builder) {
        String requestId = exception.getRequestID();
        if (ExceptionUtilities.isNullOrEmpty(requestId)) {
            return;
        }
        builder.append("\n\n");
        builder.append("Request ID: ");
        builder.append(requestId);
    }

    private static void printCommandSource(GorUserException exception, StringBuilder builder) {
        String commandSource = exception.getQuerySource();
        if (ExceptionUtilities.isNullOrEmpty(commandSource) || commandSource.equalsIgnoreCase("thepgorquery")) {
            return;
        }
        builder.append("\n\n");
        builder.append("Part of create statement: create ");
        builder.append(commandSource);
        builder.append(" = ...");
    }

    private static void printEndMessage(StringBuilder builder) {
        builder.append("\n");
    }

    public static synchronized GorException gorExceptionFromJson(String error) {
        GorException exception = null;
        JSONParser parser = new JSONParser();
        if (error == null || error.isEmpty()) {
            exception = new GorSystemException("Got error with null or empty json", null);
        } else {
            try {
                JSONObject obj = (JSONObject)parser.parse(error);
                if (obj.containsKey((Object)ERROR_TYPE)) {
                    String errorType = (String)obj.get((Object)ERROR_TYPE);
                    exception = errorType.startsWith("GorParsingException") ? ExceptionUtilities.createGorParsingExceptionFromJSON(obj) : (errorType.startsWith("GorDataException") ? ExceptionUtilities.createGorDataExceptionFromJSON(obj) : (errorType.startsWith("GorResourceException") ? ExceptionUtilities.createGorResourceException(obj) : ExceptionUtilities.createGorSystemException(obj)));
                    exception.requestID = ExceptionUtilities.getStringValue(obj, REQUEST_ID, "");
                    if (obj.containsKey((Object)STACK_TRACE)) {
                        ExceptionUtilities.setStackTrace(exception, obj);
                    }
                }
            }
            catch (Exception e) {
                exception = new GorSystemException("Got error: '" + error + "'\nTrying to parse this error as json error resulted in an exception.", e);
            }
        }
        return exception;
    }

    public static GorResourceException mapGorResourceException(String resourceName, String uri, Exception e) {
        if (uri.trim().startsWith("[") && uri.trim().endsWith("]")) {
            return new GorMissingRelationException(String.format("Virtual relation '%s' is missing", resourceName), uri, e);
        }
        return new GorResourceException("Resource not found for iterator: " + resourceName, uri, e);
    }

    private static void setStackTrace(GorException exception, JSONObject obj) {
        try {
            String stackTraceText = obj.get((Object)STACK_TRACE).toString();
            String[] exceptions = stackTraceText.split("Caused by:");
            String[] stackTrace = exceptions[exceptions.length - 1].split("\n");
            ArrayList<StackTraceElement> stackTraceElements = new ArrayList<StackTraceElement>();
            for (String st : stackTrace) {
                if (!st.startsWith("\tat ")) continue;
                StackTraceElement stackTraceElement = st.contains("(") ? ExceptionUtilities.parseStacktraceLineWithFile(st) : ExceptionUtilities.parseStacktraceLineWithoutFile(st);
                stackTraceElements.add(stackTraceElement);
            }
            exception.setStackTrace(stackTraceElements.toArray(new StackTraceElement[0]));
        }
        catch (Exception e) {
            log.error("Unexpected error when parsing stacktrace of a json-fied exception during deserialization into a GorException", (Throwable)e);
        }
    }

    private static StackTraceElement parseStacktraceLineWithoutFile(String st) {
        String methodName = st.substring(st.indexOf(32) + 1);
        String declaringClass = methodName.substring(0, methodName.lastIndexOf(46));
        return new StackTraceElement(declaringClass, methodName, null, -1);
    }

    private static StackTraceElement parseStacktraceLineWithFile(String st) {
        String methodName = st.substring(st.indexOf(32) + 1, st.indexOf(40));
        String declaringClass = methodName.substring(0, methodName.lastIndexOf(46));
        if (st.contains(":")) {
            String fileName = st.substring(st.indexOf(40) + 1, st.indexOf(58));
            int lineNumber = Integer.parseInt(st.substring(st.indexOf(58) + 1, st.indexOf(41)));
            return new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
        }
        String fileName = st.substring(st.indexOf(40) + 1, st.indexOf(41));
        return new StackTraceElement(declaringClass, methodName, fileName, -1);
    }

    private static GorException createGorSystemException(JSONObject obj) {
        return new GorSystemException(ExceptionUtilities.getStringValue(obj, MESSAGE, ""), null);
    }

    private static GorException createGorResourceException(JSONObject obj) {
        GorResourceException exception = new GorResourceException(ExceptionUtilities.getStringValue(obj, MESSAGE, ""), ExceptionUtilities.getStringValue(obj, URI, ""));
        ExceptionUtilities.updateGorUserException(obj, exception);
        return exception;
    }

    private static GorException createGorDataExceptionFromJSON(JSONObject obj) {
        GorDataException exception = new GorDataException(ExceptionUtilities.getStringValue(obj, MESSAGE, ""), ExceptionUtilities.getIntValue(obj, COLUMN_NUMBER, -1), ExceptionUtilities.getStringValue(obj, HEADER, ""), ExceptionUtilities.getStringValue(obj, ROW, ""));
        ExceptionUtilities.updateGorUserException(obj, exception);
        return exception;
    }

    private static GorException createGorParsingExceptionFromJSON(JSONObject obj) {
        GorParsingException exception = new GorParsingException(ExceptionUtilities.getStringValue(obj, MESSAGE, ""), ExceptionUtilities.getStringValue(obj, OPTION, ""), ExceptionUtilities.getStringValue(obj, OPTION_VALUE, ""));
        ExceptionUtilities.updateGorUserException(obj, exception);
        return exception;
    }

    private static void updateGorUserException(JSONObject obj, GorUserException exception) {
        exception.setQuery(ExceptionUtilities.getStringValue(obj, QUERY, ""));
        exception.setCommandName(ExceptionUtilities.getStringValue(obj, COMMAND_NAME, ""));
        exception.setCommandIndex(ExceptionUtilities.getIntValue(obj, COMMAND_INDEX, -1));
        exception.setCommandStep(ExceptionUtilities.getStringValue(obj, COMMAND, ""));
        exception.setQuerySource(ExceptionUtilities.getStringValue(obj, COMMAND_SOURCE, ""));
        exception.setExtraInfo(ExceptionUtilities.getStringValue(obj, EXTRA_INFO, ""));
    }

    private static String getStringValue(JSONObject obj, String key, String defaultValue) {
        return obj != null && obj.containsKey((Object)key) ? (String)obj.get((Object)key) : defaultValue;
    }

    private static Integer getIntValue(JSONObject obj, String key, Integer defaultValue) {
        return obj != null && obj.containsKey((Object)key) ? Integer.parseInt(obj.get((Object)key).toString()) : defaultValue;
    }
}

