/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.exceptions;

import org.gorpipe.exceptions.ExceptionUtilities;
import org.gorpipe.exceptions.GorUserException;

public class GorDataException
extends GorUserException {
    private String header;
    private String row;
    private int columnNumber;

    public GorDataException(String message) {
        this(message, -1, "", "", null);
    }

    public GorDataException(String message, Throwable cause) {
        this(message, -1, "", "", cause);
    }

    public GorDataException(String message, Integer columnNumber) {
        this(message, columnNumber, "", "", null);
    }

    public GorDataException(String message, int columnNumber, String header) {
        this(message, columnNumber, header, "", null);
    }

    public GorDataException(String message, int columnNumber, String header, String row) {
        this(message, columnNumber, header, row, null);
    }

    public GorDataException(String message, String row) {
        this(message, 0, "", row, null);
    }

    public GorDataException(String message, int columnNumber, String header, String row, Throwable cause) {
        super(message, cause);
        this.header = header;
        this.row = row;
        this.columnNumber = columnNumber;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getRow() {
        return this.row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        if (!ExceptionUtilities.isNullOrEmpty(this.header)) {
            builder.append("Header: ");
            builder.append(this.header);
            builder.append("\n");
        }
        if (!ExceptionUtilities.isNullOrEmpty(this.row)) {
            builder.append("Row: ");
            builder.append(this.row);
            builder.append("\n");
        }
        if (this.columnNumber >= 0) {
            builder.append("Column: ");
            builder.append(this.columnNumber);
            builder.append("\n");
        }
        return builder.toString();
    }
}

