/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.exceptions;

import org.gorpipe.exceptions.ExceptionUtilities;
import org.gorpipe.exceptions.GorUserException;

public class GorParsingException
extends GorUserException {
    private String option;
    private String payload;
    private int line;
    private int pos;

    public GorParsingException(String message) {
        this(message, "", "");
    }

    public GorParsingException(String message, String option) {
        this(message, option, "");
    }

    public GorParsingException(String message, String option, String payload) {
        this(message, option, payload, 0, 0, null);
    }

    public GorParsingException(String message, Throwable cause) {
        this(message, "", "", 0, 0, cause);
    }

    public GorParsingException(String message, int line, int pos) {
        this(message, "", "", line, pos, null);
    }

    public GorParsingException(String message, String option, String payload, int line, int pos, Throwable cause) {
        super(message, cause);
        this.option = option;
        this.payload = payload;
        this.line = line;
        this.pos = pos;
    }

    public String getOption() {
        return this.option;
    }

    public void setOption(String option) {
        this.option = option;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        if (!ExceptionUtilities.isNullOrEmpty(this.option)) {
            builder.append("Option: ");
            builder.append(this.option);
            builder.append("\n");
        }
        if (!ExceptionUtilities.isNullOrEmpty(this.payload)) {
            builder.append("Option Value: ");
            builder.append(this.payload);
            builder.append("\n");
        }
        return builder.toString();
    }
}

