/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.exceptions;

import org.gorpipe.exceptions.ExceptionUtilities;
import org.gorpipe.exceptions.GorException;

public abstract class GorUserException
extends GorException {
    private String query = "";
    private String commandName = "";
    private String commandStep = "";
    private int commandIndex = -1;
    private String querySource = "";
    private String extraInfo = "";

    protected GorUserException(String message, Throwable cause) {
        super(message, cause);
    }

    public String getCommandName() {
        return this.commandName;
    }

    public void setCommandName(String command) {
        this.commandName = command;
    }

    public int getCommandIndex() {
        return this.commandIndex;
    }

    public void setCommandIndex(int commandIndex) {
        this.commandIndex = commandIndex;
    }

    public String getCommandStep() {
        return this.commandStep;
    }

    public void setCommandStep(String commandString) {
        this.commandStep = commandString;
    }

    public String getQuerySource() {
        return this.querySource;
    }

    public void setQuerySource(String querySource) {
        this.querySource = querySource;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public Boolean isCommandSet() {
        return this.commandName != null && this.commandName.length() > 0;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        if (!ExceptionUtilities.isNullOrEmpty(this.query)) {
            builder.append("Query: ");
            builder.append("\n");
            builder.append(this.query);
            builder.append("\n");
        }
        if (!ExceptionUtilities.isNullOrEmpty(this.commandStep)) {
            builder.append("Command Step: ");
            builder.append(this.commandStep);
            builder.append("\n");
        }
        if (!ExceptionUtilities.isNullOrEmpty(this.commandName)) {
            builder.append("Command Name: ");
            builder.append(this.commandName);
            builder.append("\n");
        }
        if (this.commandIndex >= 0) {
            builder.append("Command Index: ");
            builder.append(this.commandIndex);
            builder.append("\n");
        }
        if (!ExceptionUtilities.isNullOrEmpty(this.querySource)) {
            builder.append("Query Source: ");
            builder.append(this.querySource);
            builder.append("\n");
        }
        if (!ExceptionUtilities.isNullOrEmpty(this.extraInfo)) {
            builder.append("Extra info: ");
            builder.append(this.extraInfo);
            builder.append("\n");
        }
        return builder.toString();
    }
}

