/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.nativemode.resources;

import com.oracle.truffle.api.InternalResource;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Properties;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeResourceAccess;

public final class NativeResourceFeature
implements Feature {
    public void duringSetup(Feature.DuringSetupAccess access) {
        String fileListPath = String.format("/META-INF/resources/llvm/native/%s/%s/files", InternalResource.OS.getCurrent(), InternalResource.CPUArchitecture.getCurrent());
        Properties props = new Properties();
        try (BufferedInputStream in = new BufferedInputStream(this.getClass().getResourceAsStream(fileListPath));){
            props.load(in);
        }
        catch (IOException ex) {
            throw new IllegalStateException("error processing LLVM runtime resources", ex);
        }
        Module self = this.getClass().getModule();
        for (Object key : props.keySet()) {
            String path = (String)key;
            RuntimeResourceAccess.addResource((Module)self, (String)path);
        }
    }
}

