/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.junit;

import com.oracle.mxtool.junit.MxJUnitRequest;
import com.oracle.mxtool.junit.MxJUnitWrapper;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.VMError;
import java.io.BufferedReader;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Random;
import junit.runner.Version;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.junit.internal.JUnitSystem;
import org.junit.internal.RealSystem;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public class SVMJUnitRunner {
    private final MxJUnitRequest request;
    private final String missingClassesStr;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    SVMJUnitRunner(final Feature.FeatureAccess access) {
        MxJUnitRequest.Builder builder = new MxJUnitRequest.Builder(){

            protected Class<?> resolveClass(String name) throws ClassNotFoundException {
                Class ret = access.findClassByName(name);
                if (ret == null) {
                    throw new ClassNotFoundException(name);
                }
                return ret;
            }
        };
        try (BufferedReader br = new BufferedReader(new FileReader((String)Options.TestFile.getValue()));){
            String buf;
            while ((buf = br.readLine()) != null) {
                builder.addTestSpec(buf);
            }
        }
        catch (Exception ex) {
            throw VMError.shouldNotReachHere((Throwable)ex);
        }
        this.request = builder.build();
        this.missingClassesStr = this.getMissingClasses();
        if (this.missingClassesStr != null) {
            String testFileOption = SubstrateOptionsParser.commandArgument(Options.TestFile, (String)((String)Options.TestFile.getValue()));
            StringBuilder msg = new StringBuilder("Warning: The test configuration file specified via ").append(testFileOption).append(" contains missing classes. Test execution will fail at run time. ").append("Missing classes in configuration file: ").append(this.missingClassesStr);
            System.out.println(msg);
        }
    }

    Request getJUnitRequest() {
        return this.request.getRequest();
    }

    private String getMissingClasses() {
        List missingClasses = this.request.getMissingClasses();
        if (missingClasses.size() > 0) {
            StringBuilder missingClassesBuilder = new StringBuilder();
            String delim = "";
            for (Failure missingClass : missingClasses) {
                missingClassesBuilder.append(delim).append(missingClass.getDescription().getDisplayName());
                delim = ", ";
            }
            return missingClassesBuilder.toString();
        }
        return null;
    }

    private static String formatJsonTestResultsPattern(JUnitSystem system, String testResultsPattern) {
        if (!testResultsPattern.contains("XXX")) {
            system.out().println("MX_TEST_RESULTS_PATTERN doesn't contain `XXX`. Results will probably be overwritten if used multiple times.");
            return testResultsPattern;
        }
        String timeStamp = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
        Object randNum = "00000000" + Math.abs(new Random().nextInt());
        randNum = ((String)randNum).substring(((String)randNum).length() - 8);
        String identifier = "unittest-" + timeStamp + "-" + (String)randNum;
        return testResultsPattern.replaceFirst("XXXX*", identifier);
    }

    private static String getOS() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("windows")) {
            return "windows";
        }
        if (os.contains("linux")) {
            return "linux";
        }
        if (os.contains("mac") || os.contains("darwin")) {
            return "darwin";
        }
        return os;
    }

    private void run(String[] args) {
        RealSystem system = new RealSystem();
        JUnitCore junitCore = new JUnitCore();
        system.out().println("SVMJUnitCore");
        system.out().println("JUnit version " + Version.id());
        MxJUnitWrapper.MxJUnitConfig config = new MxJUnitWrapper.MxJUnitConfig();
        String testResultsPattern = System.getenv("MX_TEST_RESULTS_PATTERN");
        String jsonResultTags = System.getenv("MX_TEST_RESULT_TAGS");
        if (testResultsPattern != null && !testResultsPattern.isEmpty()) {
            config.jsonResults = SVMJUnitRunner.formatJsonTestResultsPattern((JUnitSystem)system, testResultsPattern);
        }
        if (jsonResultTags != null && !jsonResultTags.isEmpty()) {
            config.jsonResultTags = jsonResultTags;
        }
        config.jsonResultTags = config.jsonResultTags + "," + SVMJUnitRunner.getOS();
        config.jsonResultTags = config.jsonResultTags + "," + System.getProperty("os.arch");
        if (!config.jsonResultTags.contains("native-image")) {
            config.jsonResultTags = config.jsonResultTags + ",native-image";
        }
        int i = 0;
        while (i < args.length) {
            String arg;
            switch (arg = args[i++]) {
                case "--verbose": {
                    config.verbose = true;
                    break;
                }
                case "--very-verbose": {
                    config.veryVerbose = true;
                    break;
                }
                case "--fail-fast": {
                    config.failFast = true;
                    break;
                }
                case "--enable-timing": {
                    config.enableTiming = true;
                    break;
                }
                case "--color": {
                    config.color = true;
                    break;
                }
                case "--gc-after-test": {
                    config.gcAfterTest = true;
                    break;
                }
                case "--repeat": {
                    if (i < args.length) {
                        String count = args[i++];
                        try {
                            config.repeatCount = Integer.valueOf(count);
                        }
                        catch (NumberFormatException ex) {
                            system.out().println("Invalid argument to --repeat, expected number, but got " + count);
                        }
                        break;
                    }
                    system.out().println("Missing argument to --repeat");
                    break;
                }
                case "--eager-stacktrace": {
                    config.eagerStackTrace = true;
                    break;
                }
                default: {
                    system.out().println("Unknown command line argument: " + arg);
                }
            }
        }
        Result result = MxJUnitWrapper.runRequest((JUnitCore)junitCore, (JUnitSystem)system, (MxJUnitWrapper.MxJUnitConfig)config, (MxJUnitRequest)this.request);
        if (result.wasSuccessful()) {
            system.out().println("Test run PASSED. Exiting with status 0.");
            System.exit(0);
        } else {
            StringBuilder msg = new StringBuilder("Test run FAILED!");
            if (this.missingClassesStr != null) {
                msg.append(System.lineSeparator());
                msg.append("Missing classes in configuration file: ").append(this.missingClassesStr);
                msg.append(System.lineSeparator());
            }
            msg.append("Exiting with status 1.");
            system.out().println(msg);
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        ((SVMJUnitRunner)ImageSingletons.lookup(SVMJUnitRunner.class)).run(args);
    }

    public static class Options {
        public static final HostedOptionKey<String> TestFile = new HostedOptionKey((Object)"");
    }
}

