/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jvmtiagentbase;

import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class AgentIsolate {
    private static final CGlobalData<WordPointer> GLOBAL_ISOLATE = CGlobalDataFactory.createWord();

    public static void setGlobalIsolate(Isolate isolate) {
        VMError.guarantee((boolean)WordFactory.nullPointer().equal((ComparableWord)((WordPointer)GLOBAL_ISOLATE.get()).read()), (String)"Global isolate must be set exactly once");
        ((WordPointer)GLOBAL_ISOLATE.get()).write((WordBase)isolate);
    }

    public static void resetGlobalIsolate() {
        VMError.guarantee((boolean)WordFactory.nullPointer().notEqual((ComparableWord)((WordPointer)GLOBAL_ISOLATE.get()).read()), (String)"Global isolate must be set");
        ((WordPointer)GLOBAL_ISOLATE.get()).write((WordBase)WordFactory.nullPointer());
    }

    private AgentIsolate() {
    }

    public static final class EnterOrBailoutPrologue {
        static void enter() {
            Isolate global = (Isolate)((WordPointer)GLOBAL_ISOLATE.get()).read();
            if (global.isNull()) {
                CEntryPointActions.bailoutInPrologue();
            }
            if (CEntryPointActions.enterIsolate((Isolate)global) != 0) {
                CEntryPointActions.bailoutInPrologue();
            }
        }
    }

    public static final class Prologue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString((String)"Failed to enter (or attach to) the global isolate in the current thread.");

        static void enter() {
            int code = CEntryPointActions.enterAttachThread((Isolate)((Isolate)((WordPointer)GLOBAL_ISOLATE.get()).read()), (boolean)true);
            if (code != 0) {
                CEntryPointActions.failFatally((int)code, (CCharPointer)((CCharPointer)errorMessage.get()));
            }
        }
    }
}

