/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jvmtiagentbase;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.jni.JNIObjectHandles;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIFieldId;
import com.oracle.svm.jni.nativeapi.JNIMethodId;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import com.oracle.svm.jvmtiagentbase.Support;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.ComparableWord;

public abstract class JNIHandleSet {
    private static final int INITIAL_GLOBAL_HANDLE_CAPACITY = 16;
    private final ReentrantLock globalRefsLock = new ReentrantLock();
    private JNIObjectHandle[] globalRefs = new JNIObjectHandle[16];
    private int globalRefCount = 0;
    private boolean destroyed = false;
    final JNIMethodId javaLangClassGetName;

    public JNIHandleSet(JNIEnvironment env) {
        JNIObjectHandle javaLangClass = this.findClass(env, "java/lang/Class");
        try (CTypeConversion.CCharPointerHolder name = Support.toCString("getName");
             CTypeConversion.CCharPointerHolder signature = Support.toCString("()Ljava/lang/String;");){
            this.javaLangClassGetName = Support.jniFunctions().getGetMethodID().invoke(env, javaLangClass, name.get(), signature.get());
            VMError.guarantee((boolean)this.javaLangClassGetName.isNonNull());
        }
    }

    public JNIObjectHandle findClass(JNIEnvironment env, String className) {
        JNIObjectHandle h = this.findClassOptional(env, className);
        VMError.guarantee((boolean)h.notEqual((ComparableWord)JNIObjectHandles.nullHandle()));
        return h;
    }

    public JNIObjectHandle findClassOptional(JNIEnvironment env, String className) {
        assert (!this.destroyed);
        try (CTypeConversion.CCharPointerHolder name = Support.toCString(className);){
            JNIObjectHandle h = Support.jniFunctions().getFindClass().invoke(env, name.get());
            if (Support.clearException(env)) {
                JNIObjectHandle jNIObjectHandle = (JNIObjectHandle)JNIObjectHandles.nullHandle();
                return jNIObjectHandle;
            }
            JNIObjectHandle jNIObjectHandle = h;
            return jNIObjectHandle;
        }
    }

    public JNIObjectHandle newClassGlobalRef(JNIEnvironment env, String className) {
        assert (!this.destroyed);
        return this.newTrackedGlobalRef(env, this.findClass(env, className));
    }

    public JNIMethodId getMethodId(JNIEnvironment env, JNIObjectHandle clazz, String name, String signature, boolean isStatic) {
        assert (!this.destroyed);
        JNIMethodId id = this.getMethodIdOptional(env, clazz, name, signature, isStatic);
        VMError.guarantee((boolean)id.isNonNull());
        return id;
    }

    /*
     * Exception decompiling
     */
    public JNIMethodId getMethodIdOptional(JNIEnvironment env, JNIObjectHandle clazz, String name, String signature, boolean isStatic) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public JNIFieldId getFieldId(JNIEnvironment env, JNIObjectHandle clazz, String name, String signature, boolean isStatic) {
        assert (!this.destroyed);
        JNIFieldId id = this.getFieldIdOptional(env, clazz, name, signature, isStatic);
        VMError.guarantee((boolean)id.isNonNull());
        return id;
    }

    /*
     * Exception decompiling
     */
    public JNIFieldId getFieldIdOptional(JNIEnvironment env, JNIObjectHandle clazz, String name, String signature, boolean isStatic) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JNIObjectHandle newTrackedGlobalRef(JNIEnvironment env, JNIObjectHandle ref) {
        assert (!this.destroyed);
        JNIObjectHandle global = Support.jniFunctions().getNewGlobalRef().invoke(env, ref);
        VMError.guarantee((boolean)global.notEqual((ComparableWord)JNIObjectHandles.nullHandle()));
        this.globalRefsLock.lock();
        try {
            if (this.globalRefCount == this.globalRefs.length) {
                this.globalRefs = JNIHandleSet.copyOf(this.globalRefs, this.globalRefs.length * 2);
            }
            this.globalRefs[this.globalRefCount] = global;
            ++this.globalRefCount;
        }
        finally {
            this.globalRefsLock.unlock();
        }
        return global;
    }

    private static JNIObjectHandle[] copyOf(JNIObjectHandle[] original, int newLength) {
        JNIObjectHandle[] copy = new JNIObjectHandle[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    void destroy(JNIEnvironment env) {
        assert (!this.destroyed);
        this.destroyed = true;
        for (int i = 0; i < this.globalRefCount; ++i) {
            Support.jniFunctions().getDeleteGlobalRef().invoke(env, this.globalRefs[i]);
        }
    }
}

