/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jvmtiagentbase;

import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.jni.JNIObjectHandles;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIErrors;
import com.oracle.svm.jni.nativeapi.JNIJavaVM;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import com.oracle.svm.jni.nativeapi.JNIVersion;
import com.oracle.svm.jvmtiagentbase.AgentIsolate;
import com.oracle.svm.jvmtiagentbase.JNIHandleSet;
import com.oracle.svm.jvmtiagentbase.Support;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEnv;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEvent;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEventCallbacks;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEventMode;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public abstract class JvmtiAgentBase<T extends JNIHandleSet> {
    private static final CEntryPointLiteral<CFunctionPointer> onVMInitLiteral = CEntryPointLiteral.create(JvmtiAgentBase.class, (String)"onVMInit", (Class[])new Class[]{JvmtiEnv.class, JNIEnvironment.class, JNIObjectHandle.class});
    private static final CEntryPointLiteral<CFunctionPointer> onVMStartLiteral = CEntryPointLiteral.create(JvmtiAgentBase.class, (String)"onVMStart", (Class[])new Class[]{JvmtiEnv.class, JNIEnvironment.class});
    private static final CEntryPointLiteral<CFunctionPointer> onVMDeathLiteral = CEntryPointLiteral.create(JvmtiAgentBase.class, (String)"onVMDeath", (Class[])new Class[]{JvmtiEnv.class, JNIEnvironment.class});
    private static final CEntryPointLiteral<CFunctionPointer> onThreadEndLiteral = CEntryPointLiteral.create(JvmtiAgentBase.class, (String)"onThreadEnd", (Class[])new Class[]{JvmtiEnv.class, JNIEnvironment.class, JNIObjectHandle.class});
    private static JvmtiAgentBase singleton;
    private boolean destroyed = false;
    private T handles;

    protected abstract JNIHandleSet constructJavaHandles(JNIEnvironment var1);

    protected abstract int onLoadCallback(JNIJavaVM var1, JvmtiEnv var2, JvmtiEventCallbacks var3, String var4);

    protected abstract int onUnloadCallback(JNIJavaVM var1);

    protected abstract void onVMStartCallback(JvmtiEnv var1, JNIEnvironment var2);

    protected abstract void onVMInitCallback(JvmtiEnv var1, JNIEnvironment var2, JNIObjectHandle var3);

    protected abstract void onVMDeathCallback(JvmtiEnv var1, JNIEnvironment var2);

    protected abstract int getRequiredJvmtiVersion();

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public T handles() {
        return this.handles;
    }

    public static <T extends JNIHandleSet, U extends JvmtiAgentBase<T>> U singleton() {
        VMError.guarantee((singleton != null ? 1 : 0) != 0, (String)"No agent has been registered but an instance was requested.");
        return (U)singleton;
    }

    protected static <T extends JNIHandleSet> void registerAgent(JvmtiAgentBase<T> agentSingleton) {
        VMError.guarantee((singleton == null ? 1 : 0) != 0, (String)"The agent has been registered multiple times.");
        singleton = agentSingleton;
    }

    @CEntryPoint(name="Agent_OnLoad")
    @CEntryPointOptions(prologue=CEntryPointSetup.EnterCreateIsolatePrologue.class)
    public static int onLoad(JNIJavaVM vm, CCharPointer options, PointerBase reserved) {
        AgentIsolate.setGlobalIsolate(CurrentIsolate.getIsolate());
        String optionsString = options.isNonNull() ? Support.fromCString(options) : "";
        WordPointer jvmtiPtr = (WordPointer)StackValue.get(WordPointer.class);
        Support.checkJni(vm.getFunctions().getGetEnv().invoke(vm, (PointerBase)jvmtiPtr, ((JvmtiAgentBase)JvmtiAgentBase.singleton()).getRequiredJvmtiVersion()));
        JvmtiEnv jvmti = (JvmtiEnv)jvmtiPtr.read();
        JvmtiEventCallbacks callbacks = (JvmtiEventCallbacks)UnmanagedMemory.calloc((int)SizeOf.get(JvmtiEventCallbacks.class));
        callbacks.setVMStart(onVMStartLiteral.getFunctionPointer());
        callbacks.setVMInit(onVMInitLiteral.getFunctionPointer());
        callbacks.setVMDeath(onVMDeathLiteral.getFunctionPointer());
        callbacks.setThreadEnd(onThreadEndLiteral.getFunctionPointer());
        int ret = ((JvmtiAgentBase)JvmtiAgentBase.singleton()).onLoadCallback(vm, jvmti, callbacks, optionsString);
        if (ret != 0) {
            return ret;
        }
        Support.check(jvmti.getFunctions().SetEventCallbacks().invoke(jvmti, callbacks, SizeOf.get(JvmtiEventCallbacks.class)));
        UnmanagedMemory.free((PointerBase)callbacks);
        Support.check(jvmti.getFunctions().SetEventNotificationMode().invoke(jvmti, JvmtiEventMode.JVMTI_ENABLE, JvmtiEvent.JVMTI_EVENT_VM_START, (JNIObjectHandle)JNIObjectHandles.nullHandle()));
        Support.check(jvmti.getFunctions().SetEventNotificationMode().invoke(jvmti, JvmtiEventMode.JVMTI_ENABLE, JvmtiEvent.JVMTI_EVENT_VM_INIT, (JNIObjectHandle)JNIObjectHandles.nullHandle()));
        Support.check(jvmti.getFunctions().SetEventNotificationMode().invoke(jvmti, JvmtiEventMode.JVMTI_ENABLE, JvmtiEvent.JVMTI_EVENT_VM_DEATH, (JNIObjectHandle)JNIObjectHandles.nullHandle()));
        Support.check(jvmti.getFunctions().SetEventNotificationMode().invoke(jvmti, JvmtiEventMode.JVMTI_ENABLE, JvmtiEvent.JVMTI_EVENT_THREAD_END, (JNIObjectHandle)JNIObjectHandles.nullHandle()));
        return 0;
    }

    protected void unload(JNIJavaVM vm) {
        VMError.guarantee((!this.destroyed ? 1 : 0) != 0, (String)"The unload function from the JvmtiAgentBase must only be called once.");
        ((JvmtiAgentBase)JvmtiAgentBase.singleton()).destroyed = true;
        WordPointer jniPtr = (WordPointer)StackValue.get(WordPointer.class);
        if (vm.getFunctions().getGetEnv().invoke(vm, (PointerBase)jniPtr, JNIVersion.JNI_VERSION_1_6()) != JNIErrors.JNI_OK()) {
            jniPtr.write((WordBase)WordFactory.nullPointer());
        }
        JNIEnvironment env = (JNIEnvironment)jniPtr.read();
        ((JNIHandleSet)((JvmtiAgentBase)JvmtiAgentBase.singleton()).handles).destroy(env);
        Support.destroy();
        AgentIsolate.resetGlobalIsolate();
    }

    @CEntryPoint(name="Agent_OnUnload")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    public static int onUnload(JNIJavaVM vm) {
        return ((JvmtiAgentBase)JvmtiAgentBase.singleton()).onUnloadCallback(vm);
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    public static void onVMStart(JvmtiEnv jvmti, JNIEnvironment jni) {
        Support.initialize(jvmti);
        ((JvmtiAgentBase)JvmtiAgentBase.singleton()).handles = ((JvmtiAgentBase)JvmtiAgentBase.singleton()).constructJavaHandles(jni);
        ((JvmtiAgentBase)JvmtiAgentBase.singleton()).onVMStartCallback(jvmti, jni);
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    public static void onVMInit(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread) {
        ((JvmtiAgentBase)JvmtiAgentBase.singleton()).onVMInitCallback(jvmti, jni, thread);
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    public static void onVMDeath(JvmtiEnv jvmti, JNIEnvironment jni) {
        ((JvmtiAgentBase)JvmtiAgentBase.singleton()).onVMDeathCallback(jvmti, jni);
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.EnterOrBailoutPrologue.class, epilogue=CEntryPointSetup.LeaveDetachThreadEpilogue.class)
    public static void onThreadEnd(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread) {
    }
}

