/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.shell;

import com.oracle.graal.python.shell.ConsoleHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import org.graalvm.shadowed.org.jline.keymap.KeyMap;
import org.graalvm.shadowed.org.jline.reader.Candidate;
import org.graalvm.shadowed.org.jline.reader.Completer;
import org.graalvm.shadowed.org.jline.reader.EndOfFileException;
import org.graalvm.shadowed.org.jline.reader.History;
import org.graalvm.shadowed.org.jline.reader.LineReader;
import org.graalvm.shadowed.org.jline.reader.LineReaderBuilder;
import org.graalvm.shadowed.org.jline.reader.Macro;
import org.graalvm.shadowed.org.jline.reader.ParsedLine;
import org.graalvm.shadowed.org.jline.reader.Parser;
import org.graalvm.shadowed.org.jline.reader.UserInterruptException;
import org.graalvm.shadowed.org.jline.reader.impl.DefaultParser;
import org.graalvm.shadowed.org.jline.terminal.Terminal;
import org.graalvm.shadowed.org.jline.terminal.TerminalBuilder;

public class JLineConsoleHandler
extends ConsoleHandler {
    private final boolean noPrompt;
    private final Terminal terminal;
    private LineReader reader;
    private History history;
    private String prompt;
    private LinkedList<String> lineBuffer = new LinkedList();

    public JLineConsoleHandler(InputStream inStream, OutputStream outStream, boolean noPrompt) {
        this.noPrompt = noPrompt;
        try {
            this.terminal = TerminalBuilder.builder().jna(false).streams(inStream, outStream).system(true).signalHandler(Terminal.SignalHandler.SIG_IGN).build();
        }
        catch (IOException ex) {
            throw new RuntimeException("unexpected error opening console reader", ex);
        }
    }

    @Override
    public void setupReader(BooleanSupplier shouldRecord, IntSupplier getSize, Consumer<String> addItem, IntFunction<String> getItem, BiConsumer<Integer, String> setItem, IntConsumer removeItem, Runnable clear, final Function<String, List<String>> completer) {
        this.history = new HistoryImpl(shouldRecord, getSize, addItem, getItem, setItem, removeItem, clear);
        LineReaderBuilder builder = LineReaderBuilder.builder();
        builder = builder.terminal(this.terminal).history(this.history);
        if (completer != null) {
            builder.completer(new Completer(){

                public void complete(LineReader r, ParsedLine pl, List<Candidate> candidates) {
                    String word = pl.word();
                    if (word != null) {
                        List l = (List)completer.apply(word);
                        for (String value : l) {
                            candidates.add(new Candidate(value, value, null, null, null, null, false));
                        }
                    }
                }
            });
        }
        builder.parser((Parser)new DefaultParser(){

            public boolean isDelimiterChar(CharSequence buffer, int pos) {
                if (pos == buffer.length() - 1) {
                    return false;
                }
                return Character.isWhitespace(buffer.charAt(pos));
            }
        });
        this.reader = builder.build();
        this.reader.option(LineReader.Option.DISABLE_EVENT_EXPANSION, true);
        this.reader.option(LineReader.Option.INSERT_TAB, true);
        this.reader.setVariable("comment-begin", (Object)"#");
        KeyMap binding = (KeyMap)this.reader.getKeyMaps().get("main");
        binding.bind((Object)new Macro(KeyMap.translate((String)"0")), (CharSequence)KeyMap.translate((String)"^[Op"));
        binding.bind((Object)new Macro(KeyMap.translate((String)".")), (CharSequence)KeyMap.translate((String)"^[On"));
        binding.bind((Object)new Macro(KeyMap.translate((String)"^M")), (CharSequence)KeyMap.translate((String)"^[OM"));
        binding.bind((Object)new Macro(KeyMap.translate((String)"1")), (CharSequence)KeyMap.translate((String)"^[Oq"));
        binding.bind((Object)new Macro(KeyMap.translate((String)"2")), (CharSequence)KeyMap.translate((String)"^[Or"));
        binding.bind((Object)new Macro(KeyMap.translate((String)"3")), (CharSequence)KeyMap.translate((String)"^[Os"));
        binding.bind((Object)new Macro(KeyMap.translate((String)"4")), (CharSequence)KeyMap.translate((String)"^[Ot"));
        binding.bind((Object)new Macro(KeyMap.translate((String)"5")), (CharSequence)KeyMap.translate((String)"^[Ou"));
        binding.bind((Object)new Macro(KeyMap.translate((String)"6")), (CharSequence)KeyMap.translate((String)"^[Ov"));
        binding.bind((Object)new Macro(KeyMap.translate((String)"7")), (CharSequence)KeyMap.translate((String)"^[Ow"));
        binding.bind((Object)new Macro(KeyMap.translate((String)"8")), (CharSequence)KeyMap.translate((String)"^[Ox"));
        binding.bind((Object)new Macro(KeyMap.translate((String)"9")), (CharSequence)KeyMap.translate((String)"^[Oy"));
        binding.bind((Object)new Macro(KeyMap.translate((String)"+")), (CharSequence)KeyMap.translate((String)"^[Ol"));
        binding.bind((Object)new Macro(KeyMap.translate((String)"-")), (CharSequence)KeyMap.translate((String)"^[OS"));
        binding.bind((Object)new Macro(KeyMap.translate((String)"*")), (CharSequence)KeyMap.translate((String)"^[OR"));
        binding.bind((Object)new Macro(KeyMap.translate((String)"/")), (CharSequence)KeyMap.translate((String)"^[OQ"));
    }

    @Override
    public String readLine(boolean showPrompt) {
        if (this.lineBuffer.isEmpty()) {
            try {
                String lines = this.reader.readLine(showPrompt ? this.prompt : "");
                for (String line : lines.split("\n")) {
                    this.lineBuffer.add(line);
                }
            }
            catch (UserInterruptException e) {
                throw e;
            }
            catch (EndOfFileException e) {
                return null;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.lineBuffer.poll();
    }

    @Override
    public void setPrompt(String prompt) {
        this.prompt = this.noPrompt ? "" : (prompt != null ? prompt : "");
    }

    @Override
    public int getTerminalHeight() {
        return this.terminal.getHeight();
    }

    @Override
    public int getTerminalWidth() {
        return this.terminal.getWidth();
    }

    private static class HistoryImpl
    implements History {
        private final BooleanSupplier shouldRecord;
        private final IntSupplier getSize;
        private final Consumer<String> addItem;
        private final IntFunction<String> getItem;
        private final BiConsumer<Integer, String> setItem;
        private final IntConsumer removeItem;
        private final Runnable clear;
        private int index;

        public HistoryImpl(BooleanSupplier shouldRecord, IntSupplier getSize, Consumer<String> addItem, IntFunction<String> getItem, BiConsumer<Integer, String> setItem, IntConsumer removeItem, Runnable clear) {
            this.shouldRecord = shouldRecord;
            this.getSize = getSize;
            this.addItem = addItem;
            this.getItem = getItem;
            this.setItem = setItem;
            this.removeItem = removeItem;
            this.clear = clear;
            this.index = getSize.getAsInt();
        }

        public int size() {
            return this.getSize.getAsInt();
        }

        public void resetIndex() {
            int size = this.size();
            this.index = this.index > size ? size : this.index;
        }

        public int first() {
            return 0;
        }

        public int last() {
            return this.size() - 1;
        }

        public boolean previous() {
            if (this.index <= 0) {
                return false;
            }
            --this.index;
            return true;
        }

        public boolean next() {
            if (this.index >= this.size()) {
                return false;
            }
            ++this.index;
            return true;
        }

        public boolean moveTo(int idx) {
            if (idx >= 0 && idx < this.size()) {
                this.index = idx;
                return true;
            }
            return false;
        }

        public boolean moveToLast() {
            int lastEntry = this.size() - 1;
            if (lastEntry >= 0 && lastEntry != this.index) {
                this.index = lastEntry;
                return true;
            }
            return false;
        }

        public void moveToEnd() {
            this.index = this.size();
        }

        public boolean moveToFirst() {
            if (this.size() > 0 && this.index != 0) {
                this.index = 0;
                return true;
            }
            return false;
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public int index() {
            return this.index;
        }

        public String get(int idx) {
            return this.getItem.apply(idx);
        }

        public String current() {
            if (this.index < 0 || this.index >= this.size()) {
                return "";
            }
            return this.getItem.apply(this.index);
        }

        public void add(String string) {
            if (this.shouldRecord.getAsBoolean()) {
                this.addItem.accept(string);
                this.index = this.size();
            }
        }

        public void add(Instant instnt, String string) {
            this.add(string);
        }

        private void add(int idx, String val) {
            this.setItem.accept(idx, val);
        }

        public void purge() throws IOException {
            this.clear.run();
        }

        public ListIterator<History.Entry> iterator(int i) {
            return new HistoryIterator(i);
        }

        public void attach(LineReader reader) {
        }

        public void load() throws IOException {
        }

        public void save() throws IOException {
        }

        public void write(Path path, boolean bln) throws IOException {
        }

        public void append(Path path, boolean bln) throws IOException {
        }

        public void read(Path path, boolean bln) throws IOException {
        }

        private class HistoryIterator
        implements ListIterator<History.Entry> {
            private int iterIndex;

            public HistoryIterator(int idx) {
                this.iterIndex = idx;
            }

            @Override
            public boolean hasNext() {
                int size = HistoryImpl.this.size();
                return size > 0 && this.iterIndex < size;
            }

            @Override
            public int nextIndex() {
                return this.iterIndex;
            }

            @Override
            public History.Entry next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                HistoryEntry e = new HistoryEntry(this.iterIndex++);
                return e;
            }

            @Override
            public boolean hasPrevious() {
                int size = HistoryImpl.this.size();
                return size > 0 && this.iterIndex > 0;
            }

            @Override
            public int previousIndex() {
                return this.iterIndex - 1;
            }

            @Override
            public History.Entry previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                HistoryEntry e = new HistoryEntry(--this.iterIndex);
                return e;
            }

            @Override
            public void remove() {
                HistoryImpl.this.removeItem.accept(this.iterIndex);
                while (this.iterIndex > HistoryImpl.this.size()) {
                    --this.iterIndex;
                }
            }

            @Override
            public void set(History.Entry e) {
                HistoryImpl.this.add(this.iterIndex, e.line());
            }

            @Override
            public void add(History.Entry e) {
                HistoryImpl.this.add(HistoryImpl.this.size(), e.line());
            }
        }

        class HistoryEntry
        implements History.Entry {
            private final int entryIndex;

            public HistoryEntry(int idx) {
                this.entryIndex = idx;
            }

            public int index() {
                return this.entryIndex;
            }

            public Instant time() {
                return Instant.ofEpochMilli(0L);
            }

            public String line() {
                return HistoryImpl.this.get(this.entryIndex);
            }

            public String toString() {
                return "<HistoryEntry: " + this.entryIndex + " " + HistoryImpl.this.get(this.entryIndex) + " >";
            }
        }
    }
}

