/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.dsl.processor.ExpectError;
import com.oracle.truffle.dsl.processor.LanguageRegistrationProcessor;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.oracle.truffle.api.instrumentation.TruffleInstrument.Registration"})
public final class InstrumentRegistrationProcessor
extends AbstractProcessor {
    private final List<TypeElement> registrations = new ArrayList<TypeElement>();
    private static final int NUMBER_OF_PROPERTIES_PER_ENTRY = 4;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private void generateFile(List<TypeElement> instruments) {
        String filename = "META-INF/truffle/instrument";
        LanguageRegistrationProcessor.SortedProperties p = new LanguageRegistrationProcessor.SortedProperties();
        int numInstruments = this.loadIfFileAlreadyExists(filename, p);
        for (TypeElement l : instruments) {
            TruffleInstrument.Registration annotation = l.getAnnotation(TruffleInstrument.Registration.class);
            if (annotation == null) continue;
            int instNum = InstrumentRegistrationProcessor.findInstrument(annotation.id(), p);
            if (instNum == 0) {
                instNum = ++numInstruments;
            }
            String prefix = "instrument" + instNum + ".";
            String className = this.processingEnv.getElementUtils().getBinaryName(l).toString();
            p.setProperty(prefix + "id", annotation.id());
            p.setProperty(prefix + "name", annotation.name());
            p.setProperty(prefix + "version", annotation.version());
            p.setProperty(prefix + "className", className);
            p.setProperty(prefix + "internal", Boolean.toString(annotation.internal()));
            int serviceCounter = 0;
            for (AnnotationMirror annotationMirror : l.getAnnotationMirrors()) {
                String annoName = annotationMirror.getAnnotationType().asElement().toString();
                if (!TruffleInstrument.Registration.class.getCanonicalName().equals(annoName)) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    Name attrName = entry.getKey().getSimpleName();
                    if (!attrName.contentEquals("services")) continue;
                    AnnotationValue attrValue = entry.getValue();
                    List classes = (List)attrValue.getValue();
                    for (Object clazz : classes) {
                        AnnotationValue clazzValue = (AnnotationValue)clazz;
                        p.setProperty(prefix + "service" + serviceCounter++, clazzValue.getValue().toString());
                    }
                }
            }
        }
        if (numInstruments > 0) {
            try {
                FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", filename, new Element[0]);
                try (OutputStream os = file.openOutputStream();){
                    p.store(os, "Generated by " + InstrumentRegistrationProcessor.class.getName());
                }
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage(), instruments.get(0));
            }
        }
    }

    private static int findInstrument(String id, Properties p) {
        String val;
        int cnt = 1;
        while ((val = p.getProperty("instrument" + cnt + ".id")) != null) {
            if (id.equals(val)) {
                return cnt;
            }
            ++cnt;
        }
        return 0;
    }

    private int loadIfFileAlreadyExists(String filename, Properties p) {
        try {
            FileObject file = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", filename);
            p.load(file.openInputStream());
            return p.keySet().size() / 4;
        }
        catch (IOException e) {
            return 0;
        }
    }

    static void loadExistingTypes(ProcessingEnvironment env, List<TypeElement> instruments, String filename, String pre) {
        String prefix;
        String className;
        HashSet<String> typeNames = new HashSet<String>();
        for (TypeElement type : instruments) {
            typeNames.add(ElementUtils.getQualifiedName(type));
        }
        Properties current = new Properties();
        try {
            FileObject object = env.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", filename);
            current.load(object.openInputStream());
        }
        catch (IOException e1) {
            env.getMessager().printMessage(Diagnostic.Kind.NOTE, filename + e1.getMessage(), null);
        }
        int cnt = 1;
        while ((className = current.getProperty((prefix = pre + cnt + ".") + "className")) != null) {
            env.getMessager().printMessage(Diagnostic.Kind.NOTE, filename + className, null);
            TypeElement foundType = ElementUtils.getTypeElement(env, className);
            if (foundType != null && !typeNames.contains(ElementUtils.getQualifiedName(foundType))) {
                instruments.add(foundType);
            }
            ++cnt;
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generateFile(this.registrations);
            this.registrations.clear();
            return true;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(TruffleInstrument.Registration.class)) {
            TruffleInstrument.Registration annotation = element.getAnnotation(TruffleInstrument.Registration.class);
            if (annotation == null || element.getKind() != ElementKind.CLASS) continue;
            if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.emitError("Registered instrument class must be public", element);
                continue;
            }
            if (element.getEnclosingElement().getKind() != ElementKind.PACKAGE && !element.getModifiers().contains((Object)Modifier.STATIC)) {
                this.emitError("Registered instrument inner-class must be static", element);
                continue;
            }
            TypeMirror truffleLang = this.processingEnv.getTypeUtils().erasure(ElementUtils.getTypeElement(this.processingEnv, TruffleInstrument.class.getName()).asType());
            if (!this.processingEnv.getTypeUtils().isAssignable(element.asType(), truffleLang)) {
                this.emitError("Registered instrument class must subclass TruffleInstrument", element);
                continue;
            }
            this.assertNoErrorExpected(element);
            this.registrations.add((TypeElement)element);
        }
        return true;
    }

    void assertNoErrorExpected(Element e) {
        ExpectError.assertNoErrorExpected(this.processingEnv, e);
    }

    void emitError(String msg, Element e) {
        if (ExpectError.isExpectedError(this.processingEnv, e, msg)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e);
    }
}

