/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.Instrumentable;
import com.oracle.truffle.api.instrumentation.InstrumentableFactory;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.dsl.processor.CodeWriter;
import com.oracle.truffle.dsl.processor.ExpectError;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.generator.GeneratorUtils;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationValue;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.java.transform.FixWarningsVisitor;
import com.oracle.truffle.dsl.processor.java.transform.GenerateOverrideVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.oracle.truffle.api.instrumentation.Instrumentable", "com.oracle.truffle.api.instrumentation.GenerateWrapper"})
public final class InstrumentableProcessor
extends AbstractProcessor {
    private static final String CLASS_SUFFIX = "Wrapper";
    private static final String EXECUTE_METHOD_PREFIX = "execute";
    private static final String CONSTANT_REENTER = "ProbeNode.UNWIND_ACTION_REENTER";
    private static final String METHOD_GET_NODE_COST = "getCost";
    private static final String METHOD_ON_RETURN_EXCEPTIONAL_OR_UNWIND = "onReturnExceptionalOrUnwind";
    private static final String METHOD_ON_RETURN_VALUE = "onReturnValue";
    private static final String METHOD_ON_ENTER = "onEnter";
    private static final String FIELD_DELEGATE = "delegateNode";
    private static final String FIELD_PROBE = "probeNode";
    private static final String VAR_RETURN_CALLED = "wasOnReturnExecuted";
    private static final String CREATE_WRAPPER_NAME = "createWrapper";

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        try {
            ProcessorContext context = new ProcessorContext(this.processingEnv, null);
            ProcessorContext.setThreadLocalInstance(context);
            DeclaredType instrumentableNode = context.getDeclaredType(InstrumentableNode.class);
            ExecutableElement createWrapper = ElementUtils.findExecutableElement(instrumentableNode, CREATE_WRAPPER_NAME);
            for (Element element : roundEnv.getElementsAnnotatedWith(GenerateWrapper.class)) {
                if (!element.getKind().isClass() && !element.getKind().isInterface()) continue;
                try {
                    CodeTypeElement unit;
                    if (element.getKind() != ElementKind.CLASS) {
                        this.emitError(element, String.format("Only classes can be annotated with %s.", GenerateWrapper.class.getSimpleName()));
                        continue;
                    }
                    if (createWrapper == null) {
                        this.emitError(element, String.format("Fatal %s.%s not found.", InstrumentableNode.class.getSimpleName(), CREATE_WRAPPER_NAME));
                        continue;
                    }
                    if (!ElementUtils.isAssignable(element.asType(), instrumentableNode)) {
                        this.emitError(element, String.format("Classes annotated with @%s must implement %s.", GenerateWrapper.class.getSimpleName(), InstrumentableNode.class.getSimpleName()));
                        continue;
                    }
                    boolean createWrapperFound = false;
                    for (ExecutableElement declaredMethod : ElementFilter.methodsIn(element.getEnclosedElements())) {
                        if (!ElementUtils.signatureEquals(declaredMethod, createWrapper)) continue;
                        createWrapperFound = true;
                        break;
                    }
                    if (!createWrapperFound) {
                        this.emitError(element, String.format("Classes annotated with @%s must declare/override %s.%s and return a new instance of the generated wrapper class called %s. You may copy the following generated implementation: %n  @Override public %s createWrapper(%s probeNode) {%n    return new %s(this, probeNode);%n  }", GenerateWrapper.class.getSimpleName(), InstrumentableNode.class.getSimpleName(), CREATE_WRAPPER_NAME, InstrumentableProcessor.createWrapperClassName((TypeElement)element), InstrumentableNode.WrapperNode.class.getSimpleName(), ProbeNode.class.getSimpleName(), InstrumentableProcessor.createWrapperClassName((TypeElement)element)));
                        continue;
                    }
                    if (!ElementUtils.isAssignable(element.asType(), context.getType(Node.class))) {
                        this.emitError(element, String.format("Classes annotated with @%s must extend %s.", GenerateWrapper.class.getSimpleName(), Node.class.getSimpleName()));
                        continue;
                    }
                    AnnotationMirror generateWrapperMirror = ElementUtils.findAnnotationMirror(element.getAnnotationMirrors(), context.getType(GenerateWrapper.class));
                    if (generateWrapperMirror == null || (unit = this.generateWrapperOnly(context, element)) == null) continue;
                    DeclaredType overrideType = (DeclaredType)context.getType(Override.class);
                    unit.accept(new GenerateOverrideVisitor(overrideType), null);
                    unit.accept(new FixWarningsVisitor(element, overrideType), null);
                    unit.accept(new CodeWriter(context.getEnvironment(), element), null);
                }
                catch (Throwable e) {
                    this.handleThrowable(e, element);
                }
            }
            this.processLegacyInstrumentable(roundEnv, context);
            boolean bl = true;
            return bl;
        }
        finally {
            ProcessorContext.setThreadLocalInstance(null);
        }
    }

    private void processLegacyInstrumentable(RoundEnvironment roundEnv, ProcessorContext context) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Instrumentable.class)) {
            if (!element.getKind().isClass() && !element.getKind().isInterface()) continue;
            try {
                CodeTypeElement unit;
                TypeElement type;
                TypeMirror factoryType;
                boolean generateWrapper;
                if (element.getKind() != ElementKind.CLASS) {
                    this.emitError(element, String.format("Only classes can be annotated with %s.", Instrumentable.class.getSimpleName()));
                    continue;
                }
                AnnotationMirror generateWrapperMirror = ElementUtils.findAnnotationMirror(element.getAnnotationMirrors(), context.getType(GenerateWrapper.class));
                if (generateWrapperMirror != null) continue;
                TypeMirror instrumentableType = context.getType(Instrumentable.class);
                AnnotationMirror instrumentable = ElementUtils.findAnnotationMirror(element.getAnnotationMirrors(), instrumentableType);
                if (instrumentable == null || !(generateWrapper = (factoryType = ElementUtils.getAnnotationValue(TypeMirror.class, instrumentable, "factory")) == null || factoryType.getKind() == TypeKind.ERROR ? true : (type = ElementUtils.getTypeElement(context.getEnvironment(), "com.oracle.truffle.api.instrumentation.test.TestErrorFactory")) != null && ElementUtils.typeEquals(factoryType, type.asType())) || (unit = this.generateWrapperAndFactory(context, element)) == null) continue;
                DeclaredType overrideType = (DeclaredType)context.getType(Override.class);
                unit.accept(new GenerateOverrideVisitor(overrideType), null);
                unit.accept(new FixWarningsVisitor(element, overrideType), null);
                unit.accept(new CodeWriter(context.getEnvironment(), element), null);
            }
            catch (Throwable e) {
                this.handleThrowable(e, element);
            }
        }
    }

    private void handleThrowable(Throwable t, Element e) {
        String message = "Uncaught error in " + this.getClass().getSimpleName() + " while processing " + e + " ";
        ProcessorContext.getInstance().getEnvironment().getMessager().printMessage(Diagnostic.Kind.ERROR, message + ": " + ElementUtils.printException(t), e);
    }

    private CodeTypeElement generateWrapperOnly(ProcessorContext context, Element e) {
        CodeTypeElement wrapper = this.generateWrapper(context, e, true);
        if (wrapper == null) {
            return null;
        }
        this.assertNoErrorExpected(e);
        return wrapper;
    }

    private CodeTypeElement generateWrapperAndFactory(ProcessorContext context, Element e) {
        CodeTypeElement wrapper = this.generateWrapper(context, e, false);
        if (wrapper == null) {
            return null;
        }
        CodeTypeElement factory = InstrumentableProcessor.generateFactory(context, e, wrapper);
        DeclaredType suppressWarnings = context.getDeclaredType(SuppressWarnings.class);
        CodeAnnotationMirror suppressWarningsAnnotation = new CodeAnnotationMirror(suppressWarnings);
        suppressWarningsAnnotation.setElementValue(ElementUtils.findExecutableElement(suppressWarnings, "value"), new CodeAnnotationValue(Arrays.asList(new CodeAnnotationValue("deprecation"))));
        factory.getAnnotationMirrors().add(suppressWarningsAnnotation);
        wrapper.getModifiers().add(Modifier.STATIC);
        factory.add(wrapper);
        this.assertNoErrorExpected(e);
        return factory;
    }

    private static CodeTypeElement generateFactory(ProcessorContext context, Element e, CodeTypeElement wrapper) {
        TypeElement sourceType = (TypeElement)e;
        PackageElement pack = context.getEnvironment().getElementUtils().getPackageOf(sourceType);
        Set<Modifier> typeModifiers = ElementUtils.modifiers(Modifier.PUBLIC, Modifier.FINAL);
        CodeTypeElement factory = new CodeTypeElement(typeModifiers, ElementKind.CLASS, pack, InstrumentableProcessor.createWrapperClassName(sourceType));
        TypeMirror factoryType = context.reloadType(context.getType(InstrumentableFactory.class));
        factory.getImplements().add(new CodeTypeMirror.DeclaredCodeTypeMirror(ElementUtils.fromTypeMirror(factoryType), Arrays.asList(sourceType.asType())));
        GeneratorUtils.addGeneratedBy(context, factory, sourceType);
        TypeMirror returnType = context.getType(InstrumentableFactory.WrapperNode.class);
        CodeExecutableElement createMethod = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC), returnType, CREATE_WRAPPER_NAME, new CodeVariableElement[0]);
        createMethod.addParameter(new CodeVariableElement(sourceType.asType(), FIELD_DELEGATE));
        createMethod.addParameter(new CodeVariableElement(context.getType(ProbeNode.class), FIELD_PROBE));
        CodeTreeBuilder builder = createMethod.createBuilder();
        ExecutableElement constructor = ElementFilter.constructorsIn(wrapper.getEnclosedElements()).iterator().next();
        String firstParameterReference = null;
        if (constructor.getParameters().size() > 2) {
            TypeMirror firstParameter = constructor.getParameters().get(0).asType();
            if (ElementUtils.typeEquals(firstParameter, sourceType.asType())) {
                firstParameterReference = FIELD_DELEGATE;
            } else if (ElementUtils.typeEquals(firstParameter, context.getType(SourceSection.class))) {
                firstParameterReference = "delegateNode.getSourceSection()";
            }
        }
        builder.startReturn().startNew(wrapper.asType());
        if (firstParameterReference != null) {
            builder.string(firstParameterReference);
        }
        builder.string(FIELD_DELEGATE).string(FIELD_PROBE);
        builder.end().end();
        factory.add(createMethod);
        return factory;
    }

    private static String createWrapperClassName(TypeElement sourceType) {
        return sourceType.getSimpleName().toString() + CLASS_SUFFIX;
    }

    private static boolean hasUnexpectedResult(ProcessorContext context, ExecutableElement element) {
        TypeMirror unexpectedResult = context.getType(UnexpectedResultException.class);
        for (TypeMirror typeMirror : element.getThrownTypes()) {
            if (!ElementUtils.typeEquals(typeMirror, unexpectedResult)) continue;
            return true;
        }
        return false;
    }

    private CodeTypeElement generateWrapper(ProcessorContext context, Element e, boolean topLevelClass) {
        Set<Modifier> typeModifiers;
        VariableElement firstParameter;
        if (!e.getKind().isClass()) {
            return null;
        }
        if (e.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.emitError(e, "Class must not be private to generate a wrapper.");
            return null;
        }
        if (e.getModifiers().contains((Object)Modifier.FINAL)) {
            this.emitError(e, "Class must not be final to generate a wrapper.");
            return null;
        }
        if (e.getEnclosingElement().getKind() != ElementKind.PACKAGE && !e.getModifiers().contains((Object)Modifier.STATIC)) {
            this.emitError(e, "Inner class must be static to generate a wrapper.");
            return null;
        }
        TypeElement sourceType = (TypeElement)e;
        ExecutableElement constructor = null;
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(e.getEnclosedElements());
        if (constructors.isEmpty()) {
            constructors.add(new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC), null, e.getSimpleName().toString(), new CodeVariableElement[0]));
        }
        Iterator<ExecutableElement> iterator = constructors.listIterator();
        while (iterator.hasNext()) {
            ExecutableElement c = iterator.next();
            Modifier modifier = ElementUtils.getVisibility(c.getModifiers());
            if (modifier == Modifier.PRIVATE) {
                iterator.remove();
                continue;
            }
            if (!c.getParameters().isEmpty()) continue;
            constructor = c;
            break;
        }
        if (constructor == null) {
            for (ExecutableElement c : constructors) {
                firstParameter = c.getParameters().iterator().next();
                if (!ElementUtils.typeEquals(firstParameter.asType(), sourceType.asType())) continue;
                constructor = c;
                break;
            }
        }
        if (constructor == null) {
            for (ExecutableElement c : constructors) {
                firstParameter = c.getParameters().iterator().next();
                if (!ElementUtils.typeEquals(firstParameter.asType(), context.getType(SourceSection.class))) continue;
                constructor = c;
                break;
            }
        }
        if (constructor == null) {
            this.emitError(sourceType, "No suiteable constructor found for wrapper factory generation. At least one default or copy constructor must be visible.");
            return null;
        }
        PackageElement pack = context.getEnvironment().getElementUtils().getPackageOf(sourceType);
        String wrapperClassName = InstrumentableProcessor.createWrapperClassName(sourceType);
        if (topLevelClass) {
            typeModifiers = ElementUtils.modifiers(Modifier.FINAL);
        } else {
            typeModifiers = ElementUtils.modifiers(Modifier.PRIVATE, Modifier.FINAL);
            wrapperClassName = wrapperClassName + "0";
        }
        CodeTypeElement wrapperType = new CodeTypeElement(typeModifiers, ElementKind.CLASS, pack, wrapperClassName);
        TypeMirror resolvedSuperType = sourceType.asType();
        wrapperType.setSuperClass(resolvedSuperType);
        if (topLevelClass) {
            wrapperType.getImplements().add(context.getType(InstrumentableNode.WrapperNode.class));
        } else {
            wrapperType.getImplements().add(context.getType(InstrumentableFactory.WrapperNode.class));
        }
        GeneratorUtils.addGeneratedBy(context, wrapperType, sourceType);
        wrapperType.add(InstrumentableProcessor.createNodeChild(context, sourceType.asType(), FIELD_DELEGATE));
        wrapperType.add(InstrumentableProcessor.createNodeChild(context, context.getType(ProbeNode.class), FIELD_PROBE));
        Set<Modifier> constructorModifiers = topLevelClass ? ElementUtils.modifiers(new Modifier[0]) : ElementUtils.modifiers(Modifier.PRIVATE);
        CodeExecutableElement wrappedConstructor = GeneratorUtils.createConstructorUsingFields(constructorModifiers, wrapperType, constructor);
        wrapperType.add(wrappedConstructor);
        for (VariableElement field : wrapperType.getFields()) {
            CodeExecutableElement getter = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC), field.asType(), "get" + ElementUtils.firstLetterUpperCase(field.getSimpleName().toString()), new CodeVariableElement[0]);
            getter.createBuilder().startReturn().string(field.getSimpleName().toString()).end();
            wrapperType.add(getter);
        }
        if (InstrumentableProcessor.isOverrideableOrUndeclared(sourceType, METHOD_GET_NODE_COST)) {
            TypeMirror returnType = context.getType(NodeCost.class);
            CodeExecutableElement getInstrumentationTags = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC), returnType, METHOD_GET_NODE_COST, new CodeVariableElement[0]);
            getInstrumentationTags.createBuilder().startReturn().staticReference(returnType, "NONE").end();
            wrapperType.add(getInstrumentationTags);
        }
        ArrayList<ExecutableElement> wrappedMethods = new ArrayList<ExecutableElement>();
        ArrayList<ExecutableElement> wrappedExecuteMethods = new ArrayList<ExecutableElement>();
        List<? extends Element> elementList = context.getEnvironment().getElementUtils().getAllMembers(sourceType);
        ExecutableElement genericExecuteDelegate = null;
        for (ExecutableElement method : ElementFilter.methodsIn(elementList)) {
            VariableElement firstParam;
            if (!InstrumentableProcessor.isExecuteMethod(method) || !InstrumentableProcessor.isOverridable(method)) continue;
            VariableElement variableElement = firstParam = method.getParameters().isEmpty() ? null : method.getParameters().get(0);
            if (topLevelClass && (firstParam == null || !ElementUtils.isAssignable(firstParam.asType(), context.getType(VirtualFrame.class)))) {
                this.emitError(e, String.format("Wrapped execute method %s must have VirtualFrame as first parameter.", method.getSimpleName().toString()));
                return null;
            }
            if (!ElementUtils.isObject(method.getReturnType()) || method.getParameters().size() != 1 || genericExecuteDelegate != null) continue;
            genericExecuteDelegate = method;
        }
        for (ExecutableElement method : ElementFilter.methodsIn(elementList)) {
            if (!InstrumentableProcessor.isOverridable(method)) continue;
            String methodName = method.getSimpleName().toString();
            if (methodName.startsWith(EXECUTE_METHOD_PREFIX)) {
                wrappedExecuteMethods.add(method);
                continue;
            }
            if (!method.getModifiers().contains((Object)Modifier.ABSTRACT) || methodName.equals("getSourceSection") || methodName.equals(METHOD_GET_NODE_COST) || InstrumentableProcessor.hasUnexpectedResult(context, method)) continue;
            wrappedMethods.add(method);
        }
        ExecutableElement incomingConverterMethod = null;
        ExecutableElement outgoingConverterMethod = null;
        for (ExecutableElement method : ElementFilter.methodsIn(elementList)) {
            GenerateWrapper.IncomingConverter incomingConverter = method.getAnnotation(GenerateWrapper.IncomingConverter.class);
            GenerateWrapper.OutgoingConverter outgoingConverter = method.getAnnotation(GenerateWrapper.OutgoingConverter.class);
            if (incomingConverter != null) {
                if (incomingConverterMethod != null) {
                    this.emitError(sourceType, String.format("Only one @%s method allowed, found multiple.", GenerateWrapper.IncomingConverter.class.getSimpleName()));
                    return null;
                }
                if (!this.verifyConverter(method, GenerateWrapper.IncomingConverter.class)) continue;
                incomingConverterMethod = method;
            }
            if (outgoingConverter == null) continue;
            if (outgoingConverterMethod != null) {
                this.emitError(sourceType, String.format("Only one @%s method allowed, found multiple.", GenerateWrapper.OutgoingConverter.class.getSimpleName()));
                return null;
            }
            if (!this.verifyConverter(method, GenerateWrapper.OutgoingConverter.class)) continue;
            outgoingConverterMethod = method;
        }
        if (wrappedExecuteMethods.isEmpty()) {
            this.emitError(sourceType, String.format("No methods starting with name execute found to wrap.", new Object[0]));
            return null;
        }
        Collections.sort(wrappedExecuteMethods, new Comparator<ExecutableElement>(){

            @Override
            public int compare(ExecutableElement o1, ExecutableElement o2) {
                return ElementUtils.compareMethod(o1, o2);
            }
        });
        Iterator<ExecutableElement> iterator2 = wrappedExecuteMethods.iterator();
        while (iterator2.hasNext()) {
            String returnName;
            ExecutableElement method;
            ExecutableElement executeMethod = method = iterator2.next();
            CodeExecutableElement wrappedExecute = CodeExecutableElement.clone(executeMethod);
            wrappedExecute.getModifiers().remove((Object)Modifier.ABSTRACT);
            wrappedExecute.getAnnotationMirrors().clear();
            String frameParameterName = "null";
            for (VariableElement parameter : wrappedExecute.getParameters()) {
                if (!ElementUtils.typeEquals(context.getType(VirtualFrame.class), parameter.asType())) continue;
                frameParameterName = parameter.getSimpleName().toString();
                break;
            }
            CodeTreeBuilder builder = wrappedExecute.createBuilder();
            TypeMirror returnTypeMirror = executeMethod.getReturnType();
            boolean executeReturnsVoid = ElementUtils.isVoid(returnTypeMirror);
            if (executeReturnsVoid && genericExecuteDelegate != null && executeMethod.getParameters().size() == genericExecuteDelegate.getParameters().size()) {
                executeMethod = genericExecuteDelegate;
                returnTypeMirror = genericExecuteDelegate.getReturnType();
                executeReturnsVoid = false;
            }
            if (!executeReturnsVoid) {
                returnName = "returnValue";
                builder.declaration(returnTypeMirror, returnName, (CodeTree)null);
            } else {
                returnName = "null";
            }
            builder.startFor().startGroup().string(";;").end().end().startBlock();
            builder.declaration("boolean", VAR_RETURN_CALLED, "false");
            builder.startTryBlock();
            boolean hasUnexpectedResult = InstrumentableProcessor.hasUnexpectedResult(context, wrappedExecute);
            if (hasUnexpectedResult) {
                builder.startTryBlock();
            }
            builder.startStatement().startCall(FIELD_PROBE, METHOD_ON_ENTER).string(frameParameterName).end().end();
            CodeTreeBuilder callDelegate = builder.create();
            callDelegate.startCall(FIELD_DELEGATE, executeMethod.getSimpleName().toString());
            for (VariableElement parameter : wrappedExecute.getParameters()) {
                callDelegate.string(parameter.getSimpleName().toString());
            }
            callDelegate.end();
            if (executeReturnsVoid) {
                builder.statement(callDelegate.build());
            } else {
                builder.startStatement().string(returnName).string(" = ").tree(callDelegate.build()).end();
            }
            builder.startStatement().string(VAR_RETURN_CALLED).string(" = true").end();
            builder.startStatement().startCall(FIELD_PROBE, METHOD_ON_RETURN_VALUE).string(frameParameterName);
            if (outgoingConverterMethod == null || executeReturnsVoid) {
                builder.string(returnName);
            } else {
                builder.tree(InstrumentableProcessor.createCallConverter(outgoingConverterMethod, frameParameterName, CodeTreeBuilder.singleString(returnName)));
            }
            builder.end().end();
            builder.statement("break");
            if (hasUnexpectedResult) {
                builder.end().startCatchBlock(context.getType(UnexpectedResultException.class), "e");
                builder.startStatement().string(VAR_RETURN_CALLED).string(" = true").end();
                builder.startStatement().startCall(FIELD_PROBE, METHOD_ON_RETURN_VALUE).string(frameParameterName);
                if (outgoingConverterMethod == null || executeReturnsVoid) {
                    builder.string("e.getResult()");
                } else {
                    builder.tree(InstrumentableProcessor.createCallConverter(outgoingConverterMethod, frameParameterName, CodeTreeBuilder.singleString("e.getResult()")));
                }
                builder.end().end();
                builder.startThrow().string("e").end().end();
            }
            builder.end().startCatchBlock(context.getType(Throwable.class), "t");
            CodeTreeBuilder callExOrUnwind = builder.create();
            callExOrUnwind.startCall(FIELD_PROBE, METHOD_ON_RETURN_EXCEPTIONAL_OR_UNWIND).string(frameParameterName).string("t").string(VAR_RETURN_CALLED).end();
            builder.declaration("Object", "result", callExOrUnwind.build());
            builder.startIf().string("result == ").string(CONSTANT_REENTER).end();
            builder.startBlock();
            builder.statement("continue");
            if (ElementUtils.isVoid(wrappedExecute.getReturnType())) {
                builder.end().startElseIf();
                builder.string("result != null").end();
                builder.startBlock();
                builder.statement("break");
            } else {
                boolean objectReturnType = "java.lang.Object".equals(ElementUtils.getQualifiedName(returnTypeMirror)) && returnTypeMirror.getKind() != TypeKind.ARRAY;
                boolean throwsUnexpectedResult = InstrumentableProcessor.hasUnexpectedResult(context, wrappedExecute);
                if (objectReturnType || !throwsUnexpectedResult) {
                    builder.end().startElseIf();
                    builder.string("result != null").end();
                    builder.startBlock();
                    builder.startStatement().string(returnName).string(" = ");
                    if (!objectReturnType) {
                        builder.string("(").string(ElementUtils.getSimpleName(returnTypeMirror)).string(") ");
                    }
                    if (incomingConverterMethod == null) {
                        builder.string("result");
                    } else {
                        builder.tree(InstrumentableProcessor.createCallConverter(incomingConverterMethod, frameParameterName, CodeTreeBuilder.singleString("result")));
                    }
                    builder.end();
                    builder.statement("break");
                } else {
                    builder.end();
                    if (incomingConverterMethod != null) {
                        builder.startIf().string("result != null").end().startBlock();
                        builder.startStatement();
                        builder.string("result = ");
                        builder.tree(InstrumentableProcessor.createCallConverter(incomingConverterMethod, frameParameterName, CodeTreeBuilder.singleString("result")));
                        builder.end();
                        builder.end();
                    }
                    builder.startIf();
                    builder.string("result").instanceOf(InstrumentableProcessor.boxed(returnTypeMirror, context.getEnvironment().getTypeUtils())).end();
                    builder.startBlock();
                    builder.startStatement().string(returnName).string(" = ");
                    builder.string("(").string(ElementUtils.getSimpleName(returnTypeMirror)).string(") ");
                    builder.string("result");
                    builder.end();
                    builder.statement("break");
                    builder.end();
                    builder.startElseIf().string("result != null").end();
                    builder.startBlock();
                    builder.startThrow().startNew(context.getType(UnexpectedResultException.class));
                    builder.string("result");
                    builder.end().end();
                }
            }
            builder.end();
            builder.startThrow().string("t").end();
            builder.end(2);
            if (!ElementUtils.isVoid(wrappedExecute.getReturnType())) {
                builder.startReturn().string(returnName).end();
            }
            wrapperType.add(wrappedExecute);
        }
        for (ExecutableElement delegateMethod : wrappedMethods) {
            CodeExecutableElement generatedMethod = CodeExecutableElement.clone(delegateMethod);
            generatedMethod.getModifiers().remove((Object)Modifier.ABSTRACT);
            CodeTreeBuilder callDelegate = generatedMethod.createBuilder();
            if (ElementUtils.isVoid(delegateMethod.getReturnType())) {
                callDelegate.startStatement();
            } else {
                callDelegate.startReturn();
            }
            callDelegate.startCall("this.delegateNode", generatedMethod.getSimpleName().toString());
            for (VariableElement parameter : generatedMethod.getParameters()) {
                callDelegate.string(parameter.getSimpleName().toString());
            }
            callDelegate.end().end();
            wrapperType.add(generatedMethod);
        }
        return wrapperType;
    }

    private static boolean isExecuteMethod(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        return methodName.startsWith(EXECUTE_METHOD_PREFIX);
    }

    private static boolean isOverridable(ExecutableElement method) {
        Set<Modifier> modifiers = method.getModifiers();
        if (modifiers.contains((Object)Modifier.FINAL)) {
            return false;
        }
        Modifier visibility = ElementUtils.getVisibility(modifiers);
        return visibility != Modifier.PRIVATE;
    }

    private static CodeTree createCallConverter(ExecutableElement converterMethod, String frameParameterName, CodeTree returnName) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        if (converterMethod.getModifiers().contains((Object)Modifier.STATIC)) {
            builder.startStaticCall(converterMethod);
        } else {
            builder.startCall("this.delegateNode", converterMethod.getSimpleName().toString());
        }
        if (converterMethod.getParameters().size() == 1) {
            builder.tree(returnName);
        } else {
            if (converterMethod.getParameters().size() != 2) {
                throw new AssertionError();
            }
            builder.string(frameParameterName);
            builder.tree(returnName);
        }
        builder.end();
        return builder.build();
    }

    private boolean verifyConverter(ExecutableElement method, Class<?> annotationClass) {
        if (method.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.emitError(method, String.format("Method annotated with @%s must not be private.", annotationClass.getSimpleName()));
            return false;
        }
        if (method.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.emitError(method, String.format("Method annotated with @%s must not be abstract.", annotationClass.getSimpleName()));
            return false;
        }
        DeclaredType frameClass = ProcessorContext.getInstance().getDeclaredType(VirtualFrame.class);
        DeclaredType objectClass = ProcessorContext.getInstance().getDeclaredType(Object.class);
        boolean valid = true;
        if (method.getParameters().size() == 1) {
            TypeMirror firstType = method.getParameters().get(0).asType();
            if (!ElementUtils.typeEquals(firstType, objectClass)) {
                valid = false;
            }
        } else if (method.getParameters().size() == 2) {
            TypeMirror secondType;
            TypeMirror firstType = method.getParameters().get(0).asType();
            if (!ElementUtils.typeEquals(firstType, frameClass)) {
                valid = false;
            }
            if (!ElementUtils.typeEquals(secondType = method.getParameters().get(1).asType(), objectClass)) {
                valid = false;
            }
        } else {
            valid = false;
        }
        if (!ElementUtils.typeEquals(method.getReturnType(), objectClass)) {
            valid = false;
        }
        if (!valid) {
            this.emitError(method, String.format("Invalid @%s method signature. Must be either Object converter(Object) or Object converter(%s, Object)", annotationClass.getSimpleName(), VirtualFrame.class.getSimpleName()));
            return false;
        }
        return true;
    }

    private static TypeMirror boxed(TypeMirror type, Types types) {
        if (type.getKind().isPrimitive()) {
            return types.boxedClass((PrimitiveType)type).asType();
        }
        return type;
    }

    private static boolean isOverrideableOrUndeclared(TypeElement sourceType, String methodName) {
        List<ExecutableElement> elements = ElementUtils.getDeclaredMethodsInSuperTypes(sourceType, methodName, new TypeMirror[0]);
        return elements.isEmpty() || !elements.iterator().next().getModifiers().contains((Object)Modifier.FINAL);
    }

    private static CodeVariableElement createNodeChild(ProcessorContext context, TypeMirror type, String name) {
        CodeVariableElement var = new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE), type, name);
        var.addAnnotationMirror(new CodeAnnotationMirror((DeclaredType)context.getType(Node.Child.class)));
        return var;
    }

    void assertNoErrorExpected(Element e) {
        ExpectError.assertNoErrorExpected(this.processingEnv, e);
    }

    void emitError(Element e, String msg) {
        if (ExpectError.isExpectedError(this.processingEnv, e, msg)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e);
    }

    void emitError(Element e, AnnotationMirror annotation, String msg) {
        if (ExpectError.isExpectedError(this.processingEnv, e, msg)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e, annotation);
    }
}

