/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.dsl.processor.ExpectError;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.oracle.truffle.api.TruffleLanguage.Registration"})
public final class LanguageRegistrationProcessor
extends AbstractProcessor {
    private final List<TypeElement> registrations = new ArrayList<TypeElement>();
    private static final Set<String> RESERVED_IDS = new HashSet<String>(Arrays.asList("host", "graal", "truffle", "engine", "language", "instrument", "graalvm", "context", "polyglot", "compiler", "vm", "log"));

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private void generateFile(List<TypeElement> languages) {
        String filename = "META-INF/truffle/language";
        SortedProperties p = new SortedProperties();
        int cnt = 0;
        for (TypeElement l : languages) {
            TruffleLanguage.Registration annotation = l.getAnnotation(TruffleLanguage.Registration.class);
            if (annotation == null) continue;
            String prefix = "language" + ++cnt + ".";
            String className = this.processingEnv.getElementUtils().getBinaryName(l).toString();
            String id = annotation.id();
            if (id != null && !id.isEmpty()) {
                p.setProperty(prefix + "id", id);
            }
            p.setProperty(prefix + "name", annotation.name());
            p.setProperty(prefix + "implementationName", annotation.implementationName());
            p.setProperty(prefix + "version", annotation.version());
            p.setProperty(prefix + "className", className);
            if (!annotation.defaultMimeType().equals("")) {
                p.setProperty(prefix + "defaultMimeType", annotation.defaultMimeType());
            }
            String[] mimes = annotation.mimeType();
            for (int i = 0; i < mimes.length; ++i) {
                p.setProperty(prefix + "mimeType." + i, mimes[i]);
            }
            Object[] charMimes = annotation.characterMimeTypes();
            Arrays.sort(charMimes);
            for (int i = 0; i < charMimes.length; ++i) {
                p.setProperty(prefix + "characterMimeType." + i, (String)charMimes[i]);
            }
            Object[] byteMimes = annotation.byteMimeTypes();
            Arrays.sort(byteMimes);
            for (int i = 0; i < byteMimes.length; ++i) {
                p.setProperty(prefix + "byteMimeType." + i, (String)byteMimes[i]);
            }
            Object[] dependencies = annotation.dependentLanguages();
            Arrays.sort(dependencies);
            for (int i = 0; i < dependencies.length; ++i) {
                p.setProperty(prefix + "dependentLanguage." + i, (String)dependencies[i]);
            }
            p.setProperty(prefix + "interactive", Boolean.toString(annotation.interactive()));
            p.setProperty(prefix + "internal", Boolean.toString(annotation.internal()));
            AnnotationMirror registration = ElementUtils.findAnnotationMirror(l.getAnnotationMirrors(), ProcessorContext.getInstance().getType(TruffleLanguage.Registration.class));
            int serviceCounter = 0;
            for (TypeMirror serviceTypeMirror : ElementUtils.getAnnotationValueList(TypeMirror.class, registration, "services")) {
                p.setProperty(prefix + "service" + serviceCounter++, this.processingEnv.getElementUtils().getBinaryName(ElementUtils.fromTypeMirror(serviceTypeMirror)).toString());
            }
            int fileTypeDetectorCounter = 0;
            for (TypeMirror fileTypeDetectorTypeMirror : ElementUtils.getAnnotationValueList(TypeMirror.class, registration, "fileTypeDetectors")) {
                p.setProperty(prefix + "fileTypeDetector" + fileTypeDetectorCounter++, this.processingEnv.getElementUtils().getBinaryName(ElementUtils.fromTypeMirror(fileTypeDetectorTypeMirror)).toString());
            }
        }
        if (cnt > 0) {
            try {
                FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", filename, languages.toArray(new Element[0]));
                try (OutputStream os = file.openOutputStream();){
                    p.store(os, "Generated by " + LanguageRegistrationProcessor.class.getName());
                }
            }
            catch (IOException e) {
                if (e instanceof FilerException && e.getMessage().startsWith("Source file already created")) {
                    return;
                }
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage(), languages.get(0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ProcessorContext.setThreadLocalInstance(new ProcessorContext(this.processingEnv, null));
        try {
            if (roundEnv.processingOver()) {
                this.generateFile(this.registrations);
                this.registrations.clear();
                boolean bl = true;
                return bl;
            }
            TypeMirror registration = ProcessorContext.getInstance().getType(TruffleLanguage.Registration.class);
            for (Element element : roundEnv.getElementsAnnotatedWith(TruffleLanguage.Registration.class)) {
                HashSet<String> mimeTypes;
                boolean bl;
                AnnotationMirror mirror = ElementUtils.findAnnotationMirror(element.getAnnotationMirrors(), registration);
                TruffleLanguage.Registration annotation = element.getAnnotation(TruffleLanguage.Registration.class);
                if (annotation == null || element.getKind() != ElementKind.CLASS) continue;
                if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    this.emitError("Registered language class must be public", element);
                    continue;
                }
                if (element.getEnclosingElement().getKind() != ElementKind.PACKAGE && !element.getModifiers().contains((Object)Modifier.STATIC)) {
                    this.emitError("Registered language inner-class must be static", element);
                    continue;
                }
                TypeMirror truffleLang = this.processingEnv.getTypeUtils().erasure(ElementUtils.getTypeElement(this.processingEnv, TruffleLanguage.class.getName()).asType());
                if (!this.processingEnv.getTypeUtils().isAssignable(element.asType(), truffleLang)) {
                    this.emitError("Registered language class must subclass TruffleLanguage", element);
                    continue;
                }
                boolean foundConstructor = false;
                for (ExecutableElement executableElement : ElementFilter.constructorsIn(element.getEnclosedElements())) {
                    if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC) || !executableElement.getParameters().isEmpty()) continue;
                    foundConstructor = true;
                    break;
                }
                Element singletonElement = null;
                for (Element mem : element.getEnclosedElements()) {
                    if (!mem.getModifiers().contains((Object)Modifier.PUBLIC) || mem.getKind() != ElementKind.FIELD || !mem.getModifiers().contains((Object)Modifier.FINAL) || !"INSTANCE".equals(mem.getSimpleName().toString()) || !this.processingEnv.getTypeUtils().isAssignable(mem.asType(), truffleLang)) continue;
                    singletonElement = mem;
                    break;
                }
                boolean bl2 = true;
                if (singletonElement != null) {
                    this.emitWarning("Using a singleton field is deprecated. Please provide a public no-argument constructor instead.", singletonElement);
                    bl = false;
                } else if (!foundConstructor) {
                    this.emitError("A TruffleLanguage subclass must have a public no argument constructor.", element);
                    continue;
                }
                if (!this.validateMimeTypes(mimeTypes = new HashSet<String>(), element, mirror, ElementUtils.getAnnotationValue(mirror, "characterMimeTypes"), annotation.characterMimeTypes()) || !this.validateMimeTypes(mimeTypes, element, mirror, ElementUtils.getAnnotationValue(mirror, "byteMimeTypes"), annotation.byteMimeTypes())) continue;
                String defaultMimeType = annotation.defaultMimeType();
                if (mimeTypes.size() > 1 && (defaultMimeType == null || defaultMimeType.equals(""))) {
                    this.emitError("No defaultMimeType attribute specified. The defaultMimeType attribute needs to be specified if more than one MIME type was specified.", element, mirror, ElementUtils.getAnnotationValue(mirror, "defaultMimeType"));
                    continue;
                }
                if (defaultMimeType != null && !defaultMimeType.equals("") && !mimeTypes.contains(defaultMimeType)) {
                    this.emitError("The defaultMimeType is not contained in the list of supported characterMimeTypes or byteMimeTypes. Add the specified default MIME type to character or byte MIME types to resolve this.", element, mirror, ElementUtils.getAnnotationValue(mirror, "defaultMimeType"));
                    continue;
                }
                if (annotation.mimeType().length == 0) {
                    String id = annotation.id();
                    if (id.isEmpty()) {
                        this.emitError("The attribute id is mandatory.", element, mirror, null);
                        continue;
                    }
                    if (RESERVED_IDS.contains(id)) {
                        this.emitError(String.format("Id '%s' is reserved for other use and must not be used as id.", id), element, mirror, ElementUtils.getAnnotationValue(mirror, "id"));
                        continue;
                    }
                }
                if (!this.validateFileTypeDetectors(element, mirror)) continue;
                if (bl) {
                    this.assertNoErrorExpected(element);
                }
                this.registrations.add((TypeElement)element);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ProcessorContext.setThreadLocalInstance(null);
        }
    }

    private boolean validateMimeTypes(Set<String> collectedMimeTypes, Element e, AnnotationMirror mirror, AnnotationValue value, String[] loadedMimeTypes) {
        for (String mimeType : loadedMimeTypes) {
            if (!this.validateMimeType(e, mirror, value, mimeType)) {
                return false;
            }
            if (collectedMimeTypes.contains(mimeType)) {
                this.emitError(String.format("Duplicate MIME type specified '%s'. MIME types must be unique.", mimeType), e, mirror, value);
                return false;
            }
            collectedMimeTypes.add(mimeType);
        }
        return true;
    }

    private boolean validateMimeType(Element type, AnnotationMirror mirror, AnnotationValue value, String mimeType) {
        int index = mimeType.indexOf(47);
        if (index == -1 || index == 0 || index == mimeType.length() - 1) {
            this.emitError(String.format("Invalid MIME type '%s' provided. MIME types consist of a type and a subtype separated by '/'.", mimeType), type, mirror, value);
            return false;
        }
        if (mimeType.indexOf(47, index + 1) != -1) {
            this.emitError(String.format("Invalid MIME type '%s' provided. MIME types consist of a type and a subtype separated by '/'.", mimeType), type, mirror, value);
            return false;
        }
        return true;
    }

    private boolean validateFileTypeDetectors(Element annotatedElement, AnnotationMirror mirror) {
        AnnotationValue value = ElementUtils.getAnnotationValue(mirror, "fileTypeDetectors", true);
        for (TypeMirror fileTypeDetectorType : ElementUtils.getAnnotationValueList(TypeMirror.class, mirror, "fileTypeDetectors")) {
            TypeElement fileTypeDetectorElement = ElementUtils.fromTypeMirror(fileTypeDetectorType);
            if (!fileTypeDetectorElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.emitError("Registered FileTypeDetector class must be public.", annotatedElement, mirror, value);
                return false;
            }
            if (fileTypeDetectorElement.getEnclosingElement().getKind() != ElementKind.PACKAGE && !fileTypeDetectorElement.getModifiers().contains((Object)Modifier.STATIC)) {
                this.emitError("Registered FileTypeDetector inner-class must be static.", annotatedElement, mirror, value);
                return false;
            }
            boolean foundConstructor = false;
            for (ExecutableElement constructor : ElementFilter.constructorsIn(fileTypeDetectorElement.getEnclosedElements())) {
                if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC) || !constructor.getParameters().isEmpty()) continue;
                foundConstructor = true;
                break;
            }
            if (foundConstructor) continue;
            this.emitError("A FileTypeDetector subclass must have a public no argument constructor.", annotatedElement, mirror, value);
            return false;
        }
        return true;
    }

    void assertNoErrorExpected(Element e) {
        ExpectError.assertNoErrorExpected(this.processingEnv, e);
    }

    void emitError(String msg, Element e) {
        if (ExpectError.isExpectedError(this.processingEnv, e, msg)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e);
    }

    void emitError(String msg, Element e, AnnotationMirror mirror, AnnotationValue value) {
        if (ExpectError.isExpectedError(this.processingEnv, e, msg)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e, mirror, value);
    }

    void emitWarning(String msg, Element e) {
        if (ExpectError.isExpectedError(this.processingEnv, e, msg)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg, e);
    }

    void emitWarning(String msg, Element e, AnnotationMirror mirror, AnnotationValue value) {
        if (ExpectError.isExpectedError(this.processingEnv, e, msg)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg, e, mirror, value);
    }

    static class SortedProperties
    extends Properties {
        SortedProperties() {
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            return Collections.enumeration(new TreeSet<Object>(super.keySet()));
        }
    }
}

