/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.dsl.processor.CodeWriter;
import com.oracle.truffle.dsl.processor.ExpectError;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.generator.GeneratorUtils;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.transform.FixWarningsVisitor;
import com.oracle.truffle.dsl.processor.java.transform.GenerateOverrideVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;

@SupportedAnnotationTypes(value={"com.oracle.truffle.api.Option", "com.oracle.truffle.api.Option.Group"})
public class OptionProcessor
extends AbstractProcessor {
    private final Set<Element> processed = new HashSet<Element>();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        ProcessorContext context = new ProcessorContext(this.processingEnv, null);
        ProcessorContext.setThreadLocalInstance(context);
        try {
            HashMap<Element, Object> map = new HashMap<Element, Object>();
            for (Element element : roundEnv.getElementsAnnotatedWith(Option.class)) {
                if (this.processed.contains(element)) continue;
                this.processed.add(element);
                Element topElement = element.getEnclosingElement();
                Object options = (OptionsInfo)map.get(topElement);
                if (options == null) {
                    options = new OptionsInfo(topElement);
                    map.put(topElement, options);
                }
                AnnotationMirror mirror = ElementUtils.findAnnotationMirror(this.processingEnv, element.getAnnotationMirrors(), Option.class);
                try {
                    this.processElement(element, mirror, (OptionsInfo)options);
                }
                catch (Throwable t) {
                    this.handleThrowable(t, topElement);
                }
            }
            HashMap<String, OptionInfo> seenKeys = new HashMap<String, OptionInfo>();
            for (OptionsInfo infos : map.values()) {
                for (OptionInfo info : infos.options) {
                    if (seenKeys.containsKey(info.name)) {
                        OptionInfo otherInfo = (OptionInfo)seenKeys.get(info.name);
                        String message = "Two options with duplicated resolved descriptor name '%s' found.";
                        info.valid = false;
                        otherInfo.valid = false;
                        OptionProcessor.error(info.field, info.annotation, message, info.name);
                        OptionProcessor.error(otherInfo.field, otherInfo.annotation, message, otherInfo.name);
                        continue;
                    }
                    seenKeys.put(info.name, info);
                }
            }
            for (OptionsInfo infos : map.values()) {
                ListIterator<OptionInfo> listIterator = infos.options.listIterator();
                while (listIterator.hasNext()) {
                    OptionInfo info;
                    info = listIterator.next();
                    if (info.valid) {
                        ExpectError.assertNoErrorExpected(this.processingEnv, info.field);
                        continue;
                    }
                    listIterator.remove();
                }
                Collections.sort(infos.options, new Comparator<OptionInfo>(){

                    @Override
                    public int compare(OptionInfo o1, OptionInfo o2) {
                        return o1.name.compareTo(o2.name);
                    }
                });
            }
            for (OptionsInfo info : map.values()) {
                try {
                    OptionProcessor.generateOptionDescriptor(info);
                }
                catch (Throwable t) {
                    this.handleThrowable(t, info.type);
                }
            }
        }
        finally {
            ProcessorContext.setThreadLocalInstance(null);
        }
        return true;
    }

    private boolean processElement(Element element, AnnotationMirror elementAnnotation, OptionsInfo info) {
        char firstChar;
        ProcessorContext context = ProcessorContext.getInstance();
        if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
            OptionProcessor.error(element, elementAnnotation, "Option field must be static", new Object[0]);
            return false;
        }
        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            OptionProcessor.error(element, elementAnnotation, "Option field cannot be private", new Object[0]);
            return false;
        }
        String[] groupPrefixStrings = null;
        Option.Group prefix = info.type.getAnnotation(Option.Group.class);
        if (prefix != null) {
            groupPrefixStrings = prefix.value();
        } else {
            TruffleLanguage.Registration registration;
            TypeMirror erasedTruffleType = context.getEnvironment().getTypeUtils().erasure(context.getType(TruffleLanguage.class));
            if (context.getEnvironment().getTypeUtils().isAssignable(info.type.asType(), erasedTruffleType)) {
                registration = info.type.getAnnotation(TruffleLanguage.Registration.class);
                if (registration != null && (groupPrefixStrings = new String[]{registration.id()})[0].isEmpty()) {
                    OptionProcessor.error(element, elementAnnotation, "%s must specify an id such that Truffle options can infer their prefix.", TruffleLanguage.Registration.class.getSimpleName());
                    return false;
                }
            } else if (context.getEnvironment().getTypeUtils().isAssignable(info.type.asType(), context.getType(TruffleInstrument.class)) && (registration = info.type.getAnnotation(TruffleInstrument.Registration.class)) != null && (groupPrefixStrings = new String[]{registration.id()})[0].isEmpty()) {
                OptionProcessor.error(element, elementAnnotation, "%s must specify an id such that Truffle options can infer their prefix.", TruffleInstrument.Registration.class.getSimpleName());
                return false;
            }
        }
        if (groupPrefixStrings == null || groupPrefixStrings.length == 0) {
            groupPrefixStrings = new String[]{""};
        }
        Option annotation = element.getAnnotation(Option.class);
        assert (annotation != null);
        assert (element instanceof VariableElement);
        assert (element.getKind() == ElementKind.FIELD);
        VariableElement field = (VariableElement)element;
        String fieldName = field.getSimpleName().toString();
        Types types = this.processingEnv.getTypeUtils();
        TypeMirror fieldType = field.asType();
        if (fieldType.getKind() != TypeKind.DECLARED) {
            OptionProcessor.error(element, elementAnnotation, "Option field must be of type " + OptionKey.class.getName(), new Object[0]);
            return false;
        }
        TypeMirror optionKeyType = ElementUtils.getTypeElement(this.processingEnv, OptionKey.class.getName()).asType();
        if (!types.isSubtype(fieldType, types.erasure(optionKeyType))) {
            OptionProcessor.error(element, elementAnnotation, "Option field type %s is not a subclass of %s", fieldType, optionKeyType);
            return false;
        }
        if (!field.getModifiers().contains((Object)Modifier.STATIC)) {
            OptionProcessor.error(element, elementAnnotation, "Option field must be static", new Object[0]);
            return false;
        }
        if (field.getModifiers().contains((Object)Modifier.PRIVATE)) {
            OptionProcessor.error(element, elementAnnotation, "Option field cannot be private", new Object[0]);
            return false;
        }
        String help = annotation.help();
        if (help.length() != 0 && !Character.isUpperCase(firstChar = help.charAt(0))) {
            OptionProcessor.error(element, elementAnnotation, "Option help text must start with upper case letter", new Object[0]);
            return false;
        }
        AnnotationValue value = ElementUtils.getAnnotationValue(elementAnnotation, "name", false);
        String optionName = value == null ? fieldName : annotation.name();
        boolean deprecated = annotation.deprecated();
        OptionCategory category = annotation.category();
        if (category == null) {
            category = OptionCategory.INTERNAL;
        }
        OptionStability stability = annotation.stability();
        for (String group : groupPrefixStrings) {
            if (group.isEmpty() && optionName.isEmpty()) {
                OptionProcessor.error(element, elementAnnotation, "Both group and option name cannot be empty", new Object[0]);
                continue;
            }
            String name = optionName.isEmpty() ? group : (group.isEmpty() ? optionName : group + "." + optionName);
            info.options.add(new OptionInfo(name, help, field, elementAnnotation, deprecated, category, stability));
        }
        return true;
    }

    private static void error(Element element, AnnotationMirror annotation, String message, Object ... args) {
        String formattedMessage;
        ProcessingEnvironment processingEnv = ProcessorContext.getInstance().getEnvironment();
        if (ExpectError.isExpectedError(processingEnv, element, formattedMessage = String.format(message, args))) {
            return;
        }
        processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, formattedMessage, element, annotation);
    }

    private static void generateOptionDescriptor(OptionsInfo info) {
        block2: {
            Element element = info.type;
            ProcessorContext context = ProcessorContext.getInstance();
            CodeTypeElement unit = OptionProcessor.generateDescriptors(context, element, info);
            DeclaredType overrideType = (DeclaredType)context.getType(Override.class);
            unit.accept(new GenerateOverrideVisitor(overrideType), null);
            unit.accept(new FixWarningsVisitor(element, overrideType), null);
            try {
                unit.accept(new CodeWriter(context.getEnvironment(), element), null);
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof FilerException) || !e.getCause().getMessage().startsWith("Source file already created")) break block2;
                return;
            }
        }
    }

    private void handleThrowable(Throwable t, Element e) {
        String message = "Uncaught error in " + this.getClass().getSimpleName() + " while processing " + e + " ";
        ProcessorContext.getInstance().getEnvironment().getMessager().printMessage(Diagnostic.Kind.ERROR, message + ": " + ElementUtils.printException(t), e);
    }

    private static CodeTypeElement generateDescriptors(ProcessorContext context, Element element, OptionsInfo model) {
        String optionsClassName = ElementUtils.getSimpleName(element.asType()) + OptionDescriptors.class.getSimpleName();
        TypeElement sourceType = (TypeElement)model.type;
        PackageElement pack = context.getEnvironment().getElementUtils().getPackageOf(sourceType);
        Set<Modifier> typeModifiers = ElementUtils.modifiers(Modifier.FINAL);
        CodeTypeElement descriptors = new CodeTypeElement(typeModifiers, ElementKind.CLASS, pack, optionsClassName);
        DeclaredType optionDescriptorsType = context.getDeclaredType(OptionDescriptors.class);
        descriptors.getImplements().add(optionDescriptorsType);
        GeneratorUtils.addGeneratedBy(context, descriptors, (TypeElement)element);
        ExecutableElement get = ElementUtils.findExecutableElement(optionDescriptorsType, "get");
        CodeExecutableElement getMethod = CodeExecutableElement.clone(get);
        getMethod.getModifiers().remove((Object)Modifier.ABSTRACT);
        CodeTreeBuilder builder = getMethod.createBuilder();
        String nameVariableName = getMethod.getParameters().get(0).getSimpleName().toString();
        builder.startSwitch().string(nameVariableName).end().startBlock();
        for (OptionInfo info : model.options) {
            builder.startCase().doubleQuote(info.name).end().startCaseBlock();
            builder.startReturn().tree(OptionProcessor.createBuildOptionDescriptor(context, info)).end();
            builder.end();
        }
        builder.end();
        builder.returnNull();
        descriptors.add(getMethod);
        CodeExecutableElement iteratorMethod = CodeExecutableElement.clone(ElementUtils.findExecutableElement(optionDescriptorsType, "iterator"));
        iteratorMethod.getModifiers().remove((Object)Modifier.ABSTRACT);
        builder = iteratorMethod.createBuilder();
        builder.startReturn();
        if (model.options.isEmpty()) {
            builder.startStaticCall(context.getType(Collections.class), "<OptionDescriptor> emptyList().iterator").end();
        } else {
            builder.startStaticCall(context.getType(Arrays.class), "asList");
            for (OptionInfo info : model.options) {
                builder.startGroup();
                builder.startIndention();
                builder.newLine();
                builder.tree(OptionProcessor.createBuildOptionDescriptor(context, info));
                builder.end();
                builder.end();
            }
            builder.end();
            builder.newLine();
            builder.startCall("", "iterator").end();
        }
        builder.end();
        descriptors.add(iteratorMethod);
        return descriptors;
    }

    private static CodeTree createBuildOptionDescriptor(ProcessorContext context, OptionInfo info) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.startStaticCall(context.getType(OptionDescriptor.class), "newBuilder");
        VariableElement var = info.field;
        builder.staticReference(var.getEnclosingElement().asType(), var.getSimpleName().toString());
        builder.doubleQuote(info.name);
        builder.end();
        if (info.deprecated) {
            builder.startCall("", "deprecated").string("true").end();
        } else {
            builder.startCall("", "deprecated").string("false").end();
        }
        builder.startCall("", "help").doubleQuote(info.help).end();
        builder.startCall("", "category").staticReference(context.getType(OptionCategory.class), info.category.name()).end();
        builder.startCall("", "stability").staticReference(context.getType(OptionStability.class), info.stability.name()).end();
        builder.startCall("", "build").end();
        return builder.build();
    }

    static class OptionsInfo {
        final Element type;
        final List<OptionInfo> options = new ArrayList<OptionInfo>();

        OptionsInfo(Element topDeclaringType) {
            this.type = topDeclaringType;
        }
    }

    static class OptionInfo
    implements Comparable<OptionInfo> {
        boolean valid = true;
        final String name;
        final String help;
        final boolean deprecated;
        final VariableElement field;
        final AnnotationMirror annotation;
        final OptionCategory category;
        final OptionStability stability;

        OptionInfo(String name, String help, VariableElement field, AnnotationMirror annotation, boolean deprecated, OptionCategory category, OptionStability stability) {
            this.name = name;
            this.help = help;
            this.field = field;
            this.annotation = annotation;
            this.deprecated = deprecated;
            this.category = category;
            this.stability = stability;
        }

        @Override
        public int compareTo(OptionInfo other) {
            return this.name.compareTo(other.name);
        }
    }
}

