/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystem;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.library.GenerateLibrary;
import com.oracle.truffle.dsl.processor.AnnotationProcessor;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.generator.NodeCodeGenerator;
import com.oracle.truffle.dsl.processor.generator.TypeSystemCodeGenerator;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.library.ExportsData;
import com.oracle.truffle.dsl.processor.library.ExportsGenerator;
import com.oracle.truffle.dsl.processor.library.ExportsParser;
import com.oracle.truffle.dsl.processor.library.LibraryData;
import com.oracle.truffle.dsl.processor.library.LibraryGenerator;
import com.oracle.truffle.dsl.processor.library.LibraryParser;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.model.TypeSystemData;
import com.oracle.truffle.dsl.processor.parser.AbstractParser;
import com.oracle.truffle.dsl.processor.parser.NodeParser;
import com.oracle.truffle.dsl.processor.parser.TypeSystemParser;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public class TruffleProcessor
extends AbstractProcessor
implements ProcessorContext.ProcessCallback {
    private List<AnnotationProcessor<?>> generators;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            this.processImpl(roundEnv);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processImpl(RoundEnvironment env) {
        try {
            ProcessorContext.setThreadLocalInstance(new ProcessorContext(this.processingEnv, this));
            for (AnnotationProcessor<?> generator : this.getGenerators()) {
                AbstractParser<?> parser = generator.getParser();
                if (parser.getAnnotationType() != null) {
                    for (Element element : env.getElementsAnnotatedWith(parser.getAnnotationType())) {
                        TruffleProcessor.processElement(generator, element, false);
                    }
                    Class<Annotation> repeat = parser.getRepeatAnnotationType();
                    if (repeat != null) {
                        for (Element e2 : env.getElementsAnnotatedWith(repeat)) {
                            TruffleProcessor.processElement(generator, e2, false);
                        }
                    }
                }
                for (Class clazz : parser.getTypeDelegatedAnnotationTypes()) {
                    for (Element element : env.getElementsAnnotatedWith(clazz)) {
                        Optional<TypeElement> processedType = parser.isDelegateToRootDeclaredType() ? ElementUtils.findRootEnclosingType(element) : ElementUtils.findParentEnclosingType(element);
                        TruffleProcessor.processElement(generator, processedType.orElseThrow(AssertionError::new), false);
                    }
                }
            }
        }
        finally {
            ProcessorContext.setThreadLocalInstance(null);
        }
    }

    private static void processElement(AnnotationProcessor<?> generator, Element e, boolean callback) {
        try {
            generator.process(e, callback);
        }
        catch (Throwable e1) {
            TruffleProcessor.handleThrowable(generator, e1, e);
        }
    }

    private static void handleThrowable(AnnotationProcessor<?> generator, Throwable t, Element e) {
        String message = "Uncaught error in " + generator.getClass().getSimpleName() + " while processing " + e + " ";
        ProcessorContext.getInstance().getEnvironment().getMessager().printMessage(Diagnostic.Kind.ERROR, message + ": " + ElementUtils.printException(t), e);
    }

    @Override
    public void callback(TypeElement template) {
        for (AnnotationProcessor<?> generator : this.generators) {
            Annotation annotation;
            Class<Annotation> annotationType = generator.getParser().getAnnotationType();
            if (annotationType == null || (annotation = template.getAnnotation(annotationType)) == null) continue;
            TruffleProcessor.processElement(generator, template, true);
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> annotations = new HashSet<String>();
        TruffleProcessor.addAnnotations(annotations, Arrays.asList(Fallback.class, TypeSystemReference.class, Specialization.class, Executed.class, NodeChild.class, NodeChildren.class));
        TruffleProcessor.addAnnotations(annotations, Arrays.asList(TypeSystem.class));
        TruffleProcessor.addAnnotations(annotations, Arrays.asList(GenerateLibrary.class));
        TruffleProcessor.addAnnotations(annotations, Arrays.asList(ExportLibrary.class, ExportMessage.class, ExportLibrary.Repeat.class));
        return annotations;
    }

    private static void addAnnotations(Set<String> annotations, List<? extends Class<? extends Annotation>> annotationClasses) {
        if (annotationClasses != null) {
            for (Class<? extends Annotation> clazz : annotationClasses) {
                annotations.add(clazz.getCanonicalName());
            }
        }
    }

    private List<AnnotationProcessor<?>> getGenerators() {
        if (this.generators == null && this.processingEnv != null) {
            this.generators = new ArrayList();
            this.generators.add(new AnnotationProcessor<TypeSystemData>(new TypeSystemParser(), new TypeSystemCodeGenerator()));
            this.generators.add(new AnnotationProcessor<NodeData>(NodeParser.createDefaultParser(), new NodeCodeGenerator()));
            this.generators.add(new AnnotationProcessor<LibraryData>(new LibraryParser(), new LibraryGenerator()));
            this.generators.add(new AnnotationProcessor<ExportsData>(new ExportsParser(), new ExportsGenerator(new LinkedHashMap<String, CodeVariableElement>())));
        }
        return this.generators;
    }

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        this.processingEnv = env;
        super.init(env);
    }
}

