/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public final class TruffleTypes {
    public static final String EXPECT_ERROR_CLASS_NAME1 = "com.oracle.truffle.api.dsl.test.ExpectError";
    public static final String EXPECT_ERROR_CLASS_NAME2 = "com.oracle.truffle.api.test.ExpectError";
    private final DeclaredType node;
    private final ArrayType nodeArray;
    private final TypeMirror unexpectedValueException;
    private final TypeMirror frame;
    private final TypeMirror assumption;
    private final TypeMirror invalidAssumption;
    private final DeclaredType childAnnotation;
    private final DeclaredType childrenAnnotation;
    private final DeclaredType nodeInfoAnnotation;
    private final DeclaredType nodeCost;
    private final TypeMirror compilerDirectives;
    private final TypeMirror compilerAsserts;
    private final DeclaredType truffleBoundary;
    private final DeclaredType sourceSection;
    private final DeclaredType truffleOptions;
    private final DeclaredType compilationFinal;
    private final DeclaredType nodeUtil;
    private final DeclaredType nodeFactory;
    private final DeclaredType generateNodeFactory;
    private final List<String> errors = new ArrayList<String>();

    TruffleTypes(ProcessorContext context) {
        this.node = this.getRequired(context, Node.class);
        this.nodeArray = context.getEnvironment().getTypeUtils().getArrayType(this.node);
        this.unexpectedValueException = this.getRequired(context, UnexpectedResultException.class);
        this.frame = this.getRequired(context, VirtualFrame.class);
        this.childAnnotation = this.getRequired(context, Node.Child.class);
        this.childrenAnnotation = this.getRequired(context, Node.Children.class);
        this.compilerDirectives = this.getRequired(context, CompilerDirectives.class);
        this.compilerAsserts = this.getRequired(context, CompilerAsserts.class);
        this.assumption = this.getRequired(context, Assumption.class);
        this.invalidAssumption = this.getRequired(context, InvalidAssumptionException.class);
        this.nodeInfoAnnotation = this.getRequired(context, NodeInfo.class);
        this.nodeCost = this.getRequired(context, NodeCost.class);
        this.truffleBoundary = this.getRequired(context, CompilerDirectives.TruffleBoundary.class);
        this.sourceSection = this.getRequired(context, SourceSection.class);
        this.truffleOptions = this.getRequired(context, TruffleOptions.class);
        this.compilationFinal = this.getRequired(context, CompilerDirectives.CompilationFinal.class);
        this.nodeUtil = this.getRequired(context, NodeUtil.class);
        this.nodeFactory = this.getRequired(context, NodeFactory.class);
        this.generateNodeFactory = this.getRequired(context, GenerateNodeFactory.class);
    }

    public DeclaredType getGenerateNodeFactory() {
        return this.generateNodeFactory;
    }

    public DeclaredType getNodeFactory() {
        return this.nodeFactory;
    }

    public DeclaredType getCompilationFinal() {
        return this.compilationFinal;
    }

    public DeclaredType getNodeInfoAnnotation() {
        return this.nodeInfoAnnotation;
    }

    public boolean verify(ProcessorContext context, Element element, AnnotationMirror mirror) {
        if (this.errors.isEmpty()) {
            return true;
        }
        for (String error : this.errors) {
            context.getLog().message(Diagnostic.Kind.ERROR, element, mirror, null, error, new Object[0]);
        }
        return false;
    }

    public DeclaredType getNodeCost() {
        return this.nodeCost;
    }

    private DeclaredType getRequired(ProcessorContext context, Class<?> clazz) {
        TypeMirror type = context.getType(clazz);
        if (type == null) {
            this.errors.add(String.format("Could not find required type: %s", clazz.getSimpleName()));
        }
        return (DeclaredType)type;
    }

    public TypeMirror getInvalidAssumption() {
        return this.invalidAssumption;
    }

    public TypeMirror getAssumption() {
        return this.assumption;
    }

    public TypeMirror getCompilerDirectives() {
        return this.compilerDirectives;
    }

    public DeclaredType getNode() {
        return this.node;
    }

    public ArrayType getNodeArray() {
        return this.nodeArray;
    }

    public TypeMirror getFrame() {
        return this.frame;
    }

    public TypeMirror getUnexpectedValueException() {
        return this.unexpectedValueException;
    }

    public DeclaredType getChildAnnotation() {
        return this.childAnnotation;
    }

    public DeclaredType getChildrenAnnotation() {
        return this.childrenAnnotation;
    }

    public TypeMirror getCompilerAsserts() {
        return this.compilerAsserts;
    }

    public DeclaredType getTruffleOptions() {
        return this.truffleOptions;
    }

    public DeclaredType getTruffleBoundary() {
        return this.truffleBoundary;
    }

    public DeclaredType getSourceSection() {
        return this.sourceSection;
    }

    public DeclaredType getNodeUtil() {
        return this.nodeUtil;
    }
}

