/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.generator;

import com.oracle.truffle.dsl.processor.expression.DSLExpression;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;

public class DSLExpressionGenerator
implements DSLExpression.DSLExpressionVisitor {
    private final Map<DSLExpression.Variable, CodeTree> bindings;
    private final CodeTree root;
    private final Deque<CodeTree> stack = new ArrayDeque<CodeTree>();

    DSLExpressionGenerator(CodeTree root, Map<DSLExpression.Variable, CodeTree> bindings) {
        this.bindings = bindings;
        this.root = root;
    }

    @Override
    public void visitClassLiteral(DSLExpression.ClassLiteral classLiteral) {
        this.push(CodeTreeBuilder.createBuilder().typeLiteral(classLiteral.getLiteral()).build());
    }

    @Override
    public void visitBinary(DSLExpression.Binary binary) {
        CodeTree right = this.stack.pop();
        CodeTree left = this.stack.pop();
        this.stack.push(DSLExpressionGenerator.combine(left, DSLExpressionGenerator.string(" " + binary.getOperator() + " "), right));
    }

    @Override
    public void visitCall(DSLExpression.Call call) {
        ExecutableElement method = call.getResolvedMethod();
        CodeTree[] parameters = new CodeTree[method.getParameters().size()];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[parameters.length - i - 1] = this.pop();
        }
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        if (call.getResolvedMethod().getKind() == ElementKind.CONSTRUCTOR) {
            builder.startNew(call.getResolvedType());
        } else if (call.getReceiver() == null) {
            if (DSLExpressionGenerator.isStatic(method)) {
                builder.startStaticCall(method);
            } else {
                if (this.root != null) {
                    builder.tree(this.root).string(".");
                }
                builder.startCall(method.getSimpleName().toString());
            }
        } else {
            if (DSLExpressionGenerator.isStatic(method)) {
                throw new AssertionError((Object)"Static calls must not have receivers.");
            }
            builder.startCall(this.pop(), method.getSimpleName().toString());
        }
        for (CodeTree parameter : parameters) {
            builder.tree(parameter);
        }
        builder.end();
        this.push(builder.build());
    }

    @Override
    public void visitIntLiteral(DSLExpression.IntLiteral binary) {
        this.push(DSLExpressionGenerator.string(binary.getLiteral()));
    }

    @Override
    public void visitBooleanLiteral(DSLExpression.BooleanLiteral binary) {
        this.push(DSLExpressionGenerator.string(binary.getLiteral() ? "true" : "false"));
    }

    @Override
    public void visitNegate(DSLExpression.Negate negate) {
        this.push(DSLExpressionGenerator.combine(DSLExpressionGenerator.string("!"), DSLExpressionGenerator.combine(DSLExpressionGenerator.string("("), this.pop(), DSLExpressionGenerator.string(")"))));
    }

    @Override
    public void visitVariable(DSLExpression.Variable variable) {
        CodeTree tree;
        VariableElement resolvedVariable = variable.getResolvedVariable();
        if (variable.getResolvedType().getKind() == TypeKind.NULL) {
            tree = CodeTreeBuilder.singleString("null");
        } else if (variable.getReceiver() == null) {
            if (DSLExpressionGenerator.isStatic(resolvedVariable)) {
                tree = DSLExpressionGenerator.staticReference(resolvedVariable);
            } else {
                tree = this.bindings.get(variable);
                boolean bound = true;
                if (tree == null) {
                    tree = DSLExpressionGenerator.string(resolvedVariable.getSimpleName().toString());
                    bound = false;
                }
                if (this.root != null && !bound) {
                    tree = DSLExpressionGenerator.combine(this.root, DSLExpressionGenerator.string("."), tree);
                }
            }
        } else {
            if (DSLExpressionGenerator.isStatic(resolvedVariable)) {
                throw new AssertionError((Object)"Static variables cannot have receivers.");
            }
            tree = DSLExpressionGenerator.combine(this.pop(), DSLExpressionGenerator.string("."), DSLExpressionGenerator.string(resolvedVariable.getSimpleName().toString()));
        }
        this.push(tree);
    }

    private static boolean isStatic(Element element) {
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }

    private static CodeTree combine(CodeTree tree1, CodeTree tree2) {
        return new CodeTreeBuilder(null).startGroup().tree(tree1).tree(tree2).end().build();
    }

    private static CodeTree combine(CodeTree tree1, CodeTree tree2, CodeTree tree3) {
        return new CodeTreeBuilder(null).startGroup().tree(tree1).tree(tree2).tree(tree3).end().build();
    }

    private static CodeTree string(String s) {
        return CodeTreeBuilder.singleString(s);
    }

    private static CodeTree staticReference(VariableElement var) {
        Element enclosing = var.getEnclosingElement();
        if (enclosing == null) {
            return CodeTreeBuilder.singleString(var.getSimpleName().toString());
        }
        return CodeTreeBuilder.createBuilder().staticReference(enclosing.asType(), var.getSimpleName().toString()).build();
    }

    private void push(CodeTree tree) {
        this.stack.push(tree);
    }

    private CodeTree pop() {
        return this.stack.pop();
    }

    public static CodeTree write(DSLExpression expression, CodeTree root, Map<DSLExpression.Variable, CodeTree> bindings) {
        DSLExpressionGenerator writer = new DSLExpressionGenerator(root, bindings);
        expression.accept(writer);
        return DSLExpressionGenerator.combine(DSLExpressionGenerator.string("("), writer.pop(), DSLExpressionGenerator.string(")"));
    }
}

