/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.interop;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.MessageResolution;
import com.oracle.truffle.api.interop.Resolve;
import com.oracle.truffle.dsl.processor.interop.ForeignAccessFactoryGenerator;
import com.oracle.truffle.dsl.processor.interop.MessageGenerator;
import com.oracle.truffle.dsl.processor.interop.Utils;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

final class ExecuteGenerator
extends MessageGenerator {
    private final int numberOfArguments;
    private final String targetableExecuteNode;

    ExecuteGenerator(ProcessingEnvironment processingEnv, Resolve resolveAnnotation, MessageResolution messageResolutionAnnotation, TypeElement element, ForeignAccessFactoryGenerator containingForeignAccessFactory) {
        super(processingEnv, resolveAnnotation, messageResolutionAnnotation, element, containingForeignAccessFactory);
        this.targetableExecuteNode = new StringBuilder(this.messageName).replace(0, 1, this.messageName.substring(0, 1).toUpperCase()).append("Node").insert(0, "Targetable").toString();
        if (Message.EXECUTE.toString().equalsIgnoreCase(this.messageName)) {
            this.numberOfArguments = 2;
        } else if (Message.INVOKE.toString().equalsIgnoreCase(this.messageName)) {
            this.numberOfArguments = 3;
        } else if (Message.NEW.toString().equalsIgnoreCase(this.messageName)) {
            this.numberOfArguments = 2;
        } else {
            throw new AssertionError();
        }
    }

    @Override
    int getParameterCount() {
        return this.numberOfArguments;
    }

    @Override
    String getTargetableNodeName() {
        return this.targetableExecuteNode;
    }

    @Override
    void appendRootNode(Writer w) throws IOException {
        w.append(this.indent).append("    private static final class ").append(this.rootNodeName).append(" extends RootNode {\n");
        w.append(this.indent).append("        protected ").append(this.rootNodeName).append("() {\n");
        w.append(this.indent).append("            super(null);\n");
        w.append(this.indent).append("        }\n");
        w.append("\n");
        w.append(this.indent).append("        @Child private ").append(this.clazzName).append(" node = ").append(this.getGeneratedDSLNodeQualifiedName()).append(".create();");
        w.append("\n");
        this.appendGetName(w);
        w.append(this.indent).append("        @Override\n");
        w.append(this.indent).append("        public Object execute(VirtualFrame frame) {\n");
        w.append(this.indent).append("            Object receiver = com.oracle.truffle.api.interop.ForeignAccess.getReceiver(frame);\n");
        w.append(this.indent).append("            Object[] arguments = frame.getArguments();\n");
        boolean isInvoke = Message.INVOKE.toString().equalsIgnoreCase(this.messageName);
        if (isInvoke) {
            w.append(this.indent).append("            Object identifier = arguments[1];\n");
            w.append(this.indent).append("            Object[] args = new Object[arguments.length - 2];\n");
            w.append(this.indent).append("            for (int i = 0; i < arguments.length - 2; i++) {\n");
            w.append(this.indent).append("                args[i] = arguments[i + 2];\n");
            w.append(this.indent).append("            }\n");
        } else {
            w.append(this.indent).append("            Object[] args = new Object[arguments.length - 1];\n");
            w.append(this.indent).append("            for (int i = 0; i < arguments.length - 1; i++) {\n");
            w.append(this.indent).append("                args[i] = arguments[i + 1];\n");
            w.append(this.indent).append("            }\n");
        }
        w.append(this.indent).append("            try {\n");
        if (isInvoke) {
            w.append(this.indent).append("                return node.executeWithTarget(frame, receiver, identifier, args);\n");
        } else {
            w.append(this.indent).append("                return node.executeWithTarget(frame, receiver, args);\n");
        }
        w.append(this.indent).append("            } catch (UnsupportedSpecializationException e) {\n");
        this.appendHandleUnsupportedTypeException(w);
        w.append(this.indent).append("            }\n");
        w.append(this.indent).append("        }\n");
        w.append(this.indent).append("    }\n");
        w.append("\n");
    }

    @Override
    public String checkSignature(ExecutableElement method) {
        int expectedNumberOfArguments;
        List<? extends VariableElement> params = method.getParameters();
        boolean hasFrameArgument = false;
        if (params.size() >= 1) {
            hasFrameArgument = ElementUtils.typeEquals(params.get(0).asType(), Utils.getTypeMirror(this.processingEnv, VirtualFrame.class));
        }
        int n = expectedNumberOfArguments = hasFrameArgument ? this.getParameterCount() + 1 : this.getParameterCount();
        if (params.size() != expectedNumberOfArguments) {
            if (Message.INVOKE.toString().equalsIgnoreCase(this.messageName)) {
                return "Wrong number of arguments. Expected signature: ([frame: VirtualFrame], receiverObject: TruffleObject, identifier: String, arguments: Object[])";
            }
            if (Message.EXECUTE.toString().equalsIgnoreCase(this.messageName)) {
                return "Wrong number of arguments. Expected signature: ([frame: VirtualFrame], receiverObject: TruffleObject, arguments: Object[])";
            }
            throw new IllegalStateException();
        }
        if (Message.INVOKE.toString().equalsIgnoreCase(this.messageName) && !ElementUtils.typeEquals(params.get(hasFrameArgument ? 2 : 1).asType(), Utils.getTypeMirror(this.processingEnv, String.class))) {
            int i = hasFrameArgument ? 3 : 2;
            return "The " + i + " argument must be a " + String.class.getName() + "- but is " + ElementUtils.getQualifiedName(params.get(hasFrameArgument ? 2 : 1).asType());
        }
        VariableElement variableElement = params.get(params.size() - 1);
        if (!Utils.isObjectArray(variableElement.asType())) {
            return "The last argument must be the arguments array. Required type: java.lang.Object[]";
        }
        return super.checkSignature(method);
    }
}

