/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.interop;

import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.MessageResolution;
import com.oracle.truffle.dsl.processor.interop.InteropDSLProcessor;
import com.oracle.truffle.dsl.processor.interop.LanguageCheckGenerator;
import com.oracle.truffle.dsl.processor.interop.MessageGenerator;
import com.oracle.truffle.dsl.processor.interop.Utils;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

final class ForeignAccessFactoryGenerator {
    private final String receiverTypeClass;
    private final String packageName;
    private final String simpleClassName;
    private final ProcessingEnvironment processingEnv;
    protected final TypeElement element;
    private final SortedSet<String> imports;
    private final Map<Object, MessageGenerator> messageGenerators;
    private LanguageCheckGenerator languageCheckGenerator;

    ForeignAccessFactoryGenerator(ProcessingEnvironment processingEnv, MessageResolution messageResolutionAnnotation, TypeElement element) {
        this.processingEnv = processingEnv;
        this.element = element;
        this.packageName = ElementUtils.getPackageName(element);
        this.simpleClassName = ElementUtils.getSimpleName(element) + "Foreign";
        this.receiverTypeClass = Utils.getReceiverTypeFullClassName(messageResolutionAnnotation);
        this.imports = new TreeSet<String>();
        this.messageGenerators = new HashMap<Object, MessageGenerator>();
        this.languageCheckGenerator = null;
    }

    public void addMessageHandler(Object message, MessageGenerator messageGenerator) {
        this.messageGenerators.put(message, messageGenerator);
    }

    public void addLanguageCheckHandler(LanguageCheckGenerator generator) {
        this.languageCheckGenerator = generator;
    }

    public String getSimpleClassName() {
        return this.simpleClassName;
    }

    public String getFullClassName() {
        return this.packageName + "." + this.simpleClassName;
    }

    public void generate() throws IOException {
        JavaFileObject factoryFile = this.processingEnv.getFiler().createSourceFile(this.packageName + "." + this.simpleClassName, this.element);
        Writer w = factoryFile.openWriter();
        w.append("package ").append(this.packageName).append(";\n\n");
        this.appendImports(w);
        Utils.appendFactoryGeneratedFor(w, "", this.receiverTypeClass, ElementUtils.getQualifiedName(this.element));
        Utils.suppressDeprecationWarnings(w, "");
        Utils.appendVisibilityModifier(w, this.element);
        w.append("final class ").append(this.simpleClassName);
        w.append(" implements com.oracle.truffle.api.interop.ForeignAccess.StandardFactory, com.oracle.truffle.api.interop.ForeignAccess.Factory {\n");
        this.appendSingletonAndGetter(w);
        this.appendPrivateConstructor(w);
        this.appendFactoryCanHandle(w);
        this.appendFactoryAccessIsNull(w);
        this.appendFactoryAccessIsExecutable(w);
        this.appendFactoryAccessIsInstantiable(w);
        this.appendFactoryAccessIsBoxed(w);
        this.appendFactoryAccessHasKeys(w);
        this.appendFactoryAccessHasSize(w);
        this.appendFactoryAccessGetSize(w);
        this.appendFactoryAccessUnbox(w);
        this.appendFactoryAccessRead(w);
        this.appendFactoryAccessWrite(w);
        this.appendFactoryAccessRemove(w);
        this.appendFactoryAccessExecute(w);
        this.appendFactoryAccessInvoke(w);
        this.appendFactoryAccessNew(w);
        this.appendFactoryAccessKeyInfo(w);
        this.appendFactoryAccessKeys(w);
        this.appendFactoryAccessIsPointer(w);
        this.appendFactoryAccessAsPointer(w);
        this.appendFactoryAccessToNative(w);
        this.appendFactoryAccessMessage(w);
        for (MessageGenerator generator : this.messageGenerators.values()) {
            generator.appendNode(w);
        }
        if (this.languageCheckGenerator != null) {
            this.languageCheckGenerator.appendNode(w);
        }
        w.append("}\n");
        w.close();
    }

    private boolean hasLanguageCheckNode() {
        return this.languageCheckGenerator != null;
    }

    private void collectImports() {
        this.imports.add("com.oracle.truffle.api.CallTarget");
        if (this.hasLanguageCheckNode()) {
            this.imports.add("com.oracle.truffle.api.CompilerDirectives.TruffleBoundary");
            this.imports.add("java.util.function.Supplier");
        }
        this.imports.add("com.oracle.truffle.api.Truffle");
        this.imports.add("com.oracle.truffle.api.interop.TruffleObject");
        if (!(this.messageGenerators.containsKey(Message.IS_BOXED) && this.messageGenerators.containsKey(Message.IS_NULL) && this.messageGenerators.containsKey(Message.IS_EXECUTABLE) && this.messageGenerators.containsKey(Message.IS_INSTANTIABLE) && this.messageGenerators.containsKey(Message.KEY_INFO) && this.messageGenerators.containsKey(Message.HAS_KEYS) && this.messageGenerators.containsKey(Message.HAS_SIZE) && this.messageGenerators.containsKey(Message.IS_POINTER))) {
            this.imports.add("com.oracle.truffle.api.nodes.RootNode");
        }
        this.imports.add("com.oracle.truffle.api.dsl.GeneratedBy");
        for (MessageGenerator generator : this.messageGenerators.values()) {
            generator.addImports(this.imports);
        }
        if (this.languageCheckGenerator != null) {
            this.languageCheckGenerator.addImports(this.imports);
        }
    }

    private void appendImports(Writer w) throws IOException {
        this.collectImports();
        for (String importedClassName : this.imports) {
            w.append("import ").append(importedClassName).append(";\n");
        }
    }

    private void appendSingletonAndGetter(Writer w) throws IOException {
        String allocation = "com.oracle.truffle.api.interop.ForeignAccess.createAccess(new " + this.simpleClassName + "(), ";
        allocation = this.hasLanguageCheckNode() ? allocation + "new Supplier<RootNode>() { @Override public RootNode get() { return " + this.languageCheckGenerator.getRootNodeFactoryInvocation() + "; }});" : allocation + "null);";
        w.append("    public static final com.oracle.truffle.api.interop.ForeignAccess ACCESS = ").append(allocation).append("\n");
        w.append("    @Deprecated public static com.oracle.truffle.api.interop.ForeignAccess createAccess() { return ").append(allocation).append(" }\n");
        w.append("\n");
    }

    private void appendPrivateConstructor(Writer w) throws IOException {
        w.append("    private ").append(this.simpleClassName).append("() { }").append("\n");
        w.append("\n");
    }

    private void appendFactoryCanHandle(Writer w) throws IOException {
        w.append("    @Override").append("\n");
        if (this.hasLanguageCheckNode()) {
            w.append("    @TruffleBoundary").append("\n");
        }
        w.append("    public boolean canHandle(TruffleObject obj) {").append("\n");
        if (this.hasLanguageCheckNode()) {
            w.append("        return (boolean) Truffle.getRuntime().createCallTarget(").append(this.languageCheckGenerator.getRootNodeFactoryInvocation()).append(").call(obj);\n");
        } else {
            w.append("        return ").append(this.receiverTypeClass).append(".isInstance(obj);").append("\n");
        }
        w.append("    }").append("\n");
        w.append("\n");
    }

    private void appendFactoryAccessIsNull(Writer w) throws IOException {
        w.append("    @Override").append("\n");
        w.append("    public CallTarget accessIsNull() {").append("\n");
        this.appendOptionalDefaultHandlerBody(w, Message.IS_NULL);
        w.append("    }").append("\n");
    }

    private void appendFactoryAccessIsExecutable(Writer w) throws IOException {
        w.append("    @Override").append("\n");
        w.append("    public CallTarget accessIsExecutable() {").append("\n");
        this.appendOptionalDefaultHandlerBody(w, Message.IS_EXECUTABLE, Message.EXECUTE);
        w.append("    }").append("\n");
    }

    private void appendFactoryAccessIsInstantiable(Writer w) throws IOException {
        w.append("    @Override").append("\n");
        w.append("    public CallTarget accessIsInstantiable() {").append("\n");
        this.appendOptionalDefaultHandlerBody(w, Message.IS_INSTANTIABLE, Message.NEW);
        w.append("    }").append("\n");
    }

    private void appendFactoryAccessIsBoxed(Writer w) throws IOException {
        w.append("    @Override").append("\n");
        w.append("    public CallTarget accessIsBoxed() {").append("\n");
        this.appendOptionalDefaultHandlerBody(w, Message.IS_BOXED, Message.UNBOX);
        w.append("    }").append("\n");
    }

    private void appendFactoryAccessHasKeys(Writer w) throws IOException {
        w.append("    @Override").append("\n");
        w.append("    public CallTarget accessHasKeys() {").append("\n");
        this.appendOptionalDefaultHandlerBody(w, Message.HAS_KEYS, Message.KEYS);
        w.append("    }").append("\n");
    }

    private void appendFactoryAccessHasSize(Writer w) throws IOException {
        w.append("    @Override").append("\n");
        w.append("    public CallTarget accessHasSize() {").append("\n");
        this.appendOptionalDefaultHandlerBody(w, Message.HAS_SIZE, Message.GET_SIZE);
        w.append("    }").append("\n");
    }

    private void appendOptionalDefaultHandlerBody(Writer w, Message message) throws IOException {
        this.appendOptionalDefaultHandlerBody(w, message, "false");
    }

    private void appendOptionalDefaultHandlerBody(Writer w, Message message, String defaultValue) throws IOException {
        if (!this.messageGenerators.containsKey(message)) {
            w.append("      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(" + defaultValue + "));").append("\n");
        } else {
            w.append("      return Truffle.getRuntime().createCallTarget(").append(this.messageGenerators.get(message).getRootNodeFactoryInvocation()).append(");").append("\n");
        }
    }

    private void appendOptionalDefaultHandlerBody(Writer w, Message message, Message testPresentMessage) throws IOException {
        this.appendOptionalDefaultHandlerBody(w, message, Boolean.toString(this.messageGenerators.containsKey(testPresentMessage)));
    }

    private void appendFactoryAccessGetSize(Writer w) throws IOException {
        w.append("    @Override").append("\n");
        w.append("    public CallTarget accessGetSize() {").append("\n");
        this.appendOptionalHandlerBody(w, Message.GET_SIZE);
        w.append("    }").append("\n");
    }

    private void appendFactoryAccessKeyInfo(Writer w) throws IOException {
        w.append("    @Override").append("\n");
        w.append("    public CallTarget accessKeyInfo() {").append("\n");
        this.appendOptionalHandlerBody(w, Message.KEY_INFO);
        w.append("    }").append("\n");
    }

    private void appendFactoryAccessKeys(Writer w) throws IOException {
        w.append("    @Override").append("\n");
        w.append("    public CallTarget accessKeys() {").append("\n");
        this.appendOptionalHandlerBody(w, Message.KEYS);
        w.append("    }").append("\n");
    }

    private void appendFactoryAccessIsPointer(Writer w) throws IOException {
        w.append("    @Override").append("\n");
        w.append("    public CallTarget accessIsPointer() {").append("\n");
        this.appendOptionalDefaultHandlerBody(w, Message.IS_POINTER, Message.AS_POINTER);
        w.append("    }").append("\n");
    }

    private void appendFactoryAccessAsPointer(Writer w) throws IOException {
        w.append("    @Override").append("\n");
        w.append("    public CallTarget accessAsPointer() {").append("\n");
        this.appendOptionalHandlerBody(w, Message.AS_POINTER);
        w.append("    }").append("\n");
    }

    private void appendFactoryAccessToNative(Writer w) throws IOException {
        w.append("    @Override").append("\n");
        w.append("    public CallTarget accessToNative() {").append("\n");
        this.appendOptionalHandlerBody(w, Message.TO_NATIVE);
        w.append("    }").append("\n");
    }

    private void appendFactoryAccessUnbox(Writer w) throws IOException {
        w.append("    @Override").append("\n");
        w.append("    public CallTarget accessUnbox() {").append("\n");
        this.appendOptionalHandlerBody(w, Message.UNBOX);
        w.append("    }").append("\n");
    }

    private void appendFactoryAccessRead(Writer w) throws IOException {
        w.append("    @Override").append("\n");
        w.append("    public CallTarget accessRead() {").append("\n");
        this.appendOptionalHandlerBody(w, Message.READ);
        w.append("    }").append("\n");
    }

    private void appendFactoryAccessWrite(Writer w) throws IOException {
        w.append("    @Override").append("\n");
        w.append("    public CallTarget accessWrite() {").append("\n");
        this.appendOptionalHandlerBody(w, Message.WRITE);
        w.append("    }").append("\n");
    }

    private void appendFactoryAccessRemove(Writer w) throws IOException {
        w.append("    @Override").append("\n");
        w.append("    public CallTarget accessRemove() {").append("\n");
        this.appendOptionalHandlerBody(w, Message.REMOVE);
        w.append("    }").append("\n");
    }

    private void appendFactoryAccessExecute(Writer w) throws IOException {
        w.append("    @Override").append("\n");
        w.append("    public CallTarget accessExecute(int argumentsLength) {").append("\n");
        this.appendOptionalHandlerBody(w, Message.EXECUTE);
        w.append("    }").append("\n");
    }

    private void appendFactoryAccessInvoke(Writer w) throws IOException {
        w.append("    @Override").append("\n");
        w.append("    public CallTarget accessInvoke(int argumentsLength) {").append("\n");
        this.appendOptionalHandlerBody(w, Message.INVOKE);
        w.append("    }").append("\n");
    }

    private void appendFactoryAccessNew(Writer w) throws IOException {
        w.append("    @Override").append("\n");
        w.append("    public CallTarget accessNew(int argumentsLength) {").append("\n");
        this.appendOptionalHandlerBody(w, Message.NEW);
        w.append("    }").append("\n");
    }

    private void appendOptionalHandlerBody(Writer w, Message message) throws IOException {
        if (!this.messageGenerators.containsKey(message)) {
            w.append("      return null;\n");
        } else {
            w.append("      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(").append(this.messageGenerators.get(message).getRootNodeFactoryInvocation()).append(");").append("\n");
        }
    }

    private void appendFactoryAccessMessage(Writer w) throws IOException {
        w.append("    @Override").append("\n");
        w.append("    public CallTarget accessMessage(com.oracle.truffle.api.interop.Message unknown) {").append("\n");
        for (Object m : this.messageGenerators.keySet()) {
            if (InteropDSLProcessor.getKnownMessages().contains(m)) continue;
            String msg = m instanceof Message ? Message.toString((Message)((Message)m)) : (String)m;
            w.append("      if (unknown != null && unknown.getClass().getCanonicalName().equals(\"").append(msg).append("\")) {").append("\n");
            w.append("        return Truffle.getRuntime().createCallTarget(").append(this.messageGenerators.get(m).getRootNodeFactoryInvocation()).append(");").append("\n");
            w.append("      }").append("\n");
        }
        w.append("      return null;\n");
        w.append("    }").append("\n");
    }

    public String toString() {
        return "FactoryGenerator: " + this.simpleClassName;
    }
}

