/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.interop;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.CanResolve;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.MessageResolution;
import com.oracle.truffle.api.interop.Resolve;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.dsl.processor.ExpectError;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.interop.ForeignAccessFactoryGenerator;
import com.oracle.truffle.dsl.processor.interop.LanguageCheckGenerator;
import com.oracle.truffle.dsl.processor.interop.MessageGenerator;
import com.oracle.truffle.dsl.processor.interop.Utils;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.tools.Diagnostic;

public final class InteropDSLProcessor
extends AbstractProcessor {
    static List<Message> getKnownMessages() {
        return Arrays.asList(Message.READ, Message.WRITE, Message.REMOVE, Message.IS_NULL, Message.IS_EXECUTABLE, Message.IS_INSTANTIABLE, Message.IS_BOXED, Message.UNBOX, Message.HAS_SIZE, Message.GET_SIZE, Message.KEY_INFO, Message.HAS_KEYS, Message.KEYS, Message.IS_POINTER, Message.AS_POINTER, Message.TO_NATIVE, Message.EXECUTE, Message.INVOKE, Message.NEW);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> annotations = new HashSet<String>();
        annotations.add("com.oracle.truffle.api.interop.MessageResolution");
        return annotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        this.process0(roundEnv);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process0(RoundEnvironment roundEnv) {
        try {
            ProcessorContext.setThreadLocalInstance(new ProcessorContext(this.processingEnv, null));
            for (Element element : roundEnv.getElementsAnnotatedWith(MessageResolution.class)) {
                try {
                    this.processElement(element);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    String message = "Uncaught error in " + this.getClass();
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message + ": " + ElementUtils.printException(ex), element);
                }
            }
        }
        finally {
            ProcessorContext.setThreadLocalInstance(null);
        }
    }

    private void processElement(Element e) throws IOException {
        int n;
        int n2;
        if (e.getKind() != ElementKind.CLASS) {
            return;
        }
        MessageResolution messageImplementations = e.getAnnotation(MessageResolution.class);
        if (messageImplementations == null) {
            return;
        }
        String receiverTypeFullClassName = Utils.getReceiverTypeFullClassName(messageImplementations);
        if (InteropDSLProcessor.isReceiverNonStaticInner(messageImplementations)) {
            this.emitError(receiverTypeFullClassName + " cannot be used as a receiver as it is not a static inner class.", e);
            return;
        }
        if (e.getModifiers().contains((Object)Modifier.PRIVATE) || e.getModifiers().contains((Object)Modifier.PROTECTED)) {
            this.emitError("Class must be public or package protected", e);
            return;
        }
        Element curr = e;
        ArrayList<TypeElement> receiverChecks = new ArrayList<TypeElement>();
        for (Element element : curr.getEnclosedElements()) {
            if (element.getKind() != ElementKind.CLASS || element.getAnnotation(CanResolve.class) == null) continue;
            receiverChecks.add((TypeElement)element);
        }
        if (receiverChecks.size() == 0 && this.isInstanceMissing(receiverTypeFullClassName)) {
            this.emitError("Missing isInstance method in class " + receiverTypeFullClassName, e);
            return;
        }
        if (receiverChecks.size() == 0 && this.isInstanceHasWrongSignature(receiverTypeFullClassName)) {
            this.emitError("Method isInstance in class " + receiverTypeFullClassName + " has an invalid signature: expected signature (object: TruffleObject).", e);
            return;
        }
        if (receiverChecks.size() > 1) {
            this.emitError("Only one @LanguageCheck element allowed", e);
            return;
        }
        curr = e;
        ArrayList<TypeElement> elements = new ArrayList<TypeElement>();
        for (Element element : curr.getEnclosedElements()) {
            if (element.getKind() != ElementKind.CLASS || element.getAnnotation(Resolve.class) == null) continue;
            elements.add((TypeElement)element);
        }
        ForeignAccessFactoryGenerator foreignAccessFactoryGenerator = new ForeignAccessFactoryGenerator(this.processingEnv, messageImplementations, (TypeElement)e);
        boolean bl = true;
        for (TypeElement elem : elements) {
            n2 &= this.processResolveClass(elem.getAnnotation(Resolve.class), messageImplementations, elem, foreignAccessFactoryGenerator);
        }
        if (n2 == 0) {
            return;
        }
        if (!receiverChecks.isEmpty()) {
            n = n2 & this.processLanguageCheck(messageImplementations, (TypeElement)receiverChecks.get(0), foreignAccessFactoryGenerator);
        }
        if (n == 0) {
            return;
        }
        try {
            foreignAccessFactoryGenerator.generate();
        }
        catch (FilerException ex) {
            this.emitError("Foreign factory class with same name already exists", e);
            return;
        }
    }

    private boolean processLanguageCheck(MessageResolution messageResolutionAnnotation, TypeElement element, ForeignAccessFactoryGenerator factoryGenerator) {
        LanguageCheckGenerator generator = new LanguageCheckGenerator(this.processingEnv, messageResolutionAnnotation, element, factoryGenerator);
        if (!ElementUtils.typeEquals(element.getSuperclass(), Utils.getTypeMirror(this.processingEnv, Node.class))) {
            this.emitError(ElementUtils.getQualifiedName(element) + " must extend com.oracle.truffle.api.nodes.Node.", element);
            return false;
        }
        if (!element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.emitError("Class must be abstract", element);
            return false;
        }
        if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
            this.emitError("Class must be static", element);
            return false;
        }
        if (element.getModifiers().contains((Object)Modifier.PRIVATE) || element.getModifiers().contains((Object)Modifier.PROTECTED)) {
            this.emitError("Class must be public or package protected", element);
            return false;
        }
        List<ExecutableElement> methods = generator.getTestMethods();
        if (methods.isEmpty() || methods.size() > 1) {
            this.emitError("There needs to be exactly one test method.", element);
            return false;
        }
        ExecutableElement m = methods.get(0);
        String errorMessage = generator.checkSignature(m);
        if (errorMessage != null) {
            this.emitError(errorMessage, m);
            return false;
        }
        factoryGenerator.addLanguageCheckHandler(generator);
        return true;
    }

    private boolean processResolveClass(Resolve resolveAnnotation, MessageResolution messageResolutionAnnotation, TypeElement element, ForeignAccessFactoryGenerator factoryGenerator) {
        MessageGenerator currentGenerator = MessageGenerator.getGenerator(this.processingEnv, resolveAnnotation, messageResolutionAnnotation, element, factoryGenerator);
        if (currentGenerator == null) {
            this.emitError("Unknown message type: " + resolveAnnotation.message(), element);
            return false;
        }
        if (!ElementUtils.typeEquals(element.getSuperclass(), Utils.getTypeMirror(this.processingEnv, Node.class))) {
            this.emitError(ElementUtils.getQualifiedName(element) + " must extend com.oracle.truffle.api.nodes.Node.", element);
            return false;
        }
        if (!element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.emitError("Class must be abstract", element);
            return false;
        }
        if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
            this.emitError("Class must be static", element);
            return false;
        }
        if (element.getModifiers().contains((Object)Modifier.PRIVATE) || element.getModifiers().contains((Object)Modifier.PROTECTED)) {
            this.emitError("Class must be public or package protected", element);
            return false;
        }
        List<ExecutableElement> methods = currentGenerator.getAccessMethods();
        if (methods.isEmpty()) {
            this.emitError("There needs to be at least one access method.", element);
            return false;
        }
        List<? extends VariableElement> params = methods.get(0).getParameters();
        int argumentSize = params.size();
        if (params.size() > 0 && ElementUtils.typeEquals(params.get(0).asType(), Utils.getTypeMirror(this.processingEnv, VirtualFrame.class))) {
            --argumentSize;
        }
        for (ExecutableElement m : methods) {
            params = m.getParameters();
            int paramsSize = params.size();
            if (params.size() > 0 && ElementUtils.typeEquals(params.get(0).asType(), Utils.getTypeMirror(this.processingEnv, VirtualFrame.class))) {
                --paramsSize;
            }
            if (argumentSize == paramsSize) continue;
            this.emitError("Inconsistent argument length.", element);
            return false;
        }
        for (ExecutableElement m : methods) {
            String errorMessage = currentGenerator.checkSignature(m);
            if (errorMessage == null) continue;
            this.emitError(errorMessage, m);
            return false;
        }
        Object currentMessage = Utils.getMessage(this.processingEnv, resolveAnnotation.message());
        if (currentMessage == null) {
            currentMessage = currentGenerator.getMessageName();
        }
        factoryGenerator.addMessageHandler(currentMessage, currentGenerator);
        return true;
    }

    private static boolean isReceiverNonStaticInner(MessageResolution message) {
        try {
            message.receiverType();
            throw new AssertionError();
        }
        catch (MirroredTypeException mte) {
            DeclaredType type = (DeclaredType)mte.getTypeMirror();
            TypeElement element = (TypeElement)type.asElement();
            if (element.getNestingKind() == NestingKind.MEMBER || element.getNestingKind() == NestingKind.LOCAL) {
                for (Modifier modifier : element.getModifiers()) {
                    if (modifier.compareTo(Modifier.STATIC) != 0) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private boolean isInstanceMissing(String receiverTypeFullClassName) {
        for (Element element : ElementUtils.getTypeElement(this.processingEnv, receiverTypeFullClassName).getEnclosedElements()) {
            ExecutableElement method;
            if (!element.getKind().equals((Object)ElementKind.METHOD) || !(method = (ExecutableElement)element).getSimpleName().toString().equals("isInstance")) continue;
            return false;
        }
        return true;
    }

    private boolean isInstanceHasWrongSignature(String receiverTypeFullClassName) {
        for (Element element : ElementUtils.getTypeElement(this.processingEnv, receiverTypeFullClassName).getEnclosedElements()) {
            ExecutableElement method;
            if (!element.getKind().equals((Object)ElementKind.METHOD) || !(method = (ExecutableElement)element).getSimpleName().toString().equals("isInstance") || method.getParameters().size() != 1 || !ElementUtils.typeEquals(method.getParameters().get(0).asType(), Utils.getTypeMirror(this.processingEnv, TruffleObject.class))) continue;
            return false;
        }
        return true;
    }

    private void emitError(String msg, Element e) {
        if (ExpectError.isExpectedError(this.processingEnv, e, msg)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e);
    }
}

