/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.interop;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.MessageResolution;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.dsl.processor.interop.ForeignAccessFactoryGenerator;
import com.oracle.truffle.dsl.processor.interop.InteropNodeGenerator;
import com.oracle.truffle.dsl.processor.interop.Utils;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;

final class LanguageCheckGenerator
extends InteropNodeGenerator {
    protected static final String TEST_METHOD_NAME = "test";
    protected String receiverClassName;

    LanguageCheckGenerator(ProcessingEnvironment processingEnv, MessageResolution messageResolutionAnnotation, TypeElement element, ForeignAccessFactoryGenerator containingForeignAccessFactory) {
        super(processingEnv, element, containingForeignAccessFactory);
        this.receiverClassName = Utils.getReceiverTypeFullClassName(messageResolutionAnnotation);
    }

    @Override
    public void appendNode(Writer w) throws IOException {
        Utils.appendMessagesGeneratedByInformation(w, this.indent, ElementUtils.getQualifiedName(this.element), this.receiverClassName);
        w.append(this.indent);
        Utils.appendVisibilityModifier(w, this.element);
        w.append("abstract static class ").append(this.clazzName).append(" extends ").append(this.userClassName).append(" {\n");
        this.appendExecuteWithTarget(w);
        this.appendSpecializations(w);
        this.appendRootNode(w);
        this.appendRootNodeFactory(w);
        w.append(this.indent).append("}\n");
    }

    public List<ExecutableElement> getTestMethods() {
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        for (Element element : this.element.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD || !element.getSimpleName().contentEquals(TEST_METHOD_NAME)) continue;
            ExecutableElement method = (ExecutableElement)element;
            methods.add(method);
        }
        return methods;
    }

    public String checkSignature(ExecutableElement method) {
        List<? extends VariableElement> params = method.getParameters();
        boolean hasFrameArgument = false;
        if (params.size() >= 1) {
            hasFrameArgument = ElementUtils.typeEquals(params.get(0).asType(), Utils.getTypeMirror(this.processingEnv, VirtualFrame.class));
        }
        int expectedNumberOfArguments = hasFrameArgument ? 2 : 1;
        if (!ElementUtils.typeEquals(params.get(hasFrameArgument ? 1 : 0).asType(), Utils.getTypeMirror(this.processingEnv, TruffleObject.class))) {
            return "The receiver type must be TruffleObject";
        }
        if (!ElementUtils.isPrimitive(method.getReturnType()) || method.getReturnType().getKind() != TypeKind.BOOLEAN) {
            return "Method must return a boolean value";
        }
        if (params.size() != expectedNumberOfArguments) {
            return "Wrong number of arguments.";
        }
        if (method.getThrownTypes().size() > 0) {
            return "Method test must not throw a checked exception.";
        }
        return null;
    }

    void appendExecuteWithTarget(Writer w) throws IOException {
        w.append(this.indent).append("    public abstract Object executeWithTarget(VirtualFrame frame, ").append("Object ").append("o").append(");\n");
    }

    void appendSpecializations(Writer w) throws IOException {
        String sep = "";
        List<ExecutableElement> testMethods = this.getTestMethods();
        assert (testMethods.size() == 1);
        List<? extends VariableElement> params = testMethods.get(0).getParameters();
        w.append(this.indent).append("    @Specialization\n");
        w.append(this.indent).append("    protected Object ").append(TEST_METHOD_NAME).append("WithTarget");
        w.append("(");
        sep = "";
        for (VariableElement variableElement : params) {
            w.append(sep).append(ElementUtils.getUniqueIdentifier(variableElement.asType())).append(" ").append(variableElement.getSimpleName());
            sep = ", ";
        }
        w.append(") {\n");
        w.append(this.indent).append("        return ").append(TEST_METHOD_NAME).append("(");
        sep = "";
        for (VariableElement variableElement : params) {
            w.append(sep).append(variableElement.getSimpleName());
            sep = ", ";
        }
        w.append(");\n");
        w.append(this.indent).append("    }\n");
    }

    void appendRootNode(Writer w) throws IOException {
        w.append(this.indent).append("    private static final class LanguageCheckRootNode extends RootNode {\n");
        w.append(this.indent).append("        protected LanguageCheckRootNode() {\n");
        w.append(this.indent).append("            super(null);\n");
        w.append(this.indent).append("        }\n");
        w.append("\n");
        w.append(this.indent).append("        @Child private ").append(this.clazzName).append(" node = ").append(this.getGeneratedDSLNodeQualifiedName()).append(".create();");
        w.append("\n");
        w.append(this.indent).append("        @Override\n");
        w.append(this.indent).append("        public Object execute(VirtualFrame frame) {\n");
        w.append(this.indent).append("            Object receiver = com.oracle.truffle.api.interop.ForeignAccess.getReceiver(frame);\n");
        w.append(this.indent).append("            try {\n");
        w.append(this.indent).append("                return node.executeWithTarget(frame, receiver);\n");
        w.append(this.indent).append("            } catch (UnsupportedSpecializationException e) {\n");
        this.appendHandleUnsupportedTypeException(w);
        w.append(this.indent).append("            }\n");
        w.append(this.indent).append("        }\n");
        w.append("\n");
        w.append(this.indent).append("    }\n");
    }

    void appendRootNodeFactory(Writer w) throws IOException {
        w.append(this.indent).append("    public static RootNode createRoot() {\n");
        w.append(this.indent).append("        return new LanguageCheckRootNode();\n");
        w.append(this.indent).append("    }\n");
    }

    protected void appendHandleUnsupportedTypeException(Writer w) throws IOException {
        w.append(this.indent).append("                if (e.getNode() instanceof ").append(this.clazzName).append(") {\n");
        w.append(this.indent).append("                  throw UnsupportedTypeException.raise(e, e.getSuppliedValues());\n");
        w.append(this.indent).append("                } else {\n");
        w.append(this.indent).append("                  throw e;\n");
        w.append(this.indent).append("                }\n");
    }

    @Override
    public String toString() {
        return this.clazzName;
    }
}

