/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.interop;

import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.MessageResolution;
import com.oracle.truffle.api.interop.Resolve;
import com.oracle.truffle.dsl.processor.interop.ExecuteGenerator;
import com.oracle.truffle.dsl.processor.interop.ForeignAccessFactoryGenerator;
import com.oracle.truffle.dsl.processor.interop.GenericGenerator;
import com.oracle.truffle.dsl.processor.interop.InteropDSLProcessor;
import com.oracle.truffle.dsl.processor.interop.InteropNodeGenerator;
import com.oracle.truffle.dsl.processor.interop.KeysGenerator;
import com.oracle.truffle.dsl.processor.interop.ReadGenerator;
import com.oracle.truffle.dsl.processor.interop.UnaryGenerator;
import com.oracle.truffle.dsl.processor.interop.Utils;
import com.oracle.truffle.dsl.processor.interop.WriteGenerator;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;

abstract class MessageGenerator
extends InteropNodeGenerator {
    protected static final String ACCESS_METHOD_NAME = "access";
    protected final String messageName;
    protected final String receiverClassName;
    protected final String rootNodeName;

    MessageGenerator(ProcessingEnvironment processingEnv, Resolve resolveAnnotation, MessageResolution messageResolutionAnnotation, TypeElement element, ForeignAccessFactoryGenerator containingForeignAccessFactory) {
        super(processingEnv, element, containingForeignAccessFactory);
        this.receiverClassName = Utils.getReceiverTypeFullClassName(messageResolutionAnnotation);
        this.messageName = resolveAnnotation.message();
        String mName = this.messageName.substring(this.messageName.lastIndexOf(46) + 1);
        this.rootNodeName = mName + "RootNode";
    }

    public void appendGetName(Writer w) throws IOException {
        w.append(this.indent).append("        @Override\n");
        w.append(this.indent).append("        public String getName() {\n");
        String rootName = "Interop::" + this.messageName + "::";
        w.append(this.indent).append("            return \"").append(rootName).append("\" + " + this.receiverClassName + ".class.getName();\n");
        w.append(this.indent).append("        }\n\n");
    }

    @Override
    public void appendNode(Writer w) throws IOException {
        Utils.appendMessagesGeneratedByInformation(w, this.indent, ElementUtils.getQualifiedName(this.element), null);
        w.append(this.indent);
        Utils.appendVisibilityModifier(w, this.element);
        w.append("abstract static class ").append(this.clazzName).append(" extends ").append(this.userClassName).append(" {\n");
        this.appendExecuteWithTarget(w);
        this.appendSpecializations(w);
        this.appendRootNode(w);
        this.appendRootNodeFactory(w);
        w.append(this.indent).append("}\n");
    }

    public final List<ExecutableElement> getAccessMethods() {
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        for (Element element : this.element.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD || !element.getSimpleName().contentEquals(ACCESS_METHOD_NAME)) continue;
            ExecutableElement method = (ExecutableElement)element;
            methods.add(method);
        }
        return methods;
    }

    abstract int getParameterCount();

    public String checkSignature(ExecutableElement method) {
        if (method.getThrownTypes().size() > 0) {
            return "Method access must not throw a checked exception. Use an InteropException (e.g. UnknownIdentifierException.raise() ) to report an error to the host language.";
        }
        return null;
    }

    abstract String getTargetableNodeName();

    void appendExecuteWithTarget(Writer w) throws IOException {
        w.append(this.indent).append("    public abstract Object executeWithTarget(VirtualFrame frame");
        for (int i = 0; i < Math.max(1, this.getParameterCount()); ++i) {
            w.append(", ").append("Object ").append("o").append(String.valueOf(i));
        }
        w.append(");\n");
    }

    void appendSpecializations(Writer w) throws IOException {
        String sep = "";
        for (ExecutableElement method : this.getAccessMethods()) {
            List<? extends VariableElement> params = method.getParameters();
            w.append(this.indent).append("    @Specialization\n");
            w.append(this.indent).append("    protected Object ").append(ACCESS_METHOD_NAME).append("WithTarget");
            w.append("(");
            sep = "";
            for (VariableElement variableElement : params) {
                w.append(sep).append(ElementUtils.getUniqueIdentifier(variableElement.asType())).append(" ").append(variableElement.getSimpleName());
                sep = ", ";
            }
            w.append(") {\n");
            w.append(this.indent).append("        return ").append(ACCESS_METHOD_NAME).append("(");
            sep = "";
            for (VariableElement variableElement : params) {
                w.append(sep).append(variableElement.getSimpleName());
                sep = ", ";
            }
            w.append(");\n");
            w.append(this.indent).append("    }\n");
        }
    }

    abstract void appendRootNode(Writer var1) throws IOException;

    void appendRootNodeFactory(Writer w) throws IOException {
        w.append(this.indent).append("    public static RootNode createRoot() {\n");
        w.append(this.indent).append("        return new ").append(this.rootNodeName).append("();\n");
        w.append(this.indent).append("    }\n");
    }

    @Override
    public String toString() {
        return this.clazzName;
    }

    public static MessageGenerator getGenerator(ProcessingEnvironment processingEnv, Resolve resolveAnnotation, MessageResolution messageResolutionAnnotation, TypeElement element, ForeignAccessFactoryGenerator containingForeignAccessFactory) {
        SuppressWarnings suppress;
        String messageName = resolveAnnotation.message();
        Object currentMessage = Utils.getMessage(processingEnv, messageName);
        if (!(currentMessage != null || (suppress = element.getAnnotation(SuppressWarnings.class)) != null && Arrays.asList(suppress.value()).contains("unknown-message"))) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unknown message " + messageName + " (add @SuppressWarnings(\"unknown-message\") to ignore this warning)", element);
        }
        if (Message.READ.toString().equalsIgnoreCase(messageName) || Message.KEY_INFO.toString().equalsIgnoreCase(messageName) || Message.REMOVE.toString().equalsIgnoreCase(messageName)) {
            return new ReadGenerator(processingEnv, resolveAnnotation, messageResolutionAnnotation, element, containingForeignAccessFactory);
        }
        if (Message.WRITE.toString().equalsIgnoreCase(messageName)) {
            return new WriteGenerator(processingEnv, resolveAnnotation, messageResolutionAnnotation, element, containingForeignAccessFactory);
        }
        if (Message.IS_NULL.toString().equalsIgnoreCase(messageName) || Message.IS_EXECUTABLE.toString().equalsIgnoreCase(messageName) || Message.IS_BOXED.toString().equalsIgnoreCase(messageName) || Message.HAS_SIZE.toString().equalsIgnoreCase(messageName) || Message.GET_SIZE.toString().equalsIgnoreCase(messageName) || Message.UNBOX.toString().equalsIgnoreCase(messageName) || Message.IS_INSTANTIABLE.toString().equalsIgnoreCase(messageName) || Message.HAS_KEYS.toString().equalsIgnoreCase(messageName) || Message.IS_POINTER.toString().equalsIgnoreCase(messageName) || Message.AS_POINTER.toString().equalsIgnoreCase(messageName) || Message.TO_NATIVE.toString().equalsIgnoreCase(messageName)) {
            return new UnaryGenerator(processingEnv, resolveAnnotation, messageResolutionAnnotation, element, containingForeignAccessFactory);
        }
        if (Message.KEYS.toString().equalsIgnoreCase(messageName)) {
            return new KeysGenerator(processingEnv, resolveAnnotation, messageResolutionAnnotation, element, containingForeignAccessFactory);
        }
        if (Message.EXECUTE.toString().equalsIgnoreCase(messageName) || Message.INVOKE.toString().equalsIgnoreCase(messageName) || Message.NEW.toString().equalsIgnoreCase(messageName)) {
            return new ExecuteGenerator(processingEnv, resolveAnnotation, messageResolutionAnnotation, element, containingForeignAccessFactory);
        }
        assert (!InteropDSLProcessor.getKnownMessages().contains(currentMessage));
        return new GenericGenerator(processingEnv, resolveAnnotation, messageResolutionAnnotation, element, containingForeignAccessFactory);
    }

    protected void appendHandleUnsupportedTypeException(Writer w) throws IOException {
        w.append(this.indent).append("                if (e.getNode() instanceof ").append(this.clazzName).append(") {\n");
        w.append(this.indent).append("                  throw UnsupportedTypeException.raise(e, e.getSuppliedValues());\n");
        w.append(this.indent).append("                } else {\n");
        w.append(this.indent).append("                  throw e;\n");
        w.append(this.indent).append("                }\n");
    }

    public String getMessageName() {
        return this.messageName;
    }
}

