/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.interop;

import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.MessageResolution;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

final class Utils {
    Utils() {
    }

    static String getReceiverTypeFullClassName(MessageResolution message) {
        try {
            message.receiverType().getName();
            throw new AssertionError();
        }
        catch (MirroredTypeException mte) {
            String receiverTypeFullClassName = ElementUtils.getQualifiedName(mte.getTypeMirror());
            return receiverTypeFullClassName;
        }
    }

    static Object getMessage(ProcessingEnvironment processingEnv, String messageName) {
        Object currentMessage;
        block2: {
            currentMessage = null;
            try {
                currentMessage = Message.valueOf((String)messageName);
            }
            catch (IllegalArgumentException ex) {
                TypeElement typeElement = ElementUtils.getTypeElement(processingEnv, messageName);
                TypeElement messageElement = ElementUtils.getTypeElement(processingEnv, Message.class.getName());
                if (typeElement == null || !processingEnv.getTypeUtils().isAssignable(typeElement.asType(), messageElement.asType())) break block2;
                currentMessage = messageName;
            }
        }
        return currentMessage;
    }

    static TypeMirror getTypeMirror(ProcessingEnvironment env, Class<?> clazz) {
        String name = clazz.getName();
        TypeElement elem = ElementUtils.getTypeElement(env, name);
        return elem.asType();
    }

    static boolean isObjectArray(TypeMirror actualType) {
        return actualType.getKind() == TypeKind.ARRAY && ElementUtils.getQualifiedName(actualType).equals("java.lang.Object");
    }

    static String getFullResolveClassName(TypeElement innerClass) {
        return ElementUtils.getPackageName(innerClass) + "." + Utils.getSimpleResolveClassName(innerClass);
    }

    static String getSimpleResolveClassName(TypeElement innerClass) {
        String generatedClassName = ElementUtils.getSimpleName(innerClass);
        if (generatedClassName.endsWith("Node")) {
            generatedClassName = generatedClassName.substring(0, generatedClassName.length() - "Node".length());
        }
        return generatedClassName + "SubNode";
    }

    static void appendFactoryGeneratedFor(Writer w, String indent, String generatedFor, String generatedBy) throws IOException {
        w.append("\n");
        w.append(indent).append("/**\n");
        w.append(indent).append(" * This foreign access factory is generated by {@link ").append(generatedBy).append("}.\n");
        w.append(indent).append(" * You are supposed to use it for the receiver object {@link ").append(generatedFor).append("}.\n");
        w.append(indent).append(" */\n");
        w.append(indent).append("@GeneratedBy(").append(generatedBy).append(".class)\n");
    }

    static void suppressDeprecationWarnings(Writer w, String indent) throws IOException {
        w.append("\n");
        w.append(indent).append("@SuppressWarnings(\"deprecation\")");
        w.append("\n");
    }

    static void appendMessagesGeneratedByInformation(Writer w, String indent, String generatedBy, String generatedFor) throws IOException {
        w.append("\n");
        w.append(indent).append("/**\n");
        w.append(indent).append(" * This message resolution is generated by {@link ").append(generatedBy).append("}.\n");
        if (generatedFor != null) {
            w.append(indent).append(" * Generated for {@link ").append(generatedFor).append("}.\n");
        }
        w.append(indent).append(" */\n");
    }

    static void appendVisibilityModifier(Writer w, TypeElement element) throws IOException {
        if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            w.append("public ");
        } else if (element.getModifiers().contains((Object)Modifier.PROTECTED)) {
            w.append("protected ");
        } else if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            throw new IllegalStateException();
        }
    }
}

