/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.interop;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.MessageResolution;
import com.oracle.truffle.api.interop.Resolve;
import com.oracle.truffle.dsl.processor.interop.ForeignAccessFactoryGenerator;
import com.oracle.truffle.dsl.processor.interop.MessageGenerator;
import com.oracle.truffle.dsl.processor.interop.Utils;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

final class WriteGenerator
extends MessageGenerator {
    private static final int NUMBER_OF_WRITE = 3;
    private static final String TARGETABLE_WRITE_NODE = "TargetableWriteNode";

    WriteGenerator(ProcessingEnvironment processingEnv, Resolve resolveAnnotation, MessageResolution messageResolutionAnnotation, TypeElement element, ForeignAccessFactoryGenerator containingForeignAccessFactory) {
        super(processingEnv, resolveAnnotation, messageResolutionAnnotation, element, containingForeignAccessFactory);
    }

    @Override
    void appendRootNode(Writer w) throws IOException {
        w.append(this.indent).append("    private static final class ").append(this.rootNodeName).append(" extends RootNode {\n");
        w.append(this.indent).append("        protected ").append(this.rootNodeName).append("() {\n");
        w.append(this.indent).append("            super(null);\n");
        w.append(this.indent).append("        }\n");
        w.append("\n");
        w.append(this.indent).append("        @Child private ").append(this.clazzName).append(" node = ").append(this.getGeneratedDSLNodeQualifiedName()).append(".create();");
        w.append("\n");
        this.appendGetName(w);
        w.append(this.indent).append("        @Override\n");
        w.append(this.indent).append("        public Object execute(VirtualFrame frame) {\n");
        w.append(this.indent).append("            Object receiver = com.oracle.truffle.api.interop.ForeignAccess.getReceiver(frame);\n");
        w.append(this.indent).append("            Object[] arguments = frame.getArguments();\n");
        w.append(this.indent).append("            Object identifier = arguments[1];\n");
        w.append(this.indent).append("            Object value = arguments[2];\n");
        w.append(this.indent).append("            try {\n");
        w.append(this.indent).append("                return node.executeWithTarget(frame, receiver, identifier, value);\n");
        w.append(this.indent).append("            } catch (UnsupportedSpecializationException e) {\n");
        this.appendHandleUnsupportedTypeException(w);
        w.append(this.indent).append("            }\n");
        w.append(this.indent).append("        }\n");
        w.append("\n");
        w.append(this.indent).append("    }\n");
    }

    @Override
    int getParameterCount() {
        return 3;
    }

    @Override
    String getTargetableNodeName() {
        return TARGETABLE_WRITE_NODE;
    }

    @Override
    public String checkSignature(ExecutableElement method) {
        int expectedNumberOfArguments;
        List<? extends VariableElement> params = method.getParameters();
        boolean hasFrameArgument = false;
        if (params.size() >= 1) {
            hasFrameArgument = ElementUtils.areTypesCompatible(params.get(0).asType(), Utils.getTypeMirror(this.processingEnv, VirtualFrame.class));
        }
        int n = expectedNumberOfArguments = hasFrameArgument ? this.getParameterCount() + 1 : this.getParameterCount();
        if (params.size() != expectedNumberOfArguments) {
            return "Wrong number of arguments. Expected signature: ([frame: VirtualFrame], receiverObject: TruffleObject, identifier: String, value: Object)";
        }
        return super.checkSignature(method);
    }
}

