/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.library;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.expression.DSLExpression;
import com.oracle.truffle.dsl.processor.generator.CodeTypeElementFactory;
import com.oracle.truffle.dsl.processor.generator.DSLExpressionGenerator;
import com.oracle.truffle.dsl.processor.generator.FlatNodeGenFactory;
import com.oracle.truffle.dsl.processor.generator.GeneratorUtils;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeNames;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.java.model.GeneratedTypeMirror;
import com.oracle.truffle.dsl.processor.library.ExportMessageData;
import com.oracle.truffle.dsl.processor.library.ExportsData;
import com.oracle.truffle.dsl.processor.library.ExportsLibrary;
import com.oracle.truffle.dsl.processor.library.LibraryData;
import com.oracle.truffle.dsl.processor.library.LibraryMessage;
import com.oracle.truffle.dsl.processor.model.CacheExpression;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.model.SpecializationData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class ExportsGenerator
extends CodeTypeElementFactory<ExportsData> {
    private static final String ACCEPTS = "accepts";
    private static final String ACCEPTS_METHOD_NAME = "accepts_";
    private final ProcessorContext context = ProcessorContext.getInstance();
    private final Map<String, CodeVariableElement> libraryConstants;

    public ExportsGenerator(Map<String, CodeVariableElement> libraryConstants) {
        this.libraryConstants = libraryConstants;
    }

    @Override
    public List<CodeTypeElement> create(ProcessorContext context1, ExportsData exports) {
        this.libraryConstants.clear();
        String className = exports.getTemplateType().getSimpleName().toString() + "Gen";
        CodeTypeElement genClass = GeneratorUtils.createClass(exports, null, ElementUtils.modifiers(Modifier.FINAL), className, null);
        CodeTreeBuilder statics = genClass.add(new CodeExecutableElement(ElementUtils.modifiers(Modifier.STATIC), null, "<cinit>", new CodeVariableElement[0])).createBuilder();
        statics.startStatement();
        statics.startStaticCall(this.context.getType(LibraryExport.class), "register");
        statics.typeLiteral(exports.getTemplateType().asType());
        genClass.add(GeneratorUtils.createConstructorUsingFields(ElementUtils.modifiers(Modifier.PRIVATE), genClass));
        for (ExportsLibrary libraryExports : exports.getExportedLibraries().values()) {
            if (libraryExports.hasErrors()) continue;
            TypeElement libraryBaseTypeElement = libraryExports.getLibrary().getTemplateType();
            DeclaredType libraryBaseType = (DeclaredType)libraryBaseTypeElement.asType();
            CodeTypeElement uncachedClass = this.createUncached(libraryExports);
            CodeTypeElement cacheClass = this.createCached(libraryExports);
            CodeTypeElement resolvedExports = this.createResolvedExports(libraryExports, ElementUtils.getSimpleName(libraryBaseType) + "Exports", cacheClass, uncachedClass);
            resolvedExports.add(cacheClass);
            resolvedExports.add(uncachedClass);
            genClass.add(resolvedExports);
            statics.startNew(resolvedExports.asType()).end();
        }
        statics.end();
        statics.end();
        genClass.addAll(this.libraryConstants.values());
        return Arrays.asList(genClass);
    }

    private static void groupMergedLibraries(Collection<SpecializationData> specializations, Map<MergeLibraryKey, List<CacheExpression>> mergedLibraries) {
        for (SpecializationData specialization : specializations) {
            if (!specialization.isReachable()) continue;
            for (CacheExpression cache : specialization.getCaches()) {
                if (!cache.isMergedLibrary()) continue;
                mergedLibraries.computeIfAbsent(new MergeLibraryKey(cache), b -> new ArrayList()).add(cache);
            }
        }
    }

    private static boolean useSingleton(ExportsLibrary library, boolean cached) {
        return library.isFinalReceiver() && !library.needsRewrites() && !library.needsDynamicDispatch() && !ExportsGenerator.needsReceiver(library, cached);
    }

    CodeTypeElement createResolvedExports(ExportsLibrary library, String className, CodeTypeElement cacheClass, CodeTypeElement uncachedClass) {
        TypeElement libraryBaseTypeElement = library.getLibrary().getTemplateType();
        DeclaredType libraryBaseType = (DeclaredType)libraryBaseTypeElement.asType();
        TypeMirror exportReceiverType = library.getReceiverType();
        CodeTypeMirror.DeclaredCodeTypeMirror baseType = new CodeTypeMirror.DeclaredCodeTypeMirror(this.context.getTypeElement(LibraryExport.class), Arrays.asList(libraryBaseType));
        CodeTypeElement exportsClass = GeneratorUtils.createClass(library, null, ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), className, baseType);
        CodeExecutableElement constructor = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE), null, exportsClass.getSimpleName().toString(), new CodeVariableElement[0]);
        CodeTreeBuilder builder = constructor.createBuilder();
        builder.startStatement().startSuperCall().typeLiteral(libraryBaseType).typeLiteral(library.getReceiverType()).string(Boolean.valueOf(library.isDefaultExport()).toString()).end().end();
        exportsClass.add(constructor);
        CodeVariableElement uncachedSingleton = null;
        if (ExportsGenerator.useSingleton(library, false)) {
            GeneratedTypeMirror uncachedType = new GeneratedTypeMirror("", uncachedClass.getSimpleName().toString());
            uncachedSingleton = exportsClass.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), uncachedType, "UNCACHED"));
            builder = uncachedSingleton.createInitBuilder();
            builder.startNew(uncachedType).end();
        }
        CodeExecutableElement createUncached = CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.context.getDeclaredType(LibraryExport.class), "createUncached"));
        createUncached.setReturnType(libraryBaseType);
        createUncached.getModifiers().remove((Object)Modifier.ABSTRACT);
        createUncached.renameArguments("receiver");
        builder = createUncached.createBuilder();
        if (!ElementUtils.typeEquals(exportReceiverType, this.context.getType(Object.class))) {
            builder.startAssert().string("receiver instanceof ").type(exportReceiverType).end();
        }
        builder.startReturn();
        if (uncachedSingleton != null) {
            builder.staticReference(uncachedSingleton);
        } else {
            ExecutableElement uncachedClassConstructor;
            List<ExecutableElement> constructors = ElementFilter.constructorsIn(uncachedClass.getEnclosedElements());
            builder.startNew(uncachedClass.getSimpleName().toString());
            if (!constructors.isEmpty() && (uncachedClassConstructor = constructors.iterator().next()).getParameters().size() == 1) {
                builder.string("receiver");
            }
            builder.end();
        }
        builder.end();
        exportsClass.add(createUncached);
        CodeVariableElement cacheSingleton = null;
        if (ExportsGenerator.useSingleton(library, true)) {
            GeneratedTypeMirror cachedType = new GeneratedTypeMirror("", cacheClass.getSimpleName().toString());
            cacheSingleton = exportsClass.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), cachedType, "CACHE"));
            builder = cacheSingleton.createInitBuilder();
            builder.startNew(cachedType).end();
        }
        CodeExecutableElement createCached = CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.context.getDeclaredType(LibraryExport.class), "createCached"));
        createCached.setReturnType(libraryBaseType);
        createCached.getModifiers().remove((Object)Modifier.ABSTRACT);
        createCached.renameArguments("receiver");
        builder = createCached.createBuilder();
        if (!ElementUtils.typeEquals(exportReceiverType, this.context.getType(Object.class))) {
            builder.startAssert().string("receiver instanceof ").type(exportReceiverType).end();
        }
        builder.startReturn();
        if (cacheSingleton != null) {
            builder.staticReference(cacheSingleton);
        } else {
            ExecutableElement cacheClassConstructor;
            List<ExecutableElement> constructors = ElementFilter.constructorsIn(cacheClass.getEnclosedElements());
            builder.startNew(cacheClass.getSimpleName().toString());
            if (!constructors.isEmpty() && (cacheClassConstructor = constructors.iterator().next()).getParameters().size() == 1) {
                builder.string("receiver");
            }
            builder.end();
        }
        builder.end();
        exportsClass.add(createCached);
        return exportsClass;
    }

    private static CodeTree writeExpression(CacheExpression cache, String receiverName, TypeMirror receiverSourceType, TypeMirror receiverTargetType) {
        DSLExpression expression = cache.getDefaultExpression();
        Set<DSLExpression.Variable> boundVariables = expression.findBoundVariables();
        HashMap<DSLExpression.Variable, CodeTree> parameters = new HashMap<DSLExpression.Variable, CodeTree>();
        for (DSLExpression.Variable variable : boundVariables) {
            boolean needsCast;
            CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
            boolean bl = needsCast = !variable.equals(expression);
            if (needsCast && !ElementUtils.isAssignable(receiverSourceType, receiverTargetType)) {
                builder.startParantheses();
                builder.cast(receiverTargetType);
            }
            builder.string(receiverName);
            if (needsCast && !ElementUtils.isAssignable(receiverSourceType, receiverTargetType)) {
                builder.end();
            }
            parameters.put(variable, builder.build());
        }
        return DSLExpressionGenerator.write(expression, null, parameters);
    }

    CodeTypeElement createCached(ExportsLibrary libraryExports) {
        CodeTreeBuilder builder;
        TypeMirror exportReceiverType = libraryExports.getReceiverType();
        TypeElement libraryBaseTypeElement = libraryExports.getLibrary().getTemplateType();
        DeclaredType libraryBaseType = (DeclaredType)libraryBaseTypeElement.asType();
        LinkedHashMap<MergeLibraryKey, List<CacheExpression>> mergedLibraries = new LinkedHashMap<MergeLibraryKey, List<CacheExpression>>();
        for (ExportMessageData message : libraryExports.getExportedMessages().values()) {
            if (message.getSpecializedNode() == null) continue;
            ExportsGenerator.groupMergedLibraries(message.getSpecializedNode().getSpecializations(), mergedLibraries);
        }
        CodeTypeElement cacheClass = GeneratorUtils.createClass(libraryExports, null, ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), "Cached", libraryBaseType);
        CodeTree acceptsAssertions = this.createDynamicDispatchAssertions(libraryExports);
        CodeExecutableElement constructor = cacheClass.add(GeneratorUtils.createConstructorUsingFields(ElementUtils.modifiers(new Modifier[0]), cacheClass));
        if (ExportsGenerator.needsReceiver(libraryExports, true)) {
            constructor.addParameter(new CodeVariableElement(this.context.getType(Object.class), "receiver"));
            builder = constructor.appendBuilder();
            for (MergeLibraryKey key : mergedLibraries.keySet()) {
                CodeTree mergedLibraryIdentifier = ExportsGenerator.writeExpression(key.cache, "receiver", this.context.getType(Object.class), libraryExports.getReceiverType());
                String identifier = key.getCache().getMergedLibraryIdentifier();
                builder.startStatement();
                builder.string("this.", identifier, " = insert(");
                builder.staticReference(this.useLibraryConstant(key.libraryType)).startCall(".create").tree(mergedLibraryIdentifier).end();
                builder.string(")").end();
                CodeVariableElement var = cacheClass.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE), key.libraryType, identifier));
                var.getAnnotationMirrors().add(new CodeAnnotationMirror(this.context.getDeclaredType(Node.Child.class)));
            }
        }
        CodeTree defaultAccepts = this.createDefaultAccepts(cacheClass, constructor, libraryExports, exportReceiverType, true);
        CodeExecutableElement accepts = CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.context.getDeclaredType(Library.class), ACCEPTS));
        accepts.getModifiers().remove((Object)Modifier.ABSTRACT);
        accepts.renameArguments("receiver");
        builder = accepts.createBuilder();
        ExportMessageData acceptsMessage = libraryExports.getExportedMessages().get(ACCEPTS);
        if (acceptsAssertions != null) {
            builder.tree(acceptsAssertions);
        }
        if (mergedLibraries.isEmpty()) {
            builder.startReturn();
            if (acceptsMessage == null) {
                builder.tree(defaultAccepts);
            } else {
                builder.tree(defaultAccepts).string(" && accepts_(receiver)");
            }
            builder.end();
        } else {
            builder.startIf().string("!(").tree(defaultAccepts).string(")").end();
            builder.startBlock();
            builder.returnFalse();
            builder.end();
            for (Object key : mergedLibraries.keySet()) {
                CodeTree mergedLibraryInitializer = ExportsGenerator.writeExpression(((MergeLibraryKey)key).cache, "receiver", this.context.getType(Object.class), libraryExports.getReceiverType());
                String identifier = ((MergeLibraryKey)key).getCache().getMergedLibraryIdentifier();
                builder.startElseIf();
                builder.string("!this.", identifier);
                builder.startCall(".accepts").tree(mergedLibraryInitializer).end();
                builder.end().startBlock();
                builder.returnFalse();
                builder.end();
            }
            builder.startElseBlock();
            if (acceptsMessage != null) {
                builder.startReturn();
                builder.string("accepts_(receiver)");
                builder.end();
            } else {
                builder.returnTrue();
            }
            builder.end();
        }
        cacheClass.addOptional(this.createCastMethod(libraryExports, exportReceiverType, true));
        cacheClass.add(accepts);
        if (!libraryExports.needsRewrites() && ExportsGenerator.useSingleton(libraryExports, true)) {
            CodeExecutableElement isAdoptable = cacheClass.add(CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.context.getDeclaredType(Node.class), "isAdoptable")));
            builder = isAdoptable.createBuilder();
            if (libraryExports.needsDynamicDispatch()) {
                builder.startReturn();
                builder.startCall("dynamicDispatch_", "isAdoptable").end();
                builder.end();
            } else {
                builder.returnFalse();
            }
        }
        LinkedHashSet<NodeData> cachedSharedNodes = new LinkedHashSet<NodeData>();
        for (ExportMessageData export : libraryExports.getExportedMessages().values()) {
            if (export.getSpecializedNode() == null) continue;
            cachedSharedNodes.add(export.getSpecializedNode());
        }
        HashMap<NodeData, CodeTypeElement> sharedNodes = new HashMap<NodeData, CodeTypeElement>();
        for (ExportMessageData export : libraryExports.getExportedMessages().values()) {
            LibraryMessage message = export.getResolvedMessage();
            TypeMirror cachedExportReceiverType = export.getReceiverType();
            NodeData cachedSpecializedNode = export.getSpecializedNode();
            CodeElement cachedExecute = null;
            if (cachedSpecializedNode == null) {
                if (!export.isMethod()) {
                    throw new AssertionError((Object)("Missing method export. Missed validation for " + export.getResolvedMessage().getSimpleName()));
                }
                boolean isAccepts = message.getMessageElement().getSimpleName().toString().equals(ACCEPTS);
                TypeMirror modelReceiverType = isAccepts ? this.context.getType(Object.class) : message.getLibrary().getSignatureReceiverType();
                ExecutableElement exportMethod = (ExecutableElement)export.getMessageElement();
                CodeTree cachedReceiverAccess = this.createReceiverCast(libraryExports, modelReceiverType, cachedExportReceiverType, CodeTreeBuilder.singleString("receiver"), true);
                cachedReceiverAccess = CodeTreeBuilder.createBuilder().startParantheses().tree(cachedReceiverAccess).end().build();
                cachedExecute = cacheClass.add(this.createDirectCall(cachedReceiverAccess, message, exportMethod));
            } else {
                CodeTypeElement dummyNodeClass = (CodeTypeElement)sharedNodes.get(cachedSpecializedNode);
                boolean shared = true;
                if (dummyNodeClass == null) {
                    FlatNodeGenFactory factory = new FlatNodeGenFactory(this.context, cachedSpecializedNode, cachedSharedNodes, libraryExports.getSharedExpressions(), this.libraryConstants);
                    dummyNodeClass = GeneratorUtils.createClass(libraryExports, null, ElementUtils.modifiers(new Modifier[0]), "Dummy", this.context.getType(Node.class));
                    factory.create(dummyNodeClass);
                    sharedNodes.put(cachedSpecializedNode, dummyNodeClass);
                    shared = false;
                }
                for (Element element : dummyNodeClass.getEnclosedElements()) {
                    String simpleName = element.getSimpleName().toString();
                    if (element.getKind() == ElementKind.METHOD) {
                        if (!simpleName.endsWith("AndSpecialize") && simpleName.startsWith("execute") && simpleName.endsWith("_")) {
                            CodeExecutableElement executable = (CodeExecutableElement)element;
                            executable.setVarArgs(message.getExecutable().isVarArgs());
                            cachedExecute = CodeExecutableElement.clone(executable);
                            ((CodeExecutableElement)cachedExecute).setSimpleName(CodeNames.of(message.getName()));
                            this.injectReceiverType((CodeExecutableElement)cachedExecute, libraryExports, cachedExportReceiverType, true);
                            cacheClass.getEnclosedElements().add(cachedExecute);
                            continue;
                        }
                    } else if (element.getKind() == ElementKind.CONSTRUCTOR) continue;
                    if (shared) continue;
                    cacheClass.getEnclosedElements().add(element);
                }
            }
            if (message.getName().equals(ACCEPTS)) {
                if (export.getExportsLibrary().isFinalReceiver() && (cachedSpecializedNode == null || !cachedSpecializedNode.needsRewrites(this.context))) {
                    cachedExecute.getModifiers().add(Modifier.STATIC);
                }
                ((CodeExecutableElement)cachedExecute).setSimpleName(CodeNames.of(ACCEPTS_METHOD_NAME));
                ElementUtils.setVisibility(cachedExecute.getModifiers(), Modifier.PRIVATE);
                continue;
            }
            if (!libraryExports.needsRewrites()) continue;
            ExportsGenerator.injectCachedAssertions(export.getExportsLibrary().getLibrary(), (CodeExecutableElement)cachedExecute);
        }
        return cacheClass;
    }

    private static boolean needsReceiver(ExportsLibrary libraryExports, boolean cached) {
        if (cached) {
            for (ExportMessageData message : libraryExports.getExportedMessages().values()) {
                if (message.getSpecializedNode() == null) continue;
                for (SpecializationData specialization : message.getSpecializedNode().getSpecializations()) {
                    if (!specialization.isReachable()) continue;
                    for (CacheExpression cache : specialization.getCaches()) {
                        if (!cache.isMergedLibrary()) continue;
                        return true;
                    }
                }
            }
        }
        return libraryExports.needsDynamicDispatch() || !libraryExports.isFinalReceiver();
    }

    private CodeExecutableElement createCastMethod(ExportsLibrary libraryExports, TypeMirror exportReceiverType, boolean cached) {
        if (!libraryExports.getLibrary().isDynamicDispatch()) {
            return null;
        }
        CodeExecutableElement castMethod = CodeExecutableElement.cloneNoAnnotations(ElementUtils.findMethod(DynamicDispatchLibrary.class, "cast"));
        castMethod.getModifiers().remove((Object)Modifier.ABSTRACT);
        castMethod.renameArguments("receiver");
        CodeTreeBuilder builder = castMethod.createBuilder();
        if ((!cached || libraryExports.isFinalReceiver()) && ElementUtils.needsCastTo(castMethod.getParameters().get(0).asType(), exportReceiverType)) {
            GeneratorUtils.mergeSupressWarnings(castMethod, "cast");
        }
        if (!cached && ElementUtils.findAnnotationMirror((Element)castMethod, CompilerDirectives.TruffleBoundary.class) == null) {
            castMethod.getAnnotationMirrors().add(new CodeAnnotationMirror(this.context.getDeclaredType(CompilerDirectives.TruffleBoundary.class)));
        }
        builder.startReturn().tree(this.createReceiverCast(libraryExports, castMethod.getParameters().get(0).asType(), exportReceiverType, CodeTreeBuilder.singleString("receiver"), cached)).end();
        return castMethod;
    }

    private CodeTree createDefaultAccepts(CodeTypeElement libraryGen, CodeExecutableElement constructor, ExportsLibrary libraryExports, TypeMirror exportReceiverType, boolean cached) {
        CodeTreeBuilder acceptsBuilder = CodeTreeBuilder.createBuilder();
        if (libraryExports.needsDynamicDispatch()) {
            CodeVariableElement dynamicDispatchLibrary = libraryGen.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE), this.context.getType(DynamicDispatchLibrary.class), "dynamicDispatch_"));
            dynamicDispatchLibrary.addAnnotationMirror(new CodeAnnotationMirror(this.context.getDeclaredType(Node.Child.class)));
            CodeVariableElement dispatchLibraryConstant = this.useDispatchLibraryConstant();
            CodeTreeBuilder constructorBuilder = constructor.appendBuilder();
            if (cached) {
                constructorBuilder.startStatement().string("this.dynamicDispatch_ = insert(").staticReference(dispatchLibraryConstant).string(".create(receiver))").end();
            } else {
                constructorBuilder.startStatement().string("this.dynamicDispatch_ = ").staticReference(dispatchLibraryConstant).string(".getUncached(receiver)").end();
            }
            acceptsBuilder.string("dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == ");
            if (libraryExports.isDynamicDispatchTarget()) {
                acceptsBuilder.typeLiteral(libraryExports.getTemplateType().asType());
            } else {
                CodeVariableElement dynamicDispatchTarget = libraryGen.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.FINAL), this.context.getType(Class.class), "dynamicDispatchTarget_"));
                if (cached) {
                    constructorBuilder.startStatement();
                    constructorBuilder.string("this.dynamicDispatchTarget_ = ").staticReference(dispatchLibraryConstant).string(".getUncached(receiver).dispatch(receiver)");
                    constructorBuilder.end();
                } else {
                    constructorBuilder.statement("this.dynamicDispatchTarget_ = dynamicDispatch_.dispatch(receiver)");
                }
                acceptsBuilder.string(dynamicDispatchTarget.getSimpleName().toString());
            }
        } else if (libraryExports.isFinalReceiver()) {
            acceptsBuilder.string("receiver instanceof ").type(exportReceiverType);
        } else {
            CodeTypeMirror.DeclaredCodeTypeMirror receiverClassType = new CodeTypeMirror.DeclaredCodeTypeMirror(this.context.getTypeElement(Class.class), Arrays.asList(new CodeTypeMirror.WildcardTypeMirror(libraryExports.getReceiverType(), null)));
            libraryGen.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.FINAL), receiverClassType, "receiverClass_"));
            if (ElementUtils.isObject(libraryExports.getReceiverType())) {
                constructor.appendBuilder().startStatement().string("this.receiverClass_ = receiver.getClass()").end();
            } else {
                constructor.appendBuilder().startStatement().string("this.receiverClass_ = (").cast(libraryExports.getReceiverType()).string("receiver).getClass()").end();
            }
            acceptsBuilder.string("receiver.getClass() == this.receiverClass_");
        }
        CodeTree defaultAccepts = acceptsBuilder.build();
        return defaultAccepts;
    }

    private CodeVariableElement useLibraryConstant(TypeMirror typeConstant) {
        return FlatNodeGenFactory.createLibraryConstant(this.libraryConstants, typeConstant);
    }

    private CodeVariableElement useDispatchLibraryConstant() {
        return this.useLibraryConstant(this.context.getType(DynamicDispatchLibrary.class));
    }

    private CodeTree createDynamicDispatchAssertions(ExportsLibrary libraryExports) {
        if (libraryExports.needsDynamicDispatch() || libraryExports.getLibrary().isDynamicDispatch()) {
            return null;
        }
        CodeVariableElement dispatchLibraryConstant = this.useDispatchLibraryConstant();
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.startAssert();
        if (libraryExports.isFinalReceiver()) {
            builder.string("!(receiver instanceof ").type(libraryExports.getReceiverType()).string(")");
        } else {
            builder.string("receiver.getClass() != this.receiverClass_");
        }
        builder.string(" || ");
        builder.staticReference(dispatchLibraryConstant).string(".getUncached().dispatch(receiver) == null : ").doubleQuote("Invalid library export '" + libraryExports.getTemplateType().getQualifiedName().toString() + "'. Exported receiver with dynamic dispatch found but not expected.");
        builder.end();
        return builder.build();
    }

    CodeTypeElement createUncached(ExportsLibrary libraryExports) {
        TypeMirror exportReceiverType = libraryExports.getReceiverType();
        TypeElement libraryBaseTypeElement = libraryExports.getLibrary().getTemplateType();
        DeclaredType libraryBaseType = (DeclaredType)libraryBaseTypeElement.asType();
        TypeMirror libraryReceiverType = libraryExports.getLibrary().getExportsReceiverType();
        CodeTypeElement uncachedClass = GeneratorUtils.createClass(libraryExports, null, ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), "Uncached", libraryBaseType);
        CodeExecutableElement constructor = uncachedClass.add(GeneratorUtils.createConstructorUsingFields(ElementUtils.modifiers(new Modifier[0]), uncachedClass));
        if (ExportsGenerator.needsReceiver(libraryExports, false)) {
            constructor.addParameter(new CodeVariableElement(this.context.getType(Object.class), "receiver"));
        }
        CodeTree acceptsAssertions = this.createDynamicDispatchAssertions(libraryExports);
        CodeTree defaultAccepts = this.createDefaultAccepts(uncachedClass, constructor, libraryExports, exportReceiverType, false);
        CodeExecutableElement acceptUncached = CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.context.getDeclaredType(Library.class), ACCEPTS));
        if (ElementUtils.findAnnotationMirror((Element)acceptUncached, CompilerDirectives.TruffleBoundary.class) == null) {
            acceptUncached.getAnnotationMirrors().add(new CodeAnnotationMirror(this.context.getDeclaredType(CompilerDirectives.TruffleBoundary.class)));
        }
        acceptUncached.getModifiers().remove((Object)Modifier.ABSTRACT);
        acceptUncached.renameArguments("receiver");
        CodeTreeBuilder builder = acceptUncached.createBuilder();
        if (acceptsAssertions != null) {
            builder.tree(acceptsAssertions);
        }
        if (libraryExports.getExportedMessages().get(ACCEPTS) == null) {
            builder.startReturn().tree(defaultAccepts).end();
        } else {
            builder.startReturn().tree(defaultAccepts).string(" && accepts_(receiver)").end();
        }
        builder.end();
        uncachedClass.add(acceptUncached);
        uncachedClass.addOptional(this.createCastMethod(libraryExports, exportReceiverType, false));
        LinkedHashSet<NodeData> uncachedSharedNodes = new LinkedHashSet<NodeData>();
        for (ExportMessageData export : libraryExports.getExportedMessages().values()) {
            if (export.getSpecializedNode() == null) continue;
            uncachedSharedNodes.add(export.getSpecializedNode());
        }
        CodeExecutableElement isAdoptable = uncachedClass.add(CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.context.getDeclaredType(Node.class), "isAdoptable")));
        isAdoptable.createBuilder().returnFalse();
        CodeExecutableElement getCost = uncachedClass.add(CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.context.getDeclaredType(Node.class), "getCost")));
        getCost.createBuilder().startReturn().staticReference(ElementUtils.findVariableElement(this.context.getDeclaredType(NodeCost.class), "MEGAMORPHIC")).end();
        boolean firstNode = true;
        for (ExportMessageData export : libraryExports.getExportedMessages().values()) {
            CodeExecutableElement uncachedExecute;
            LibraryMessage message = export.getResolvedMessage();
            TypeMirror uncachedReceiverType = export.getReceiverType();
            CodeTree uncachedReceiverExport = CodeTreeBuilder.createBuilder().maybeCast(libraryReceiverType, uncachedReceiverType, "receiver").build();
            NodeData uncachedSpecializedNode = export.getSpecializedNode();
            if (uncachedSpecializedNode == null) {
                if (!export.isMethod()) {
                    throw new AssertionError((Object)("Missing method export. Missed validation for " + export.getResolvedMessage().getSimpleName()));
                }
                ExecutableElement exportMethod = (ExecutableElement)export.getMessageElement();
                CodeExecutableElement directCall = this.createDirectCall(uncachedReceiverExport, message, exportMethod);
                uncachedExecute = uncachedClass.add(directCall);
                if (message.getName().equals(ACCEPTS)) {
                    directCall.getModifiers().add(Modifier.STATIC);
                }
            } else {
                FlatNodeGenFactory factory = new FlatNodeGenFactory(this.context, uncachedSpecializedNode, uncachedSharedNodes, Collections.emptyMap(), this.libraryConstants);
                CodeExecutableElement generatedUncached = factory.createUncached();
                if (firstNode) {
                    uncachedClass.getEnclosedElements().addAll(factory.createUncachedFields());
                    firstNode = false;
                }
                generatedUncached.getModifiers().remove((Object)Modifier.STATIC);
                ElementUtils.setVisibility(generatedUncached.getModifiers(), Modifier.PUBLIC);
                generatedUncached.setSimpleName(CodeNames.of(message.getName()));
                generatedUncached.setVarArgs(message.getExecutable().isVarArgs());
                this.injectReceiverType(generatedUncached, libraryExports, uncachedReceiverType, false);
                uncachedExecute = uncachedClass.add(generatedUncached);
            }
            if (message.getName().equals(ACCEPTS)) {
                uncachedExecute.getModifiers().add(Modifier.STATIC);
                uncachedExecute.setSimpleName(CodeNames.of(ACCEPTS_METHOD_NAME));
                ElementUtils.setVisibility(uncachedExecute.getModifiers(), Modifier.PRIVATE);
            }
            if (ElementUtils.findAnnotationMirror((Element)uncachedExecute, CompilerDirectives.TruffleBoundary.class) != null) continue;
            uncachedExecute.getAnnotationMirrors().add(new CodeAnnotationMirror(this.context.getDeclaredType(CompilerDirectives.TruffleBoundary.class)));
        }
        return uncachedClass;
    }

    static void injectCachedAssertions(LibraryData libraryData, CodeExecutableElement cachedExecute) {
        CodeTree body = cachedExecute.getBodyTree();
        CodeTreeBuilder builder = cachedExecute.createBuilder();
        ExecutableElement element = ElementUtils.findExecutableElement((DeclaredType)libraryData.getTemplateType().asType(), "assertAdopted");
        if (element != null) {
            builder.startAssert().string("assertAdopted()").end();
        } else {
            builder.startAssert().string("getRootNode() != null : ").doubleQuote("Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.").end();
        }
        builder.tree(body);
    }

    private CodeExecutableElement createDirectCall(CodeTree receiverAccess, LibraryMessage message, ExecutableElement targetMethod) {
        CodeExecutableElement cachedExecute = CodeExecutableElement.cloneNoAnnotations(message.getExecutable());
        cachedExecute.renameArguments("receiver");
        cachedExecute.getModifiers().remove((Object)Modifier.DEFAULT);
        cachedExecute.getModifiers().remove((Object)Modifier.ABSTRACT);
        CodeTreeBuilder builder = cachedExecute.createBuilder();
        if (!message.getName().equals(ACCEPTS)) {
            ExportsGenerator.addAcceptsAssertion(builder);
        }
        if (targetMethod == null && message.getMessageElement().getModifiers().contains((Object)Modifier.ABSTRACT)) {
            builder.startThrow().startNew(this.context.getType(AbstractMethodError.class)).end().end();
        } else {
            builder.startReturn();
            if (targetMethod == null) {
                builder.startCall("super", message.getName());
                builder.tree(receiverAccess);
            } else if (targetMethod.getModifiers().contains((Object)Modifier.STATIC)) {
                builder.startStaticCall(targetMethod);
                builder.tree(receiverAccess);
            } else {
                builder.startCall(receiverAccess, targetMethod.getSimpleName().toString());
            }
            List<? extends VariableElement> parameters = message.getExecutable().getParameters();
            for (VariableElement variableElement : parameters.subList(1, parameters.size())) {
                builder.string(variableElement.getSimpleName().toString());
            }
            builder.end();
            builder.end();
        }
        return cachedExecute;
    }

    private void injectReceiverType(CodeExecutableElement executable, ExportsLibrary library, TypeMirror receiverType, boolean cached) {
        boolean isAccepts = executable.getSimpleName().toString().equals(ACCEPTS);
        TypeMirror modelReceiverType = isAccepts ? this.context.getType(Object.class) : library.getLibrary().getSignatureReceiverType();
        if (!ElementUtils.needsCastTo(modelReceiverType, receiverType)) {
            return;
        }
        CodeVariableElement receiverParam = (CodeVariableElement)executable.getParameters().get(0);
        receiverParam.setType(modelReceiverType);
        String originalReceiverParamName = receiverParam.getName();
        String newReceiverParamName = originalReceiverParamName + "_";
        receiverParam.setName(newReceiverParamName);
        CodeTree tree = executable.getBodyTree();
        CodeTreeBuilder executeBody = executable.createBuilder();
        if (!isAccepts) {
            ExportsGenerator.addAcceptsAssertion(executeBody);
        }
        CodeTree cast = this.createReceiverCast(library, modelReceiverType, receiverType, CodeTreeBuilder.singleString(newReceiverParamName), cached);
        executeBody.declaration(receiverType, originalReceiverParamName, cast);
        executeBody.tree(tree);
    }

    private CodeTree createReceiverCast(ExportsLibrary library, TypeMirror sourceType, TypeMirror targetType, CodeTree receiver, boolean cached) {
        CodeTree cast = !cached || library.isFinalReceiver() ? CodeTreeBuilder.createBuilder().maybeCast(sourceType, targetType).tree(receiver).build() : (library.needsDynamicDispatch() ? CodeTreeBuilder.createBuilder().maybeCast(this.context.getType(Object.class), targetType).startCall("dynamicDispatch_.cast").tree(receiver).end().build() : CodeTreeBuilder.createBuilder().startStaticCall(this.context.getType(CompilerDirectives.class), "castExact").tree(receiver).string("receiverClass_").end().build());
        return cast;
    }

    private static void addAcceptsAssertion(CodeTreeBuilder executeBody) {
        String name = executeBody.findMethod().getParameters().get(0).getSimpleName().toString();
        executeBody.startAssert().string("this.accepts(", name, ")").string(" : ").doubleQuote("Invalid library usage. Library does not accept given receiver.").end();
    }

    static class MergeLibraryKey {
        private final TypeMirror libraryType;
        private final DSLExpression expressionKey;
        private final CacheExpression cache;

        MergeLibraryKey(CacheExpression cache) {
            this.libraryType = cache.getParameter().getType();
            this.expressionKey = cache.getDefaultExpression().reduce(new DSLExpression.DSLExpressionReducer(){

                @Override
                public DSLExpression visitVariable(DSLExpression.Variable binary) {
                    if (binary.getReceiver() == null) {
                        DSLExpression.Variable newVar = new DSLExpression.Variable(null, "receiver");
                        TypeMirror newReceiverType = ProcessorContext.getInstance().getType(Object.class);
                        newVar.setResolvedTargetType(newReceiverType);
                        newVar.setResolvedVariable(new CodeVariableElement(newReceiverType, "receiver"));
                        return newVar;
                    }
                    return binary;
                }

                @Override
                public DSLExpression visitNegate(DSLExpression.Negate negate) {
                    return negate;
                }

                @Override
                public DSLExpression visitCall(DSLExpression.Call binary) {
                    return binary;
                }

                @Override
                public DSLExpression visitBinary(DSLExpression.Binary binary) {
                    return binary;
                }
            });
            this.cache = cache;
        }

        public int hashCode() {
            return Objects.hash(ElementUtils.getTypeId(this.libraryType), this.expressionKey);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof MergeLibraryKey) {
                MergeLibraryKey other = (MergeLibraryKey)obj;
                return Objects.equals(this.libraryType, other.libraryType) && Objects.equals(this.expressionKey, other.expressionKey);
            }
            return false;
        }

        public CacheExpression getCache() {
            return this.cache;
        }
    }
}

