/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.model;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.expression.DSLExpression;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.Parameter;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public final class CacheExpression
extends MessageContainer {
    private final Parameter sourceParameter;
    private final AnnotationMirror sourceAnnotationMirror;
    private int dimensions = -1;
    private DSLExpression defaultExpression;
    private DSLExpression uncachedExpression;
    private boolean alwaysInitialized = false;
    private MessageContainer.Message uncachedExpressionError;
    private boolean requiresBoundary;
    private String sharedGroup;
    private boolean mergedLibrary;
    private TypeMirror languageType;
    private TypeMirror referenceType;

    public CacheExpression(Parameter sourceParameter, AnnotationMirror sourceAnnotationMirror) {
        this.sourceParameter = sourceParameter;
        this.sourceAnnotationMirror = sourceAnnotationMirror;
    }

    public CacheExpression copy() {
        CacheExpression copy = new CacheExpression(this.sourceParameter, this.sourceAnnotationMirror);
        copy.dimensions = this.dimensions;
        copy.defaultExpression = this.defaultExpression;
        copy.uncachedExpression = this.uncachedExpression;
        copy.alwaysInitialized = this.alwaysInitialized;
        copy.sharedGroup = this.sharedGroup;
        return copy;
    }

    public void setLanguageType(TypeMirror languageType) {
        this.languageType = languageType;
    }

    public boolean isReference() {
        if (this.isCachedLanguage()) {
            return !ElementUtils.typeEquals(this.getLanguageType(), this.getParameter().getType());
        }
        return ElementUtils.typeEquals(this.getReferenceType(), this.getParameter().getType());
    }

    public TypeMirror getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(TypeMirror supplierType) {
        this.referenceType = supplierType;
    }

    public TypeMirror getLanguageType() {
        return this.languageType;
    }

    public void setSharedGroup(String sharedGroup) {
        this.sharedGroup = sharedGroup;
    }

    public AnnotationMirror getSharedGroupMirror() {
        return ElementUtils.findAnnotationMirror((Element)this.sourceParameter.getVariableElement(), Cached.Shared.class);
    }

    public AnnotationValue getSharedGroupValue() {
        AnnotationMirror sharedAnnotation = this.getSharedGroupMirror();
        if (sharedAnnotation != null) {
            return ElementUtils.getAnnotationValue(sharedAnnotation, "value");
        }
        return null;
    }

    public String getSharedGroup() {
        AnnotationMirror sharedAnnotation = this.getSharedGroupMirror();
        if (sharedAnnotation != null) {
            return ElementUtils.getAnnotationValue(String.class, sharedAnnotation, "value");
        }
        return null;
    }

    public void setDefaultExpression(DSLExpression expression) {
        this.defaultExpression = expression;
    }

    public void setUncachedExpressionError(MessageContainer.Message message) {
        this.uncachedExpressionError = message;
    }

    public void setUncachedExpression(DSLExpression getUncachedExpression) {
        this.uncachedExpression = getUncachedExpression;
    }

    public MessageContainer.Message getUncachedExpresionError() {
        return this.uncachedExpressionError;
    }

    public DSLExpression getUncachedExpression() {
        return this.uncachedExpression;
    }

    public void setAlwaysInitialized(boolean fastPathCache) {
        this.alwaysInitialized = fastPathCache;
    }

    public boolean isAlwaysInitialized() {
        return this.alwaysInitialized;
    }

    public void setDimensions(int dimensions) {
        this.dimensions = dimensions;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public Parameter getParameter() {
        return this.sourceParameter;
    }

    public boolean isCached() {
        return this.isType(Cached.class);
    }

    public boolean isCachedLibrary() {
        return this.isType(CachedLibrary.class);
    }

    public boolean isCachedContext() {
        return this.isType(CachedContext.class);
    }

    public boolean isCachedLanguage() {
        return this.isType(CachedLanguage.class);
    }

    private boolean isType(Class<?> type) {
        return ElementUtils.typeEquals(this.sourceAnnotationMirror.getAnnotationType(), ProcessorContext.getInstance().getType(type));
    }

    @Override
    public Element getMessageElement() {
        return this.sourceParameter.getVariableElement();
    }

    @Override
    public AnnotationMirror getMessageAnnotation() {
        return this.sourceAnnotationMirror;
    }

    public void setRequiresBoundary(boolean requiresBoundary) {
        this.requiresBoundary = requiresBoundary;
    }

    public boolean isRequiresBoundary() {
        return this.requiresBoundary;
    }

    public DSLExpression getDefaultExpression() {
        return this.defaultExpression;
    }

    public void setMergedLibrary(boolean mergedLibrary) {
        this.mergedLibrary = mergedLibrary;
    }

    public boolean isMergedLibrary() {
        return this.mergedLibrary;
    }

    public String getMergedLibraryIdentifier() {
        String libraryName = ElementUtils.getSimpleName(this.getParameter().getType());
        DSLExpression identifierExpression = this.getDefaultExpression().reduce(new DSLExpression.DSLExpressionReducer(){

            @Override
            public DSLExpression visitVariable(DSLExpression.Variable binary) {
                if (binary.getReceiver() == null) {
                    DSLExpression.Variable var = new DSLExpression.Variable(binary.getReceiver(), "receiver");
                    var.setResolvedTargetType(binary.getResolvedTargetType());
                    var.setResolvedVariable(new CodeVariableElement(binary.getResolvedType(), "receiver"));
                    return var;
                }
                return binary;
            }

            @Override
            public DSLExpression visitNegate(DSLExpression.Negate negate) {
                return negate;
            }

            @Override
            public DSLExpression visitCall(DSLExpression.Call binary) {
                return binary;
            }

            @Override
            public DSLExpression visitBinary(DSLExpression.Binary binary) {
                return binary;
            }
        });
        String expressionText = identifierExpression.asString();
        StringBuilder b = new StringBuilder(expressionText);
        for (int i = 0; i < b.length(); ++i) {
            char charAt = b.charAt(i);
            if (i == 46) {
                b.setCharAt(i, '_');
                continue;
            }
            if (Character.isJavaIdentifierPart(charAt)) continue;
            b.deleteCharAt(i);
        }
        return b.toString() + libraryName;
    }
}

