/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.model;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.model.ExecutableTypeData;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.model.NodeExecutionData;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeMirror;

public class NodeChildData
extends MessageContainer {
    private final Element sourceElement;
    private final AnnotationMirror sourceAnnotationMirror;
    private final String name;
    private final TypeMirror type;
    private final TypeMirror originalType;
    private final Element accessElement;
    private final Cardinality cardinality;
    private final AnnotationValue executeWithValue;
    private List<NodeExecutionData> executeWith = Collections.emptyList();
    private NodeData childNode;

    public NodeChildData(Element sourceElement, AnnotationMirror sourceMirror, String name, TypeMirror nodeType, TypeMirror originalNodeType, Element accessElement, Cardinality cardinality, AnnotationValue executeWithValue) {
        this.sourceElement = sourceElement;
        this.sourceAnnotationMirror = sourceMirror;
        this.name = name;
        this.type = nodeType;
        this.originalType = originalNodeType;
        this.accessElement = accessElement;
        this.cardinality = cardinality;
        this.executeWithValue = executeWithValue;
    }

    public boolean needsGeneratedField() {
        return this.accessElement == null || this.accessElement.getKind() != ElementKind.FIELD;
    }

    public AnnotationValue getExecuteWithValue() {
        return this.executeWithValue;
    }

    public List<NodeExecutionData> getExecuteWith() {
        return this.executeWith;
    }

    public void setExecuteWith(List<NodeExecutionData> executeWith) {
        this.executeWith = executeWith;
    }

    public ExecutableTypeData findExecutableType(TypeMirror targetType) {
        return this.childNode.findExecutableType(targetType, this.getExecuteWith().size());
    }

    public List<ExecutableTypeData> findGenericExecutableTypes(ProcessorContext context) {
        return this.childNode.findGenericExecutableTypes(context, this.getExecuteWith().size());
    }

    public ExecutableTypeData findAnyGenericExecutableType(ProcessorContext context) {
        return this.childNode.findAnyGenericExecutableType(context, this.getExecuteWith().size());
    }

    public TypeMirror getOriginalType() {
        return this.originalType;
    }

    @Override
    public Element getMessageElement() {
        return this.sourceElement;
    }

    @Override
    public AnnotationMirror getMessageAnnotation() {
        return this.sourceAnnotationMirror;
    }

    public void setNode(NodeData nodeData) {
        this.childNode = nodeData;
        if (nodeData != null) {
            this.getMessages().addAll(nodeData.collectMessages());
        }
    }

    public Element getAccessElement() {
        return this.accessElement;
    }

    public TypeMirror getNodeType() {
        return this.type;
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    public NodeData getNodeData() {
        return this.childNode;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "NodeFieldData[name=" + this.getName() + ", kind=" + (Object)((Object)this.cardinality) + ", node=" + this.getNodeData() + "]";
    }

    public static enum Cardinality {
        ONE,
        MANY;


        public boolean isMany() {
            return this == MANY;
        }

        public boolean isOne() {
            return this == ONE;
        }
    }
}

