/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.parser;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.MethodSpec;
import com.oracle.truffle.dsl.processor.model.Template;
import com.oracle.truffle.dsl.processor.model.TemplateMethod;
import com.oracle.truffle.dsl.processor.parser.MethodSpecParser;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public abstract class TemplateMethodParser<T extends Template, E extends TemplateMethod> {
    protected final T template;
    private final ProcessorContext context;
    private final MethodSpecParser parser;

    public TemplateMethodParser(ProcessorContext context, T template) {
        this.template = template;
        this.context = context;
        this.parser = new MethodSpecParser((Template)template);
    }

    protected final ProcessorContext getContext() {
        return this.context;
    }

    public abstract MethodSpec createSpecification(ExecutableElement var1, AnnotationMirror var2);

    public abstract E create(TemplateMethod var1, boolean var2);

    public abstract boolean isParsable(ExecutableElement var1);

    public Class<? extends Annotation> getAnnotationType() {
        return null;
    }

    public final List<E> parse(List<? extends Element> elements) {
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        methods.addAll(ElementFilter.methodsIn(elements));
        ArrayList<E> parsedMethods = new ArrayList<E>();
        int naturalOrder = 0;
        for (ExecutableElement method : methods) {
            if (!this.isParsable(method)) continue;
            Class<Annotation> annotationType = this.getAnnotationType();
            AnnotationMirror mirror = null;
            if (annotationType != null) {
                mirror = ElementUtils.findAnnotationMirror(this.getContext().getEnvironment(), method, annotationType);
            }
            E parsedMethod = this.parse(naturalOrder, method, mirror);
            if (method.getModifiers().contains((Object)Modifier.PRIVATE) && this.parser.isEmitErrors()) {
                ((MessageContainer)parsedMethod).addError("Method annotated with @%s must not be private.", this.getAnnotationType().getSimpleName());
                parsedMethods.add(parsedMethod);
                continue;
            }
            if (parsedMethod != null) {
                parsedMethods.add(parsedMethod);
            }
            ++naturalOrder;
        }
        Collections.sort(parsedMethods);
        return parsedMethods;
    }

    private E parse(int naturalOrder, ExecutableElement method, AnnotationMirror annotation) {
        MethodSpec methodSpecification = this.createSpecification(method, annotation);
        if (methodSpecification == null) {
            return null;
        }
        TemplateMethod templateMethod = this.parser.parse(methodSpecification, method, annotation, naturalOrder);
        if (templateMethod != null) {
            return this.create(templateMethod, templateMethod.hasErrors());
        }
        return null;
    }

    public final E create(String id, int naturalOrder, ExecutableElement methodMetadata, AnnotationMirror mirror, TypeMirror returnType, List<VariableElement> parameterTypes) {
        TemplateMethod method = this.parser.parseImpl(this.createSpecification(methodMetadata, mirror), naturalOrder, id, methodMetadata, mirror, returnType, parameterTypes);
        if (method != null) {
            return this.create(method, method.hasErrors());
        }
        return null;
    }
}

