/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.parser;

import com.oracle.truffle.api.dsl.TypeCast;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.model.MethodSpec;
import com.oracle.truffle.dsl.processor.model.ParameterSpec;
import com.oracle.truffle.dsl.processor.model.TemplateMethod;
import com.oracle.truffle.dsl.processor.model.TypeCastData;
import com.oracle.truffle.dsl.processor.model.TypeSystemData;
import com.oracle.truffle.dsl.processor.parser.TypeSystemMethodParser;
import java.lang.annotation.Annotation;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

class TypeCastParser
extends TypeSystemMethodParser<TypeCastData> {
    TypeCastParser(ProcessorContext context, TypeSystemData typeSystem) {
        super(context, typeSystem);
    }

    @Override
    public MethodSpec createSpecification(ExecutableElement method, AnnotationMirror mirror) {
        TypeMirror targetTypeMirror = ElementUtils.getAnnotationValue(TypeMirror.class, mirror, "value");
        ParameterSpec returnTypeSpec = new ParameterSpec("returnType", targetTypeMirror);
        returnTypeSpec.setAllowSubclasses(false);
        MethodSpec spec = new MethodSpec(returnTypeSpec);
        spec.addRequired(new ParameterSpec("value", this.getContext().getType(Object.class)));
        return spec;
    }

    @Override
    public TypeCastData create(TemplateMethod method, boolean invalid) {
        TypeMirror targetType = this.resolveCastOrCheck(method);
        TypeMirror sourceType = this.getContext().getType(Object.class);
        return new TypeCastData(method, sourceType, targetType);
    }

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return TypeCast.class;
    }
}

