/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.parser;

import com.oracle.truffle.api.dsl.TypeCheck;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.model.MethodSpec;
import com.oracle.truffle.dsl.processor.model.ParameterSpec;
import com.oracle.truffle.dsl.processor.model.TemplateMethod;
import com.oracle.truffle.dsl.processor.model.TypeCheckData;
import com.oracle.truffle.dsl.processor.model.TypeSystemData;
import com.oracle.truffle.dsl.processor.parser.TypeSystemMethodParser;
import java.lang.annotation.Annotation;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

class TypeCheckParser
extends TypeSystemMethodParser<TypeCheckData> {
    TypeCheckParser(ProcessorContext context, TypeSystemData typeSystem) {
        super(context, typeSystem);
    }

    @Override
    public MethodSpec createSpecification(ExecutableElement method, AnnotationMirror mirror) {
        MethodSpec spec = new MethodSpec(new ParameterSpec("returnType", this.getContext().getType(Boolean.TYPE)));
        spec.addRequired(new ParameterSpec("value", this.getContext().getType(Object.class)));
        return spec;
    }

    @Override
    public TypeCheckData create(TemplateMethod method, boolean invalid) {
        TypeMirror targetType = this.resolveCastOrCheck(method);
        return new TypeCheckData(method, targetType, targetType);
    }

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return TypeCheck.class;
    }
}

