/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.parser;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.model.TemplateMethod;
import com.oracle.truffle.dsl.processor.model.TypeSystemData;
import com.oracle.truffle.dsl.processor.parser.TemplateMethodParser;
import java.lang.annotation.Annotation;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

abstract class TypeSystemMethodParser<E extends TemplateMethod>
extends TemplateMethodParser<TypeSystemData, E> {
    TypeSystemMethodParser(ProcessorContext context, TypeSystemData typeSystem) {
        super(context, typeSystem);
    }

    @Override
    public final boolean isParsable(ExecutableElement method) {
        return ElementUtils.findAnnotationMirror(this.getContext().getEnvironment(), method, this.getAnnotationType()) != null;
    }

    protected final TypeMirror resolveCastOrCheck(TemplateMethod method) {
        Class<Annotation> annotationType = this.getAnnotationType();
        TypeMirror targetTypeMirror = ElementUtils.getAnnotationValue(TypeMirror.class, method.getMessageAnnotation(), "value");
        if (!method.getMethod().getModifiers().contains((Object)Modifier.PUBLIC) || !method.getMethod().getModifiers().contains((Object)Modifier.STATIC)) {
            method.addError("@%s annotated method %s must be public and static.", annotationType.getSimpleName(), method.getMethodName());
        }
        return targetTypeMirror;
    }
}

