/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.verify;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.dsl.processor.ExpectError;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.oracle.truffle.api.CompilerDirectives.TruffleBoundary", "com.oracle.truffle.api.nodes.Node.Child"})
public class VerifyTruffleProcessor
extends AbstractProcessor {
    private Element scope;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    public static boolean isEnclosedIn(Element e, Element scopeElement) {
        List<Element> elementHierarchy = ElementUtils.getElementHierarchy(e);
        return elementHierarchy.contains(scopeElement);
    }

    void errorMessage(Element element, String format, Object ... args) {
        this.message(Diagnostic.Kind.ERROR, element, format, args);
    }

    void message(Diagnostic.Kind kind, Element element, String format, Object ... args) {
        if (this.scope != null && !VerifyTruffleProcessor.isEnclosedIn(element, this.scope)) {
            List<Element> elementHierarchy = ElementUtils.getElementHierarchy(element);
            Collections.reverse(elementHierarchy);
            StringBuilder str = new StringBuilder();
            for (Element e : elementHierarchy) {
                if (e.getKind() == ElementKind.PACKAGE) continue;
                str.append(str.length() == 0 ? "" : ".");
                str.append(e);
            }
            this.processingEnv.getMessager().printMessage(kind, String.format(str + ": " + format, args), this.scope);
        } else {
            this.processingEnv.getMessager().printMessage(kind, String.format(format, args), element);
        }
    }

    private void reportException(Diagnostic.Kind kind, Element element, Throwable t) {
        StringWriter buf = new StringWriter();
        t.printStackTrace(new PrintWriter(buf));
        this.message(kind, element, "Exception thrown during processing: %s", buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        TypeElement virtualFrameType = ElementUtils.getTypeElement(this.processingEnv, "com.oracle.truffle.api.frame.VirtualFrame");
        Iterator<? extends Element> iterator = roundEnv.getElementsAnnotatedWith(CompilerDirectives.TruffleBoundary.class).iterator();
        while (iterator.hasNext()) {
            Element element;
            this.scope = element = iterator.next();
            try {
                if (element.getKind() != ElementKind.CONSTRUCTOR && element.getKind() != ElementKind.METHOD) continue;
                ExecutableElement method = (ExecutableElement)element;
                for (VariableElement variableElement : method.getParameters()) {
                    Element paramType = this.processingEnv.getTypeUtils().asElement(variableElement.asType());
                    if (paramType == null || !paramType.equals(virtualFrameType)) continue;
                    this.errorMessage(element, "Method %s cannot be annotated with @%s and have a parameter of type %s", method.getSimpleName(), CompilerDirectives.TruffleBoundary.class.getSimpleName(), paramType.getSimpleName());
                }
            }
            catch (Throwable t) {
                this.reportException(VerifyTruffleProcessor.isBug367599(t) ? Diagnostic.Kind.NOTE : Diagnostic.Kind.ERROR, element, t);
            }
            finally {
                this.scope = null;
            }
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Node.Child.class)) {
            if (element.getModifiers().contains((Object)Modifier.FINAL)) {
                this.emitError("@Child field cannot be final", element);
                continue;
            }
            if (element.getAnnotation(Executed.class) != null) continue;
            this.assertNoErrorExpected(element);
        }
        return false;
    }

    void assertNoErrorExpected(Element element) {
        ExpectError.assertNoErrorExpected(this.processingEnv, element);
    }

    void emitError(String message, Element element) {
        if (ExpectError.isExpectedError(this.processingEnv, element, message)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    public static boolean isBug367599(Throwable t) {
        if (t instanceof FilerException) {
            for (StackTraceElement ste : t.getStackTrace()) {
                if (!ste.toString().contains("org.eclipse.jdt.internal.apt.pluggable.core.filer.IdeFilerImpl.create")) continue;
                return true;
            }
        }
        if (t.getCause() != null) {
            return VerifyTruffleProcessor.isBug367599(t.getCause());
        }
        return false;
    }
}

