/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.model;

import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeElementScanner;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeKind;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class CodeTreeBuilder {
    private BuilderCodeTree currentElement;
    private final BuilderCodeTree root;
    private int treeCount;
    private Element enclosingElement;

    public CodeTreeBuilder(CodeTreeBuilder parent) {
        this.currentElement = this.root = new BuilderCodeTree(null, CodeTreeKind.GROUP, null, null);
        if (parent != null) {
            this.enclosingElement = parent.enclosingElement;
        }
    }

    public void setEnclosingElement(Element enclosingElement) {
        this.enclosingElement = enclosingElement;
    }

    public String toString() {
        return this.root.toString();
    }

    public int getTreeCount() {
        return this.treeCount;
    }

    public boolean isEmpty() {
        return this.treeCount == 0;
    }

    public CodeTreeBuilder startJavadoc() {
        this.push(CodeTreeKind.JAVA_DOC);
        return this;
    }

    public CodeTreeBuilder javadocLink(Element element, String title) {
        this.string("{@link ");
        if (element.getKind().isClass() || element.getKind().isInterface()) {
            this.type(element.asType());
        } else if (element.getKind() == ElementKind.METHOD) {
            ExecutableElement e = (ExecutableElement)element;
            this.type(e.getEnclosingElement().asType());
            this.string("#");
            this.string(e.getSimpleName().toString());
            this.string("(");
            String sep = "";
            for (VariableElement variableElement : e.getParameters()) {
                this.string(sep);
                this.type(variableElement.asType());
                sep = ", ";
            }
            this.string(")");
        } else {
            throw new UnsupportedOperationException();
        }
        if (title != null && !title.isEmpty()) {
            this.string(" ", title);
        }
        this.string("}");
        return this;
    }

    public CodeTreeBuilder startDoc() {
        this.push(CodeTreeKind.DOC);
        return this;
    }

    public CodeTreeBuilder statement(String statement) {
        return this.startStatement().string(statement).end();
    }

    public CodeTreeBuilder statement(CodeTree statement) {
        return this.startStatement().tree(statement).end();
    }

    public static CodeTreeBuilder createBuilder() {
        return new CodeTreeBuilder(null);
    }

    public static CodeTree singleString(String s) {
        return CodeTreeBuilder.createBuilder().string(s).build();
    }

    public static CodeTree singleType(TypeMirror s) {
        return CodeTreeBuilder.createBuilder().type(s).build();
    }

    private CodeTreeBuilder push(CodeTreeKind kind) {
        return this.push(new BuilderCodeTree(this.currentElement, kind, null, null), kind == CodeTreeKind.NEW_LINE);
    }

    private CodeTreeBuilder push(String string) {
        return this.push(new BuilderCodeTree(this.currentElement, CodeTreeKind.STRING, null, string), false);
    }

    private CodeTreeBuilder push(TypeMirror type, boolean literal) {
        return this.push(new BuilderCodeTree(this.currentElement, literal ? CodeTreeKind.TYPE_LITERAL : CodeTreeKind.TYPE, type, null), false);
    }

    private CodeTreeBuilder push(CodeTreeKind kind, TypeMirror type, String string) {
        return this.push(new BuilderCodeTree(this.currentElement, kind, type, string), kind == CodeTreeKind.NEW_LINE);
    }

    private CodeTreeBuilder push(BuilderCodeTree tree, boolean removeLast) {
        if (this.currentElement != null) {
            if (removeLast && !this.removeLastIfEnqueued(tree)) {
                return this;
            }
            this.currentElement.add(tree);
        }
        switch (tree.getCodeKind()) {
            case COMMA_GROUP: 
            case GROUP: 
            case JAVA_DOC: 
            case DOC: 
            case INDENT: {
                this.currentElement = tree;
            }
        }
        ++this.treeCount;
        return this;
    }

    private boolean removeLastIfEnqueued(BuilderCodeTree tree) {
        CodeTree last;
        if (tree.getCodeKind() == CodeTreeKind.REMOVE_LAST) {
            return !this.clearLastRec(tree.removeLast, this.currentElement.getEnclosedElements());
        }
        List<CodeTree> childTree = tree.getEnclosedElements();
        if (childTree != null && !childTree.isEmpty() && (last = childTree.get(0)) instanceof BuilderCodeTree && !this.removeLastIfEnqueued((BuilderCodeTree)last)) {
            childTree.remove(0);
        }
        return true;
    }

    private void clearLast(CodeTreeKind kind) {
        if (this.clearLastRec(kind, this.currentElement.getEnclosedElements())) {
            --this.treeCount;
        } else {
            BuilderCodeTree tree = new BuilderCodeTree(this.currentElement, CodeTreeKind.REMOVE_LAST, null, null);
            tree.removeLast = kind;
            this.push(tree, false);
        }
    }

    public CodeTreeBuilder startStatement() {
        this.startGroup();
        this.registerCallBack(new EndCallback(){

            @Override
            public void beforeEnd() {
                CodeTreeBuilder.this.string(";").newLine();
            }

            @Override
            public void afterEnd() {
            }
        });
        return this;
    }

    public CodeTreeBuilder startGroup() {
        return this.push(CodeTreeKind.GROUP);
    }

    public CodeTreeBuilder startCommaGroup() {
        return this.push(CodeTreeKind.COMMA_GROUP);
    }

    public CodeTreeBuilder startCall(String callSite) {
        return this.startCall((CodeTree)null, callSite);
    }

    public CodeTreeBuilder startCall(String receiver, ExecutableElement method) {
        if (receiver == null && method.getModifiers().contains((Object)Modifier.STATIC)) {
            return this.startStaticCall(method.getEnclosingElement().asType(), method.getSimpleName().toString());
        }
        return this.startCall(receiver, method.getSimpleName().toString());
    }

    public CodeTreeBuilder startCall(String receiver, String callSite) {
        if (receiver != null) {
            return this.startCall(CodeTreeBuilder.singleString(receiver), callSite);
        }
        return this.startCall(callSite);
    }

    public CodeTreeBuilder startCall(CodeTree receiver, String callSite) {
        if (receiver == null) {
            return this.startGroup().string(callSite).startParanthesesCommaGroup().endAfter();
        }
        return this.startGroup().tree(receiver).string(".").string(callSite).startParanthesesCommaGroup().endAfter();
    }

    public CodeTreeBuilder startStaticCall(TypeMirror type, String methodName) {
        return this.startGroup().push(CodeTreeKind.STATIC_METHOD_REFERENCE, type, methodName).startParanthesesCommaGroup().endAfter();
    }

    public CodeTreeBuilder startStaticCall(ExecutableElement method) {
        TypeElement parentType = ElementUtils.findNearestEnclosingType(method).orElseThrow(AssertionError::new);
        return this.startStaticCall(parentType.asType(), method.getSimpleName().toString());
    }

    public CodeTreeBuilder staticReference(TypeMirror type, String fieldName) {
        return this.push(CodeTreeKind.STATIC_FIELD_REFERENCE, type, fieldName);
    }

    public CodeTreeBuilder staticReference(VariableElement field) {
        if (field.getEnclosingElement() == null) {
            return this.string(field.getSimpleName().toString());
        }
        return this.staticReference(field.getEnclosingElement().asType(), field.getSimpleName().toString());
    }

    private CodeTreeBuilder endAndWhitespaceAfter() {
        this.registerCallBack(new EndCallback(){

            @Override
            public void beforeEnd() {
            }

            @Override
            public void afterEnd() {
                CodeTreeBuilder.this.string(" ");
                CodeTreeBuilder.this.end();
            }
        });
        return this;
    }

    private CodeTreeBuilder endAfter() {
        this.registerCallBack(new EndCallback(){

            @Override
            public void beforeEnd() {
            }

            @Override
            public void afterEnd() {
                CodeTreeBuilder.this.end();
            }
        });
        return this;
    }

    private CodeTreeBuilder startParanthesesCommaGroup() {
        this.startGroup();
        this.string("(").startCommaGroup();
        this.registerCallBack(new EndCallback(){

            @Override
            public void beforeEnd() {
            }

            @Override
            public void afterEnd() {
                CodeTreeBuilder.this.string(")");
            }
        });
        this.endAfter();
        return this;
    }

    private CodeTreeBuilder startCurlyBracesCommaGroup() {
        this.startGroup();
        this.string("{").startCommaGroup();
        this.registerCallBack(new EndCallback(){

            @Override
            public void beforeEnd() {
            }

            @Override
            public void afterEnd() {
                CodeTreeBuilder.this.string("}");
            }
        });
        this.endAfter();
        return this;
    }

    public CodeTreeBuilder startParantheses() {
        this.startGroup();
        this.string("(").startGroup();
        this.registerCallBack(new EndCallback(){

            @Override
            public void beforeEnd() {
            }

            @Override
            public void afterEnd() {
                CodeTreeBuilder.this.string(")");
            }
        });
        this.endAfter();
        return this;
    }

    public CodeTreeBuilder doubleQuote(String s) {
        return this.startGroup().string("\"" + s + "\"").end();
    }

    public CodeTreeBuilder string(String chunk1) {
        return this.push(chunk1);
    }

    public CodeTreeBuilder string(String chunk1, String chunk2) {
        return this.push(CodeTreeKind.GROUP).string(chunk1).string(chunk2).end();
    }

    public CodeTreeBuilder string(String chunk1, String chunk2, String chunk3) {
        return this.push(CodeTreeKind.GROUP).string(chunk1).string(chunk2).string(chunk3).end();
    }

    public CodeTreeBuilder string(String chunk1, String chunk2, String chunk3, String chunk4) {
        return this.push(CodeTreeKind.GROUP).string(chunk1).string(chunk2).string(chunk3).string(chunk4).end();
    }

    public CodeTreeBuilder tree(CodeTree treeToAdd) {
        if (treeToAdd != null) {
            if (treeToAdd instanceof BuilderCodeTree) {
                return this.push((BuilderCodeTree)treeToAdd, true).end();
            }
            BuilderCodeTree tree = new BuilderCodeTree(this.currentElement, CodeTreeKind.GROUP, null, null);
            this.currentElement.add(treeToAdd);
            return this.push(tree, true).end();
        }
        return this;
    }

    public CodeTreeBuilder trees(CodeTree ... trees) {
        for (CodeTree tree : trees) {
            if (tree == null) continue;
            this.tree(tree);
        }
        return this;
    }

    public CodeTreeBuilder string(String chunk1, String chunk2, String chunk3, String chunk4, String ... chunks) {
        this.push(CodeTreeKind.GROUP).string(chunk1).string(chunk2).string(chunk3).string(chunk4);
        for (int i = 0; i < chunks.length; ++i) {
            this.string(chunks[i]);
        }
        return this.end();
    }

    public CodeTreeBuilder newLine() {
        return this.push(CodeTreeKind.NEW_LINE);
    }

    public CodeTreeBuilder startWhile() {
        return this.startGroup().string("while ").startParanthesesCommaGroup().endAndWhitespaceAfter().startGroup().endAfter();
    }

    public CodeTreeBuilder startDoBlock() {
        return this.startGroup().string("do ").startBlock();
    }

    public CodeTreeBuilder startDoWhile() {
        this.clearLast(CodeTreeKind.NEW_LINE);
        return this.startStatement().string(" while ").startParanthesesCommaGroup().endAfter().startGroup().endAfter();
    }

    public CodeTreeBuilder startIf() {
        return this.startGroup().string("if ").startParanthesesCommaGroup().endAndWhitespaceAfter().startGroup().endAfter();
    }

    public CodeTreeBuilder startFor() {
        return this.startGroup().string("for ").startParantheses().endAndWhitespaceAfter().startGroup().endAfter();
    }

    public boolean startIf(boolean elseIf) {
        if (elseIf) {
            this.startElseIf();
        } else {
            this.startIf();
        }
        return true;
    }

    public CodeTreeBuilder startElseIf() {
        this.clearLast(CodeTreeKind.NEW_LINE);
        return this.startGroup().string(" else if ").startParanthesesCommaGroup().endAndWhitespaceAfter().startGroup().endAfter();
    }

    public CodeTreeBuilder startElseBlock() {
        this.clearLast(CodeTreeKind.NEW_LINE);
        return this.startGroup().string(" else ").startBlock().endAfter();
    }

    private boolean clearLastRec(CodeTreeKind kind, List<CodeTree> children) {
        if (children == null) {
            return false;
        }
        for (int i = children.size() - 1; i >= 0; --i) {
            CodeTree child = children.get(i);
            if (child.getCodeKind() == kind) {
                children.remove(children.get(i));
                return true;
            }
            if (!this.clearLastRec(kind, child.getEnclosedElements())) continue;
            return true;
        }
        return false;
    }

    public CodeTreeBuilder startCase() {
        this.startGroup().string("case ");
        this.registerCallBack(new EndCallback(){

            @Override
            public void beforeEnd() {
                CodeTreeBuilder.this.string(" :").newLine();
            }

            @Override
            public void afterEnd() {
            }
        });
        return this;
    }

    public CodeTreeBuilder caseDefault() {
        return this.startGroup().string("default :").newLine().end();
    }

    public CodeTreeBuilder startSwitch() {
        return this.startGroup().string("switch ").startParantheses().endAndWhitespaceAfter();
    }

    public CodeTreeBuilder startReturn() {
        ExecutableElement method = this.findMethod();
        if (method != null && ElementUtils.isVoid(method.getReturnType())) {
            this.startGroup();
            this.registerCallBack(new EndCallback(){

                @Override
                public void beforeEnd() {
                    CodeTreeBuilder.this.string(";").newLine();
                }

                @Override
                public void afterEnd() {
                    CodeTreeBuilder.this.string("return").string(";").newLine();
                }
            });
            return this;
        }
        return this.startStatement().string("return ");
    }

    public CodeTreeBuilder startAssert() {
        return this.startStatement().string("assert ");
    }

    public CodeTreeBuilder startNewArray(ArrayType arrayType, CodeTree size) {
        this.startGroup().string("new ").type(arrayType.getComponentType()).string("[");
        if (size != null) {
            this.tree(size);
        }
        this.string("]");
        if (size == null) {
            this.string(" ");
            this.startCurlyBracesCommaGroup().endAfter();
        }
        return this;
    }

    public CodeTreeBuilder lineComment(String text) {
        return this.string("// ").string(text).newLine();
    }

    public CodeTreeBuilder startNew(TypeMirror uninializedNodeClass) {
        return this.startGroup().string("new ").type(uninializedNodeClass).startParanthesesCommaGroup().endAfter();
    }

    public CodeTreeBuilder startNew(String typeName) {
        return this.startGroup().string("new ").string(typeName).startParanthesesCommaGroup().endAfter();
    }

    public CodeTreeBuilder startIndention() {
        return this.push(CodeTreeKind.INDENT);
    }

    public CodeTreeBuilder end(int times) {
        for (int i = 0; i < times; ++i) {
            this.end();
        }
        return this;
    }

    public CodeTreeBuilder end() {
        BuilderCodeTree tree = this.currentElement;
        EndCallback callback = tree.getAtEndListener();
        if (callback != null) {
            callback.beforeEnd();
            this.toParent();
            callback.afterEnd();
        } else {
            this.toParent();
        }
        return this;
    }

    private void toParent() {
        CodeTree parentElement = this.currentElement.getParent();
        this.currentElement = this.currentElement != this.root ? (BuilderCodeTree)parentElement : this.root;
    }

    public CodeTreeBuilder startBlock() {
        this.startGroup();
        this.string("{").newLine().startIndention();
        this.registerCallBack(new EndCallback(){

            @Override
            public void beforeEnd() {
            }

            @Override
            public void afterEnd() {
                CodeTreeBuilder.this.string("}").newLine();
            }
        });
        this.endAfter();
        return this;
    }

    public CodeTreeBuilder startSynchronized(String object) {
        return this.startSynchronized(CodeTreeBuilder.singleString(object));
    }

    public CodeTreeBuilder startSynchronized(CodeTree object) {
        return this.string("synchronized").startParantheses().tree(object).end().startBlock();
    }

    private void registerCallBack(EndCallback callback) {
        this.currentElement.registerAtEnd(callback);
    }

    public CodeTreeBuilder defaultDeclaration(TypeMirror type, String name) {
        if (!ElementUtils.isVoid(type)) {
            this.startStatement();
            this.type(type);
            this.string(" ");
            this.string(name);
            this.string(" = ");
            this.defaultValue(type);
            this.end();
        }
        return this;
    }

    public CodeTreeBuilder declaration(TypeMirror type, String name, String init) {
        return this.declaration(type, name, CodeTreeBuilder.singleString(init));
    }

    public CodeTreeBuilder declaration(String type, String name, CodeTree init) {
        this.startStatement();
        this.string(type);
        this.string(" ");
        this.string(name);
        if (init != null) {
            this.string(" = ");
            this.tree(init);
        }
        this.end();
        return this;
    }

    public CodeTreeBuilder declaration(String type, String name, String init) {
        return this.declaration(type, name, CodeTreeBuilder.singleString(init));
    }

    public CodeTreeBuilder declaration(TypeMirror type, String name, CodeTree init) {
        if (ElementUtils.isVoid(type)) {
            this.startStatement();
            this.tree(init);
            this.end();
        } else {
            this.startStatement();
            this.type(type);
            this.string(" ");
            this.string(name);
            if (init != null) {
                this.string(" = ");
                this.tree(init);
            }
            this.end();
        }
        return this;
    }

    public CodeTreeBuilder declaration(TypeMirror type, String name, CodeTreeBuilder init) {
        if (init == this) {
            throw new IllegalArgumentException("Recursive builder usage.");
        }
        return this.declaration(type, name, init.getTree());
    }

    public CodeTreeBuilder create() {
        return new CodeTreeBuilder(this);
    }

    public CodeTreeBuilder type(TypeMirror type) {
        return this.push(type, false);
    }

    public CodeTreeBuilder typeLiteral(TypeMirror type) {
        return this.startGroup().push(type, true).end();
    }

    private void assertRoot() {
        if (this.currentElement != this.root) {
            throw new IllegalStateException("CodeTreeBuilder was not ended properly.");
        }
    }

    public CodeTreeBuilder startCaseBlock() {
        return this.startIndention();
    }

    public CodeTreeBuilder startThrow() {
        return this.startStatement().string("throw ");
    }

    public CodeTree getTree() {
        this.assertRoot();
        return this.root;
    }

    public CodeTree build() {
        return this.root;
    }

    public CodeTreeBuilder cast(TypeMirror type) {
        this.string("(").type(type).string(") ");
        return this;
    }

    public CodeTreeBuilder maybeCast(TypeMirror sourceType, TypeMirror targetType) {
        if (ElementUtils.needsCastTo(sourceType, targetType)) {
            this.cast(targetType);
        }
        return this;
    }

    public CodeTreeBuilder maybeCast(TypeMirror sourceType, TypeMirror targetType, String receiver) {
        if (ElementUtils.needsCastTo(sourceType, targetType)) {
            this.string("(");
            this.cast(targetType);
            this.string(receiver, ") ");
        } else {
            this.string(receiver);
        }
        return this;
    }

    public CodeTreeBuilder cast(TypeMirror type, CodeTree content) {
        if (ElementUtils.isVoid(type)) {
            this.tree(content);
            return this;
        }
        return this.startGroup().string("(").type(type).string(")").string(" ").tree(content).end();
    }

    public CodeTreeBuilder startSuperCall() {
        return this.string("super").startParanthesesCommaGroup();
    }

    public CodeTreeBuilder returnFalse() {
        return this.startReturn().string("false").end();
    }

    public CodeTreeBuilder returnStatement() {
        return this.statement("return");
    }

    public ExecutableElement findMethod() {
        if (this.enclosingElement != null && (this.enclosingElement.getKind() == ElementKind.METHOD || this.enclosingElement.getKind() == ElementKind.CONSTRUCTOR)) {
            return (ExecutableElement)this.enclosingElement;
        }
        return null;
    }

    public CodeTreeBuilder returnNull() {
        return this.startReturn().string("null").end();
    }

    public CodeTreeBuilder returnTrue() {
        return this.startReturn().string("true").end();
    }

    public CodeTreeBuilder instanceOf(CodeTree var, TypeMirror type) {
        return this.tree(var).string(" instanceof ").type(type);
    }

    public CodeTreeBuilder instanceOf(TypeMirror type) {
        return this.string(" instanceof ").type(type);
    }

    public CodeTreeBuilder defaultValue(TypeMirror mirror) {
        return this.string(ElementUtils.defaultValue(mirror));
    }

    public CodeTreeBuilder startTryBlock() {
        return this.string("try ").startBlock();
    }

    public CodeTreeBuilder startCatchBlock(TypeMirror exceptionType, String localVarName) {
        this.clearLast(CodeTreeKind.NEW_LINE);
        this.string(" catch (").type(exceptionType).string(" ").string(localVarName).string(") ");
        return this.startBlock();
    }

    public CodeTreeBuilder startCatchBlock(TypeMirror[] exceptionTypes, String localVarName) {
        this.clearLast(CodeTreeKind.NEW_LINE);
        this.string(" catch (");
        for (int i = 0; i < exceptionTypes.length; ++i) {
            if (i != 0) {
                this.string(" | ");
            }
            this.type(exceptionTypes[i]);
        }
        this.string(" ").string(localVarName).string(") ");
        return this.startBlock();
    }

    public CodeTreeBuilder startFinallyBlock() {
        this.clearLast(CodeTreeKind.NEW_LINE);
        this.string(" finally ");
        return this.startBlock();
    }

    public CodeTreeBuilder nullLiteral() {
        return this.string("null");
    }

    public CodeTreeBuilder returnDefault() {
        ExecutableElement method = this.findMethod();
        if (ElementUtils.isVoid(method.getReturnType())) {
            this.returnStatement();
        } else {
            this.startReturn().defaultValue(method.getReturnType()).end();
        }
        return this;
    }

    public CodeTreeBuilder startAssign(String receiver, VariableElement field) {
        return this.startStatement().field(receiver, field).string(" = ");
    }

    public CodeTreeBuilder field(String receiver, VariableElement field) {
        if (receiver == null && field.getModifiers().contains((Object)Modifier.STATIC)) {
            return this.staticReference(field);
        }
        return this.string(receiver, ".", field.getSimpleName().toString());
    }

    public CodeTreeBuilder constantLiteral(TypeMirror type, int index) {
        if (type.getKind() == TypeKind.BYTE) {
            return this.string("(byte) ", String.valueOf(index));
        }
        return null;
    }

    private static class Printer
    extends CodeElementScanner<Void, Void> {
        private int indent;
        private boolean newLine;
        private final String ln = System.lineSeparator();
        private final StringBuilder b;

        Printer(StringBuilder b) {
            this.b = b;
        }

        @Override
        public void visitTree(CodeTree e, Void p, Element enclosingElement) {
            switch (e.getCodeKind()) {
                case COMMA_GROUP: {
                    List<CodeTree> children = e.getEnclosedElements();
                    if (children == null) break;
                    for (int i = 0; i < children.size(); ++i) {
                        this.visitTree(children.get(i), p, enclosingElement);
                        if (i >= e.getEnclosedElements().size() - 1) continue;
                        this.b.append(", ");
                    }
                    break;
                }
                case GROUP: {
                    super.visitTree(e, p, enclosingElement);
                    break;
                }
                case INDENT: {
                    this.indent();
                    super.visitTree(e, p, enclosingElement);
                    this.dedent();
                    break;
                }
                case NEW_LINE: {
                    this.writeLn();
                    break;
                }
                case STRING: {
                    if (e.getString() != null) {
                        this.write(e.getString());
                        break;
                    }
                    this.write("null");
                    break;
                }
                case TYPE: {
                    this.write(ElementUtils.getSimpleName(e.getType()));
                    break;
                }
                case STATIC_METHOD_REFERENCE: {
                    this.write(ElementUtils.getSimpleName(e.getType()) + "." + e.getString());
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
        }

        private void indent() {
            ++this.indent;
        }

        private void dedent() {
            --this.indent;
        }

        private void writeLn() {
            this.write(this.ln);
            this.newLine = true;
        }

        private void write(String m) {
            if (this.newLine && m != this.ln) {
                this.writeIndent();
                this.newLine = false;
            }
            this.b.append(m);
        }

        private void writeIndent() {
            for (int i = 0; i < this.indent; ++i) {
                this.b.append("    ");
            }
        }
    }

    private static interface EndCallback {
        public void beforeEnd();

        public void afterEnd();
    }

    private static class BuilderCodeTree
    extends CodeTree {
        private EndCallback atEndListener;
        private CodeTreeKind removeLast;

        BuilderCodeTree(CodeTree parent, CodeTreeKind kind, TypeMirror type, String string) {
            super(parent, kind, type, string);
        }

        public void registerAtEnd(EndCallback atEnd) {
            this.atEndListener = this.atEndListener != null ? new CompoundCallback(this.atEndListener, atEnd) : atEnd;
        }

        public EndCallback getAtEndListener() {
            return this.atEndListener;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            new Printer(b).visitTree((CodeTree)this, null, null);
            return b.toString();
        }

        private static class CompoundCallback
        implements EndCallback {
            private final EndCallback callback1;
            private final EndCallback callback2;

            CompoundCallback(EndCallback callback1, EndCallback callback2) {
                this.callback1 = callback1;
                this.callback2 = callback2;
            }

            @Override
            public void afterEnd() {
                this.callback1.afterEnd();
                this.callback2.afterEnd();
            }

            @Override
            public void beforeEnd() {
                this.callback1.beforeEnd();
                this.callback1.beforeEnd();
            }
        }
    }
}

