/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.parser;

import com.oracle.truffle.dsl.processor.CompileErrorException;
import com.oracle.truffle.dsl.processor.Log;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.library.LibraryData;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.NodeData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.tools.Diagnostic;

public abstract class AbstractParser<M extends MessageContainer> {
    protected final ProcessorContext context;
    protected final ProcessingEnvironment processingEnv;
    protected final TruffleTypes types = ProcessorContext.getInstance().getTypes();
    protected final Log log;

    public AbstractParser() {
        this.context = ProcessorContext.getInstance();
        this.processingEnv = this.context.getEnvironment();
        this.log = this.context.getLog();
    }

    public final M parse(Element element, boolean emitErrors) {
        MessageContainer model = null;
        try {
            List<AnnotationMirror> mirrors = null;
            if (this.getAnnotationType() != null) {
                mirrors = ElementUtils.getRepeatedAnnotation(element.getAnnotationMirrors(), this.getAnnotationType());
            }
            if ((model = (MessageContainer)this.parse(element, mirrors)) == null) {
                return null;
            }
            if (emitErrors) {
                model.emitMessages(this.context, this.log);
            }
            if (model instanceof NodeData || model instanceof LibraryData) {
                return (M)model;
            }
            return (M)(emitErrors ? this.filterErrorElements(model) : model);
        }
        catch (CompileErrorException e) {
            this.log.message(Diagnostic.Kind.WARNING, element, null, null, "The truffle processor could not parse class due to error: %s", e.getMessage());
            return null;
        }
    }

    public final M parse(Element element) {
        return this.parse(element, true);
    }

    protected M filterErrorElements(M model) {
        return ((MessageContainer)model).hasErrors() ? null : (M)model;
    }

    protected abstract M parse(Element var1, List<AnnotationMirror> var2);

    public abstract DeclaredType getAnnotationType();

    public DeclaredType getRepeatAnnotationType() {
        return null;
    }

    public boolean isDelegateToRootDeclaredType() {
        return false;
    }

    public List<DeclaredType> getAllAnnotationTypes() {
        ArrayList<DeclaredType> list = new ArrayList<DeclaredType>();
        if (this.getAnnotationType() != null) {
            list.add(this.getAnnotationType());
        }
        list.addAll(this.getTypeDelegatedAnnotationTypes());
        return list;
    }

    public List<DeclaredType> getTypeDelegatedAnnotationTypes() {
        return Collections.emptyList();
    }
}

