/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object.dsl.processor;

import com.oracle.truffle.object.dsl.processor.model.LayoutModel;
import com.oracle.truffle.object.dsl.processor.model.NameUtils;
import com.oracle.truffle.object.dsl.processor.model.PropertyModel;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class LayoutGenerator {
    private final LayoutModel layout;
    private ProcessingEnvironment processingEnv;
    private final TypeMirror dispatchDefaultValue;

    public LayoutGenerator(LayoutModel layout, ProcessingEnvironment processingEnv) {
        this.layout = layout;
        this.processingEnv = processingEnv;
        this.dispatchDefaultValue = processingEnv.getElementUtils().getTypeElement("com.oracle.truffle.api.object.dsl.Layout.DispatchDefaultValue").asType();
    }

    public void generate(PrintStream stream) {
        stream.printf("package %s;%n", this.layout.getPackageName());
        stream.println();
        this.generateImports(stream);
        stream.println();
        stream.printf("@GeneratedBy(%s.class)%n", this.layout.getInterfaceFullName());
        stream.printf("public class %sLayoutImpl", this.layout.getName());
        if (this.layout.getSuperLayout() != null) {
            stream.printf(" extends %sLayoutImpl", this.layout.getSuperLayout().getName());
        }
        stream.printf(" implements %sLayout {%n", this.layout.getName());
        stream.println("    ");
        stream.printf("    public static final %sLayout INSTANCE = new %sLayoutImpl();%n", this.layout.getName(), this.layout.getName());
        stream.println("    ");
        this.generateObjectType(stream);
        if (!this.layout.hasShapeProperties()) {
            stream.printf("    protected static final %sType %s_TYPE = new %sType();%n", this.layout.getName(), NameUtils.identifierToConstant(this.layout.getName()), this.layout.getName());
            stream.println("    ");
        }
        this.generateAllocator(stream);
        this.generateProperties(stream);
        if (!this.layout.hasShapeProperties()) {
            stream.printf("    private static final DynamicObjectFactory %s_FACTORY = create%sShape();%n", NameUtils.identifierToConstant(this.layout.getName()), this.layout.getName());
            stream.println("    ");
        }
        stream.printf("    protected %sLayoutImpl() {%n", this.layout.getName());
        stream.println("    }");
        stream.println("    ");
        this.generateShapeFactory(stream);
        this.generateFactory(stream);
        this.generateGuards(stream);
        this.generateAccessors(stream);
        stream.println("}");
    }

    private void generateImports(PrintStream stream) {
        boolean needsAtomicInteger = false;
        boolean needsAtomicBoolean = false;
        boolean needsAtomicReference = false;
        boolean needsIncompatibleLocationException = false;
        boolean needsFinalLocationException = false;
        boolean needsHiddenKey = false;
        boolean needsBoundary = false;
        for (PropertyModel property : this.layout.getProperties()) {
            if (!property.isShapeProperty() && !property.hasIdentifier()) {
                needsHiddenKey = true;
            }
            if (property.isVolatile()) {
                if (property.getType().getKind() == TypeKind.INT) {
                    needsAtomicInteger = true;
                } else if (property.getType().getKind() == TypeKind.BOOLEAN) {
                    needsAtomicBoolean = true;
                } else {
                    needsAtomicReference = true;
                }
            } else if (property.hasSetter() && !property.isShapeProperty()) {
                needsIncompatibleLocationException = true;
                needsFinalLocationException = true;
            }
            if (!property.isShapeProperty() || !property.hasSetter() && !property.hasShapeSetter()) continue;
            needsBoundary = true;
        }
        if (this.layout.hasFinalInstanceProperties() || this.layout.hasNonNullableInstanceProperties()) {
            stream.println("import java.util.EnumSet;");
        }
        if (needsAtomicBoolean) {
            stream.println("import java.util.concurrent.atomic.AtomicBoolean;");
        }
        if (needsAtomicInteger) {
            stream.println("import java.util.concurrent.atomic.AtomicInteger;");
        }
        if (needsAtomicReference) {
            stream.println("import java.util.concurrent.atomic.AtomicReference;");
        }
        if (!this.layout.hasBuilder()) {
            stream.println("import com.oracle.truffle.api.CompilerAsserts;");
        }
        stream.println("import com.oracle.truffle.api.dsl.GeneratedBy;");
        if (needsBoundary) {
            stream.println("import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;");
        }
        stream.println("import com.oracle.truffle.api.object.DynamicObject;");
        stream.println("import com.oracle.truffle.api.object.DynamicObjectFactory;");
        if (needsFinalLocationException) {
            stream.println("import com.oracle.truffle.api.object.FinalLocationException;");
        }
        if (needsHiddenKey) {
            stream.println("import com.oracle.truffle.api.object.HiddenKey;");
        }
        if (needsIncompatibleLocationException) {
            stream.println("import com.oracle.truffle.api.object.IncompatibleLocationException;");
        }
        if (this.layout.getSuperLayout() == null) {
            stream.println("import com.oracle.truffle.api.object.Layout;");
        }
        if (this.layout.hasFinalInstanceProperties() || this.layout.hasNonNullableInstanceProperties()) {
            stream.println("import com.oracle.truffle.api.object.LocationModifier;");
        }
        stream.println("import com.oracle.truffle.api.object.ObjectType;");
        if (!this.layout.getInstanceProperties().isEmpty()) {
            stream.println("import com.oracle.truffle.api.object.Property;");
        }
        stream.println("import com.oracle.truffle.api.object.Shape;");
        stream.printf("import %s;%n", this.layout.getInterfaceFullName());
        if (this.layout.getSuperLayout() != null) {
            stream.printf("import %s.%sLayoutImpl;%n", this.layout.getSuperLayout().getPackageName(), this.layout.getSuperLayout().getName());
        }
    }

    private void generateObjectType(final PrintStream stream) {
        String typeSuperclass = this.layout.getSuperLayout() == null ? this.layout.getObjectTypeSuperclass().toString() : this.layout.getSuperLayout().getName() + "LayoutImpl." + this.layout.getSuperLayout().getName() + "Type";
        stream.printf("    public static class %sType extends %s {%n", this.layout.getName(), typeSuperclass);
        if (!this.processingEnv.getTypeUtils().isSameType(this.layout.getDispatch(), this.dispatchDefaultValue)) {
            stream.println("        ");
            stream.println("        @Override");
            stream.println("        public Class<?> dispatch() {");
            stream.printf("            return %s.class;%n", this.layout.getDispatch().toString());
            stream.println("        }");
        }
        if (this.layout.hasShapeProperties()) {
            stream.println("        ");
            for (PropertyModel property : this.layout.getShapeProperties()) {
                stream.printf("        protected final %s %s;%n", property.getType(), property.getName());
            }
            if (!this.layout.getShapeProperties().isEmpty()) {
                stream.println("        ");
            }
            stream.printf("        public %sType(%n", this.layout.getName());
            LayoutGenerator.iterateProperties(this.layout.getAllShapeProperties(), new PropertyIteratorAction(){

                @Override
                public void run(PropertyModel property, boolean last) {
                    stream.printf("                %s %s", property.getType().toString(), property.getName());
                    if (last) {
                        stream.println(") {");
                    } else {
                        stream.println(",");
                    }
                }
            });
            if (!this.layout.getInheritedShapeProperties().isEmpty()) {
                stream.println("            super(");
                LayoutGenerator.iterateProperties(this.layout.getInheritedShapeProperties(), new PropertyIteratorAction(){

                    @Override
                    public void run(PropertyModel property, boolean last) {
                        stream.printf("                %s", property.getName());
                        if (last) {
                            stream.println(");");
                        } else {
                            stream.println(",");
                        }
                    }
                });
            }
            LayoutGenerator.iterateProperties(this.layout.getShapeProperties(), new PropertyIteratorAction(){

                @Override
                public void run(PropertyModel property, boolean last) {
                    stream.printf("            this.%s = %s;%n", property.getName(), property.getName());
                }
            });
            stream.println("        }");
            stream.println("        ");
            for (PropertyModel property : this.layout.getAllShapeProperties()) {
                boolean inherited;
                boolean bl = inherited = !this.layout.getShapeProperties().contains(property);
                if (!inherited) {
                    stream.printf("        public %s %s() {%n", property.getType(), NameUtils.asGetter(property.getName()));
                    stream.printf("            return %s;%n", property.getName());
                    stream.println("        }");
                    stream.println("        ");
                }
                if (inherited) {
                    stream.println("        @Override");
                }
                stream.printf("        public %sType %s(%s %s) {%n", this.layout.getName(), NameUtils.asSetter(property.getName()), property.getType(), property.getName());
                stream.printf("            return new %sType(%n", this.layout.getName());
                LayoutGenerator.iterateProperties(this.layout.getAllShapeProperties(), new PropertyIteratorAction(){

                    @Override
                    public void run(PropertyModel p, boolean last) {
                        stream.printf("                %s", p.getName());
                        if (last) {
                            stream.println(");");
                        } else {
                            stream.println(",");
                        }
                    }
                });
                stream.println("        }");
                stream.println("        ");
            }
        } else {
            stream.println("        ");
        }
        stream.println("    }");
        stream.println("    ");
    }

    private void generateAllocator(PrintStream stream) {
        if (this.layout.getSuperLayout() == null) {
            stream.print("    protected static final Layout LAYOUT = Layout.newLayout()");
            for (VariableElement implicitCast : this.layout.getImplicitCasts()) {
                stream.print(".addAllowedImplicitCast(Layout.ImplicitCast.");
                stream.print(implicitCast.getSimpleName().toString());
                stream.print(")");
            }
            stream.println(".build();");
            stream.printf("    protected static final Shape.Allocator %S_ALLOCATOR = LAYOUT.createAllocator();%n", NameUtils.identifierToConstant(this.layout.getName()));
        } else {
            stream.printf("    protected static final Shape.Allocator %S_ALLOCATOR = LAYOUT.createAllocator();%n", NameUtils.identifierToConstant(this.layout.getName()));
            stream.println("    ");
            if (this.layout.getSuperLayout().hasInstanceProperties()) {
                stream.println("    static {");
                for (PropertyModel property : this.layout.getSuperLayout().getAllInstanceProperties()) {
                    String modifiersExpression;
                    ArrayList<String> modifiers = new ArrayList<String>();
                    if (!property.isNullable()) {
                        modifiers.add("LocationModifier.NonNull");
                    }
                    if (property.isFinal()) {
                        modifiers.add("LocationModifier.Final");
                    }
                    if (modifiers.isEmpty()) {
                        modifiersExpression = "";
                    } else {
                        StringBuilder modifiersExpressionBuilder = new StringBuilder();
                        modifiersExpressionBuilder.append(", EnumSet.of(");
                        for (String modifier : modifiers) {
                            if (!modifier.equals(modifiers.get(0))) {
                                modifiersExpressionBuilder.append(", ");
                            }
                            modifiersExpressionBuilder.append(modifier);
                        }
                        modifiersExpressionBuilder.append(")");
                        modifiersExpression = modifiersExpressionBuilder.toString();
                    }
                    String locationType = property.isVolatile() ? (property.getType().getKind() == TypeKind.INT ? "AtomicInteger" : (property.getType().getKind() == TypeKind.BOOLEAN ? "AtomicBoolean" : "AtomicReference")) : NameUtils.typeWithoutParameters(property.getType().toString());
                    stream.printf("         %s_ALLOCATOR.locationForType(%s.class%s);%n", NameUtils.identifierToConstant(this.layout.getName()), locationType, modifiersExpression);
                }
                stream.println("    }");
                stream.println("    ");
            }
        }
    }

    private void generateProperties(PrintStream stream) {
        for (PropertyModel property : this.layout.getInstanceProperties()) {
            String modifiersExpression;
            if (!property.hasIdentifier()) {
                stream.printf("    protected static final HiddenKey %s_IDENTIFIER = new HiddenKey(\"%s\");%n", NameUtils.identifierToConstant(property.getName()), property.getName());
            }
            ArrayList<String> modifiers = new ArrayList<String>();
            if (!property.isNullable()) {
                modifiers.add("LocationModifier.NonNull");
            }
            if (property.isFinal()) {
                modifiers.add("LocationModifier.Final");
            }
            if (modifiers.isEmpty()) {
                modifiersExpression = "";
            } else {
                StringBuilder modifiersExpressionBuilder = new StringBuilder();
                modifiersExpressionBuilder.append(", EnumSet.of(");
                for (String modifier : modifiers) {
                    if (!modifier.equals(modifiers.get(0))) {
                        modifiersExpressionBuilder.append(", ");
                    }
                    modifiersExpressionBuilder.append(modifier);
                }
                modifiersExpressionBuilder.append(")");
                modifiersExpression = modifiersExpressionBuilder.toString();
            }
            String locationType = property.isVolatile() ? (property.getType().getKind() == TypeKind.INT ? "AtomicInteger" : (property.getType().getKind() == TypeKind.BOOLEAN ? "AtomicBoolean" : "AtomicReference")) : NameUtils.typeWithoutParameters(property.getType().toString());
            stream.printf("    protected static final Property %S_PROPERTY = Property.create(%s_IDENTIFIER, %S_ALLOCATOR.locationForType(%s.class%s), 0);%n", NameUtils.identifierToConstant(property.getName()), NameUtils.identifierToConstant(property.getName()), NameUtils.identifierToConstant(this.layout.getName()), locationType, modifiersExpression);
            stream.println("    ");
        }
    }

    private void generateShapeFactory(final PrintStream stream) {
        if (this.layout.hasShapeProperties()) {
            stream.println("    @Override");
            stream.print("    public");
        } else {
            stream.print("    private static");
        }
        stream.printf(" DynamicObjectFactory create%sShape(", this.layout.getName());
        if (this.layout.hasShapeProperties()) {
            stream.println();
            for (PropertyModel property : this.layout.getAllShapeProperties()) {
                stream.printf("            %s %s", property.getType().toString(), property.getName());
                if (property == this.layout.getAllShapeProperties().get(this.layout.getAllShapeProperties().size() - 1)) {
                    stream.println(") {");
                    continue;
                }
                stream.println(",");
            }
        } else {
            stream.println(") {");
        }
        stream.printf("        return LAYOUT.createShape(new %sType(", this.layout.getName());
        if (this.layout.hasShapeProperties()) {
            stream.println();
            LayoutGenerator.iterateProperties(this.layout.getAllShapeProperties(), new PropertyIteratorAction(){

                @Override
                public void run(PropertyModel property, boolean last) {
                    stream.printf("                %s", property.getName());
                    if (last) {
                        stream.println("))");
                    } else {
                        stream.println(",");
                    }
                }
            });
        } else {
            stream.println("))");
        }
        LayoutGenerator.iterateProperties(this.layout.getAllInstanceProperties(), new PropertyIteratorAction(){

            @Override
            public void run(PropertyModel property, boolean last) {
                stream.printf("            .addProperty(%s_PROPERTY)%n", NameUtils.identifierToConstant(property.getName()));
            }
        });
        stream.println("            .createFactory();");
        stream.println("    }");
        stream.println("    ");
    }

    private void generateFactory(PrintStream stream) {
        String returnType;
        boolean builder;
        if (!this.layout.hasShapeProperties()) {
            stream.println("    @Override");
            stream.printf("    public DynamicObject create%s(", this.layout.getName());
            if (this.layout.getAllProperties().isEmpty()) {
                stream.println(") {");
            } else {
                stream.println();
                for (PropertyModel property : this.layout.getAllProperties()) {
                    stream.printf("            %s %s", property.getType().toString(), property.getName());
                    if (property == this.layout.getAllProperties().get(this.layout.getAllProperties().size() - 1)) {
                        stream.println(") {");
                        continue;
                    }
                    stream.println(",");
                }
            }
            stream.printf("        return create%s(%s_FACTORY", this.layout.getName(), NameUtils.identifierToConstant(this.layout.getName()));
            if (this.layout.getAllProperties().isEmpty()) {
                stream.println(");");
            } else {
                stream.println(",");
                for (PropertyModel property : this.layout.getAllProperties()) {
                    stream.printf("            %s", property.getName());
                    if (property == this.layout.getAllProperties().get(this.layout.getAllProperties().size() - 1)) {
                        stream.println(");");
                        continue;
                    }
                    stream.println(",");
                }
            }
            stream.println("    }");
            stream.println("    ");
        }
        String methodName = (builder = this.layout.hasBuilder()) ? "build" : "create" + this.layout.getName();
        String string = returnType = builder ? "Object[]" : "DynamicObject";
        if (this.layout.hasShapeProperties()) {
            stream.println("    @Override");
            stream.print("    public");
        } else {
            stream.print("    private");
            if (!this.layout.hasObjectTypeGuard()) {
                stream.printf(" static", new Object[0]);
            }
        }
        if (this.layout.hasInstanceProperties()) {
            stream.printf(" %s %s(%n", returnType, methodName);
            if (!builder) {
                stream.println("            DynamicObjectFactory factory,");
            }
            for (PropertyModel property : this.layout.getAllInstanceProperties()) {
                stream.printf("            %s %s", property.getType().toString(), property.getName());
                if (property == this.layout.getAllProperties().get(this.layout.getAllProperties().size() - 1)) {
                    stream.println(") {");
                    continue;
                }
                stream.println(",");
            }
        } else {
            String factoryArg = builder ? "" : "DynamicObjectFactory factory";
            stream.printf(" %s %s(%s) {%n", returnType, methodName, factoryArg);
        }
        if (!builder) {
            stream.println("        assert factory != null;");
            stream.println("        CompilerAsserts.partialEvaluationConstant(factory);");
            stream.printf("        assert creates%s(factory);%n", this.layout.getName());
            for (PropertyModel property : this.layout.getAllInstanceProperties()) {
                stream.printf("        assert factory.getShape().hasProperty(%s_IDENTIFIER);%n", NameUtils.identifierToConstant(property.getName()));
            }
        }
        for (PropertyModel property : this.layout.getAllInstanceProperties()) {
            if (property.getType().getKind().isPrimitive() || property.isNullable()) continue;
            stream.printf("        assert %s != null;%n", property.getName());
        }
        if (this.layout.hasInstanceProperties()) {
            if (builder) {
                stream.println("        return new Object[] { ");
            } else {
                stream.println("        return factory.newInstance(");
            }
            for (PropertyModel property : this.layout.getAllInstanceProperties()) {
                if (property.isVolatile()) {
                    if (property.getType().getKind() == TypeKind.INT) {
                        stream.printf("            new AtomicInteger(%s)", property.getName());
                    } else if (property.getType().getKind() == TypeKind.BOOLEAN) {
                        stream.printf("            new AtomicBoolean(%s)", property.getName());
                    } else {
                        stream.printf("            new AtomicReference<>(%s)", property.getName());
                    }
                } else {
                    stream.printf("            %s", property.getName());
                }
                if (property == this.layout.getAllProperties().get(this.layout.getAllProperties().size() - 1)) {
                    stream.println(builder ? " };" : ");");
                    continue;
                }
                stream.println(",");
            }
        } else if (builder) {
            stream.println("        return new Object[0];");
        } else {
            stream.println("        return factory.newInstance();");
        }
        stream.println("    }");
        stream.println("    ");
    }

    private void generateGuards(PrintStream stream) {
        if (this.layout.hasObjectGuard()) {
            stream.println("    @Override");
            stream.printf("    public boolean is%s(Object object) {%n", this.layout.getName());
            stream.printf("        return (object instanceof DynamicObject) && is%s((DynamicObject) object);%n", this.layout.getName());
            stream.println("    }");
            stream.println("    ");
        }
        if (this.layout.hasDynamicObjectGuard() || this.layout.hasGettersOrSetters()) {
            if (this.layout.hasDynamicObjectGuard()) {
                stream.println("    @Override");
                stream.print("    public");
            } else {
                stream.print("    private");
            }
            if (!this.layout.hasDynamicObjectGuard() && !this.layout.hasObjectTypeGuard()) {
                stream.printf(" static", new Object[0]);
            }
            stream.printf(" boolean is%s(DynamicObject object) {%n", this.layout.getName());
            stream.printf("        return is%s(object.getShape().getObjectType());%n", this.layout.getName());
            stream.println("    }");
            stream.println("    ");
        }
        if (this.layout.hasObjectTypeGuard()) {
            stream.println("    @Override");
            stream.print("    public");
        } else {
            stream.print("    private static");
        }
        stream.printf(" boolean is%s(ObjectType objectType) {%n", this.layout.getName());
        stream.printf("        return objectType instanceof %sType;%n", this.layout.getName());
        stream.println("    }");
        if (!this.layout.hasBuilder()) {
            stream.println("    ");
            stream.printf("    private", new Object[0]);
            if (!this.layout.hasObjectTypeGuard()) {
                stream.printf(" static", new Object[0]);
            }
            stream.printf(" boolean creates%s(DynamicObjectFactory factory) {%n", this.layout.getName());
            stream.printf("        return is%s(factory.getShape().getObjectType());%n", this.layout.getName());
            stream.println("    }");
        }
        stream.println("    ");
    }

    private void generateAccessors(PrintStream stream) {
        for (PropertyModel property : this.layout.getProperties()) {
            if (property.hasObjectTypeGetter()) {
                stream.println("    @Override");
                stream.printf("    public %s %s(ObjectType objectType) {%n", property.getType(), NameUtils.asGetter(property.getName()));
                stream.printf("        assert is%s(objectType);%n", this.layout.getName());
                stream.printf("        return ((%sType) objectType).%s();%n", this.layout.getName(), NameUtils.asGetter(property.getName()));
                stream.println("    }");
                stream.println("    ");
            }
            if (property.hasShapeGetter()) {
                stream.println("    @Override");
                stream.printf("    public %s %s(DynamicObjectFactory factory) {%n", property.getType(), NameUtils.asGetter(property.getName()));
                stream.printf("        assert creates%s(factory);%n", this.layout.getName());
                stream.printf("        return ((%sType) factory.getShape().getObjectType()).%s();%n", this.layout.getName(), NameUtils.asGetter(property.getName()));
                stream.println("    }");
                stream.println("    ");
            }
            if (property.hasGetter()) {
                LayoutGenerator.addUncheckedCastWarning(stream, property);
                stream.println("    @Override");
                stream.printf("    public %s %s(DynamicObject object) {%n", property.getType(), NameUtils.asGetter(property.getName()));
                stream.printf("        assert is%s(object);%n", this.layout.getName());
                if (property.isShapeProperty()) {
                    stream.printf("        return getObjectType(object).%s();%n", NameUtils.asGetter(property.getName()));
                } else {
                    stream.printf("        assert object.getShape().hasProperty(%s_IDENTIFIER);%n", NameUtils.identifierToConstant(property.getName()));
                    stream.println("        ");
                    if (property.isVolatile()) {
                        if (property.getType().getKind() == TypeKind.INT) {
                            stream.printf("        return ((AtomicInteger) %s_PROPERTY.get(object, is%s(object))).get();%n", NameUtils.identifierToConstant(property.getName()), this.layout.getName());
                        } else if (property.getType().getKind() == TypeKind.BOOLEAN) {
                            stream.printf("        return ((AtomicBoolean) %s_PROPERTY.get(object, is%s(object))).get();%n", NameUtils.identifierToConstant(property.getName()), this.layout.getName());
                        } else {
                            stream.printf("        return ((AtomicReference<%s>) %s_PROPERTY.get(object, is%s(object))).get();%n", property.getType(), NameUtils.identifierToConstant(property.getName()), this.layout.getName());
                        }
                    } else {
                        stream.printf("        return %s%s_PROPERTY.get(object, is%s(object));%n", LayoutGenerator.cast(property.getType()), NameUtils.identifierToConstant(property.getName()), this.layout.getName());
                    }
                }
                stream.println("    }");
                stream.println("    ");
            }
            if (property.hasShapeSetter()) {
                stream.println("    @TruffleBoundary");
                stream.println("    @Override");
                stream.printf("    public DynamicObjectFactory %s(DynamicObjectFactory factory, %s value) {%n", NameUtils.asSetter(property.getName()), property.getType());
                stream.printf("        assert creates%s(factory);%n", this.layout.getName());
                stream.println("        final Shape shape = factory.getShape();");
                stream.printf("        return shape.changeType(((%sType) shape.getObjectType()).%s(value)).createFactory();%n", this.layout.getName(), NameUtils.asSetter(property.getName()));
                stream.println("    }");
                stream.println("    ");
            }
            if (property.hasSetter() || property.hasUnsafeSetter()) {
                LayoutGenerator.addUncheckedCastWarning(stream, property);
                if (property.isShapeProperty()) {
                    stream.println("    @TruffleBoundary");
                }
                stream.println("    @Override");
                String methodNameSuffix = property.hasUnsafeSetter() ? "Unsafe" : "";
                stream.printf("    public void %s%s(DynamicObject object, %s value) {%n", NameUtils.asSetter(property.getName()), methodNameSuffix, property.getType());
                stream.printf("        assert is%s(object);%n", this.layout.getName());
                if (property.isShapeProperty()) {
                    stream.println("        final Shape shape = object.getShape();");
                    stream.printf("        object.setShapeAndGrow(shape, shape.changeType(getObjectType(object).%s(value)));%n", NameUtils.asSetter(property.getName()));
                } else {
                    stream.printf("        assert object.getShape().hasProperty(%s_IDENTIFIER);%n", NameUtils.identifierToConstant(property.getName()));
                    if (!property.getType().getKind().isPrimitive() && !property.isNullable()) {
                        stream.println("        assert value != null;");
                    }
                    stream.println("        ");
                    if (property.hasUnsafeSetter()) {
                        stream.printf("        %s_PROPERTY.setInternal(object, value);%n", NameUtils.identifierToConstant(property.getName()));
                    } else if (property.isVolatile()) {
                        if (property.getType().getKind() == TypeKind.INT) {
                            stream.printf("        ((AtomicInteger) %s_PROPERTY.get(object, is%s(object))).set(value);%n", NameUtils.identifierToConstant(property.getName()), this.layout.getName());
                        } else if (property.getType().getKind() == TypeKind.BOOLEAN) {
                            stream.printf("        ((AtomicBoolean) %s_PROPERTY.get(object, is%s(object))).set(value);%n", NameUtils.identifierToConstant(property.getName()), this.layout.getName());
                        } else {
                            stream.printf("        ((AtomicReference<%s>) %s_PROPERTY.get(object, is%s(object))).set(value);%n", property.getType(), NameUtils.identifierToConstant(property.getName()), this.layout.getName());
                        }
                    } else {
                        stream.printf("        try {%n", new Object[0]);
                        stream.printf("            %s_PROPERTY.set(object, value, object.getShape());%n", NameUtils.identifierToConstant(property.getName()));
                        stream.printf("        } catch (IncompatibleLocationException | FinalLocationException e) {%n", new Object[0]);
                        stream.printf("            throw new UnsupportedOperationException(e);%n", new Object[0]);
                        stream.printf("        }%n", new Object[0]);
                    }
                }
                stream.println("    }");
                stream.println("    ");
            }
            if (property.hasCompareAndSet()) {
                LayoutGenerator.addUncheckedCastWarning(stream, property);
                stream.println("    @Override");
                stream.printf("    public boolean %s(DynamicObject object, %s expected_value, %s value) {%n", NameUtils.asCompareAndSet(property.getName()), property.getType(), property.getType());
                stream.printf("        assert is%s(object);%n", this.layout.getName());
                stream.printf("        assert object.getShape().hasProperty(%s_IDENTIFIER);%n", NameUtils.identifierToConstant(property.getName()));
                if (!property.getType().getKind().isPrimitive() && !property.isNullable()) {
                    stream.println("        assert value != null;");
                }
                if (property.getType().getKind() == TypeKind.INT) {
                    stream.printf("        return ((AtomicInteger) %s_PROPERTY.get(object, is%s(object))).compareAndSet(expected_value, value);%n", NameUtils.identifierToConstant(property.getName()), this.layout.getName());
                } else if (property.getType().getKind() == TypeKind.BOOLEAN) {
                    stream.printf("        return ((AtomicBoolean) %s_PROPERTY.get(object, is%s(object))).compareAndSet(expected_value, value);%n", NameUtils.identifierToConstant(property.getName()), this.layout.getName());
                } else {
                    stream.printf("        return ((AtomicReference<%s>) %s_PROPERTY.get(object, is%s(object))).compareAndSet(expected_value, value);%n", property.getType(), NameUtils.identifierToConstant(property.getName()), this.layout.getName());
                }
                stream.println("    }");
                stream.println("    ");
            }
            if (!property.hasGetAndSet()) continue;
            LayoutGenerator.addUncheckedCastWarning(stream, property);
            stream.println("    @Override");
            stream.printf("    public %s %s(DynamicObject object, %s value) {%n", property.getType(), NameUtils.asGetAndSet(property.getName()), property.getType());
            stream.printf("        assert is%s(object);%n", this.layout.getName());
            stream.printf("        assert object.getShape().hasProperty(%s_IDENTIFIER);%n", NameUtils.identifierToConstant(property.getName()));
            if (!property.getType().getKind().isPrimitive() && !property.isNullable()) {
                stream.println("        assert value != null;");
            }
            if (property.getType().getKind() == TypeKind.INT) {
                stream.printf("        return ((AtomicInteger) %s_PROPERTY.get(object, is%s(object))).getAndSet(value);%n", NameUtils.identifierToConstant(property.getName()), this.layout.getName());
            } else if (property.getType().getKind() == TypeKind.BOOLEAN) {
                stream.printf("        return ((AtomicBoolean) %s_PROPERTY.get(object, is%s(object))).getAndSet(value);%n", NameUtils.identifierToConstant(property.getName()), this.layout.getName());
            } else {
                stream.printf("        return ((AtomicReference<%s>) %s_PROPERTY.get(object, is%s(object))).getAndSet(value);%n", property.getType(), NameUtils.identifierToConstant(property.getName()), this.layout.getName());
            }
            stream.println("    }");
            stream.println("    ");
        }
        if (!this.layout.getShapeProperties().isEmpty()) {
            stream.print("    private");
            if (!this.layout.hasObjectTypeGuard()) {
                stream.print(" static");
            }
            stream.printf(" %sType getObjectType(DynamicObject object) {%n", this.layout.getName());
            stream.printf("        assert is%s(object);%n", this.layout.getName());
            stream.printf("        return (%sType) object.getShape().getObjectType();%n", this.layout.getName());
            stream.println("    }");
            stream.println("    ");
        }
    }

    private static void addUncheckedCastWarning(PrintStream stream, PropertyModel property) {
        if (property.getType().toString().indexOf(60) != -1 || property.isVolatile() && !property.getType().getKind().isPrimitive()) {
            stream.println("    @SuppressWarnings(\"unchecked\")");
        }
    }

    private static void iterateProperties(List<PropertyModel> properties, PropertyIteratorAction action) {
        for (int n = 0; n < properties.size(); ++n) {
            action.run(properties.get(n), n == properties.size() - 1);
        }
    }

    private static String cast(TypeMirror type) {
        if (type.toString().equals(Object.class.getName())) {
            return "";
        }
        return String.format("(%s) ", type.toString());
    }

    public String getGeneratedClassName() {
        return this.layout.getPackageName() + "." + this.layout.getName() + "LayoutImpl";
    }

    private static interface PropertyIteratorAction {
        public void run(PropertyModel var1, boolean var2);
    }
}

