/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object.dsl.processor;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.object.dsl.processor.LayoutGenerator;
import com.oracle.truffle.object.dsl.processor.LayoutParser;
import com.oracle.truffle.object.dsl.processor.model.LayoutModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"com.oracle.truffle.api.object.dsl.Layout"})
public class LayoutProcessor
extends AbstractProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        ProcessorContext context = ProcessorContext.enter(this.processingEnv);
        try {
            TruffleTypes types = context.getTypes();
            for (Element element : roundEnvironment.getElementsAnnotatedWith(ElementUtils.castTypeElement(types.Layout))) {
                this.processLayout((TypeElement)element);
            }
        }
        finally {
            ProcessorContext.leave();
        }
        return true;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    public ProcessingEnvironment getProcessingEnv() {
        return this.processingEnv;
    }

    private void processLayout(TypeElement layoutElement) {
        try {
            LayoutParser parser = new LayoutParser(this);
            parser.parse(layoutElement);
            LayoutModel layout = parser.build();
            LayoutGenerator generator = new LayoutGenerator(layout, this.processingEnv);
            JavaFileObject output = this.processingEnv.getFiler().createSourceFile(generator.getGeneratedClassName(), layoutElement);
            try (PrintStream stream = new PrintStream(output.openOutputStream(), false, "UTF8");){
                generator.generate(stream);
            }
        }
        catch (IOException e) {
            this.reportError(layoutElement, "IO error %s while writing code generated from @Layout", e.getMessage());
        }
    }

    public void reportError(Element element, String messageFormat, Object ... formatArgs) {
        String message = String.format(messageFormat, formatArgs);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }
}

